<?php

namespace EnumType;

/**
 * This class stands for XPhoneServiceCategory EnumType
 * @subpackage Enumerations
 */
class XPhoneServiceCategory
{
    /**
     * Constant for value 'XML Service'
     * @return string 'XML Service'
     */
    const VALUE_XML_SERVICE = 'XML Service';
    /**
     * Constant for value 'Java MIDlet'
     * @return string 'Java MIDlet'
     */
    const VALUE_JAVA_MIDLET = 'Java MIDlet';
    /**
     * Constant for value 'Web Widget'
     * @return string 'Web Widget'
     */
    const VALUE_WEB_WIDGET = 'Web Widget';
    /**
     * Constant for value 'Web Link'
     * @return string 'Web Link'
     */
    const VALUE_WEB_LINK = 'Web Link';
    /**
     * Constant for value 'Android APK'
     * @return string 'Android APK'
     */
    const VALUE_ANDROID_APK = 'Android APK';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_XML_SERVICE
     * @uses self::VALUE_JAVA_MIDLET
     * @uses self::VALUE_WEB_WIDGET
     * @uses self::VALUE_WEB_LINK
     * @uses self::VALUE_ANDROID_APK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_XML_SERVICE,
            self::VALUE_JAVA_MIDLET,
            self::VALUE_WEB_WIDGET,
            self::VALUE_WEB_LINK,
            self::VALUE_ANDROID_APK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
