<?php

namespace EnumType;

/**
 * This class stands for XPatternRouteClass EnumType
 * @subpackage Enumerations
 */
class XPatternRouteClass
{
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Constant for value 'Voice'
     * @return string 'Voice'
     */
    const VALUE_VOICE = 'Voice';
    /**
     * Constant for value 'Data'
     * @return string 'Data'
     */
    const VALUE_DATA = 'Data';
    /**
     * Constant for value 'Satellite Avoidance'
     * @return string 'Satellite Avoidance'
     */
    const VALUE_SATELLITE_AVOIDANCE = 'Satellite Avoidance';
    /**
     * Constant for value 'Hotline Voice'
     * @return string 'Hotline Voice'
     */
    const VALUE_HOTLINE_VOICE = 'Hotline Voice';
    /**
     * Constant for value 'Hotline Data'
     * @return string 'Hotline Data'
     */
    const VALUE_HOTLINE_DATA = 'Hotline Data';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_VOICE
     * @uses self::VALUE_DATA
     * @uses self::VALUE_SATELLITE_AVOIDANCE
     * @uses self::VALUE_HOTLINE_VOICE
     * @uses self::VALUE_HOTLINE_DATA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_VOICE,
            self::VALUE_DATA,
            self::VALUE_SATELLITE_AVOIDANCE,
            self::VALUE_HOTLINE_VOICE,
            self::VALUE_HOTLINE_DATA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
