<?php

namespace EnumType;

/**
 * This class stands for XLogicalPartitionPolicy EnumType
 * @subpackage Enumerations
 */
class XLogicalPartitionPolicy
{
    /**
     * Constant for value 'Use Default Policy'
     * @return string 'Use Default Policy'
     */
    const VALUE_USE_DEFAULT_POLICY = 'Use Default Policy';
    /**
     * Constant for value 'Allow'
     * @return string 'Allow'
     */
    const VALUE_ALLOW = 'Allow';
    /**
     * Constant for value 'Deny'
     * @return string 'Deny'
     */
    const VALUE_DENY = 'Deny';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USE_DEFAULT_POLICY
     * @uses self::VALUE_ALLOW
     * @uses self::VALUE_DENY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USE_DEFAULT_POLICY,
            self::VALUE_ALLOW,
            self::VALUE_DENY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
