<?php

namespace EnumType;

/**
 * This class stands for XKeyOrder EnumType
 * @subpackage Enumerations
 */
class XKeyOrder
{
    /**
     * Constant for value 'RSA Only'
     * @return string 'RSA Only'
     */
    const VALUE_RSA_ONLY = 'RSA Only';
    /**
     * Constant for value 'EC Only'
     * @return string 'EC Only'
     */
    const VALUE_EC_ONLY = 'EC Only';
    /**
     * Constant for value 'EC Preferred, RSA Backup'
     * @return string 'EC Preferred, RSA Backup'
     */
    const VALUE_EC_PREFERRED_RSA_BACKUP = 'EC Preferred, RSA Backup';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RSA_ONLY
     * @uses self::VALUE_EC_ONLY
     * @uses self::VALUE_EC_PREFERRED_RSA_BACKUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RSA_ONLY,
            self::VALUE_EC_ONLY,
            self::VALUE_EC_PREFERRED_RSA_BACKUP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
