<?php

namespace EnumType;

/**
 * This class stands for XFallBackCSSSelection EnumType
 * @subpackage Enumerations
 */
class XFallBackCSSSelection
{
    /**
     * Constant for value 'Calling device AAR Calling Search Space'
     * @return string 'Calling device AAR Calling Search Space'
     */
    const VALUE_CALLING_DEVICE_AAR_CALLING_SEARCH_SPACE = 'Calling device AAR Calling Search Space';
    /**
     * Constant for value 'Trunk ReRoute Calling Search Space'
     * @return string 'Trunk ReRoute Calling Search Space'
     */
    const VALUE_TRUNK_RE_ROUTE_CALLING_SEARCH_SPACE = 'Trunk ReRoute Calling Search Space';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CALLING_DEVICE_AAR_CALLING_SEARCH_SPACE
     * @uses self::VALUE_TRUNK_RE_ROUTE_CALLING_SEARCH_SPACE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CALLING_DEVICE_AAR_CALLING_SEARCH_SPACE,
            self::VALUE_TRUNK_RE_ROUTE_CALLING_SEARCH_SPACE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
