<?php

namespace EnumType;

/**
 * This class stands for XCredential EnumType
 * @subpackage Enumerations
 */
class XCredential
{
    /**
     * Constant for value 'Password'
     * @return string 'Password'
     */
    const VALUE_PASSWORD = 'Password';
    /**
     * Constant for value 'PIN'
     * @return string 'PIN'
     */
    const VALUE_PIN = 'PIN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PASSWORD
     * @uses self::VALUE_PIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PASSWORD,
            self::VALUE_PIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
