<?php

namespace EnumType;

/**
 * This class stands for XClass EnumType
 * @subpackage Enumerations
 */
class XClass
{
    /**
     * Constant for value 'Phone'
     * @return string 'Phone'
     */
    const VALUE_PHONE = 'Phone';
    /**
     * Constant for value 'Gateway'
     * @return string 'Gateway'
     */
    const VALUE_GATEWAY = 'Gateway';
    /**
     * Constant for value 'Conference Bridge'
     * @return string 'Conference Bridge'
     */
    const VALUE_CONFERENCE_BRIDGE = 'Conference Bridge';
    /**
     * Constant for value 'Media Termination Point'
     * @return string 'Media Termination Point'
     */
    const VALUE_MEDIA_TERMINATION_POINT = 'Media Termination Point';
    /**
     * Constant for value 'Route List'
     * @return string 'Route List'
     */
    const VALUE_ROUTE_LIST = 'Route List';
    /**
     * Constant for value 'Voice Mail'
     * @return string 'Voice Mail'
     */
    const VALUE_VOICE_MAIL = 'Voice Mail';
    /**
     * Constant for value 'CTI Route Point'
     * @return string 'CTI Route Point'
     */
    const VALUE_CTI_ROUTE_POINT = 'CTI Route Point';
    /**
     * Constant for value 'Music On Hold'
     * @return string 'Music On Hold'
     */
    const VALUE_MUSIC_ON_HOLD = 'Music On Hold';
    /**
     * Constant for value 'Simulation'
     * @return string 'Simulation'
     */
    const VALUE_SIMULATION = 'Simulation';
    /**
     * Constant for value 'Pilot'
     * @return string 'Pilot'
     */
    const VALUE_PILOT = 'Pilot';
    /**
     * Constant for value 'GateKeeper'
     * @return string 'GateKeeper'
     */
    const VALUE_GATE_KEEPER = 'GateKeeper';
    /**
     * Constant for value 'Add-on modules'
     * @return string 'Add-on modules'
     */
    const VALUE_ADD_ON_MODULES = 'Add-on modules';
    /**
     * Constant for value 'Hidden Phone'
     * @return string 'Hidden Phone'
     */
    const VALUE_HIDDEN_PHONE = 'Hidden Phone';
    /**
     * Constant for value 'Trunk'
     * @return string 'Trunk'
     */
    const VALUE_TRUNK = 'Trunk';
    /**
     * Constant for value 'Tone Announcement Player'
     * @return string 'Tone Announcement Player'
     */
    const VALUE_TONE_ANNOUNCEMENT_PLAYER = 'Tone Announcement Player';
    /**
     * Constant for value 'Remote Destination Profile'
     * @return string 'Remote Destination Profile'
     */
    const VALUE_REMOTE_DESTINATION_PROFILE = 'Remote Destination Profile';
    /**
     * Constant for value 'EMCC Base Phone Template'
     * @return string 'EMCC Base Phone Template'
     */
    const VALUE_EMCC_BASE_PHONE_TEMPLATE = 'EMCC Base Phone Template';
    /**
     * Constant for value 'EMCC Base Phone'
     * @return string 'EMCC Base Phone'
     */
    const VALUE_EMCC_BASE_PHONE = 'EMCC Base Phone';
    /**
     * Constant for value 'Remote Destination Profile Template'
     * @return string 'Remote Destination Profile Template'
     */
    const VALUE_REMOTE_DESTINATION_PROFILE_TEMPLATE = 'Remote Destination Profile Template';
    /**
     * Constant for value 'Gateway Template'
     * @return string 'Gateway Template'
     */
    const VALUE_GATEWAY_TEMPLATE = 'Gateway Template';
    /**
     * Constant for value 'UDP Template'
     * @return string 'UDP Template'
     */
    const VALUE_UDP_TEMPLATE = 'UDP Template';
    /**
     * Constant for value 'Phone Template'
     * @return string 'Phone Template'
     */
    const VALUE_PHONE_TEMPLATE = 'Phone Template';
    /**
     * Constant for value 'Device Profile'
     * @return string 'Device Profile'
     */
    const VALUE_DEVICE_PROFILE = 'Device Profile';
    /**
     * Constant for value 'Invalid'
     * @return string 'Invalid'
     */
    const VALUE_INVALID = 'Invalid';
    /**
     * Constant for value 'Interactive Voice Response'
     * @return string 'Interactive Voice Response'
     */
    const VALUE_INTERACTIVE_VOICE_RESPONSE = 'Interactive Voice Response';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PHONE
     * @uses self::VALUE_GATEWAY
     * @uses self::VALUE_CONFERENCE_BRIDGE
     * @uses self::VALUE_MEDIA_TERMINATION_POINT
     * @uses self::VALUE_ROUTE_LIST
     * @uses self::VALUE_VOICE_MAIL
     * @uses self::VALUE_CTI_ROUTE_POINT
     * @uses self::VALUE_MUSIC_ON_HOLD
     * @uses self::VALUE_SIMULATION
     * @uses self::VALUE_PILOT
     * @uses self::VALUE_GATE_KEEPER
     * @uses self::VALUE_ADD_ON_MODULES
     * @uses self::VALUE_HIDDEN_PHONE
     * @uses self::VALUE_TRUNK
     * @uses self::VALUE_TONE_ANNOUNCEMENT_PLAYER
     * @uses self::VALUE_REMOTE_DESTINATION_PROFILE
     * @uses self::VALUE_EMCC_BASE_PHONE_TEMPLATE
     * @uses self::VALUE_EMCC_BASE_PHONE
     * @uses self::VALUE_REMOTE_DESTINATION_PROFILE_TEMPLATE
     * @uses self::VALUE_GATEWAY_TEMPLATE
     * @uses self::VALUE_UDP_TEMPLATE
     * @uses self::VALUE_PHONE_TEMPLATE
     * @uses self::VALUE_DEVICE_PROFILE
     * @uses self::VALUE_INVALID
     * @uses self::VALUE_INTERACTIVE_VOICE_RESPONSE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PHONE,
            self::VALUE_GATEWAY,
            self::VALUE_CONFERENCE_BRIDGE,
            self::VALUE_MEDIA_TERMINATION_POINT,
            self::VALUE_ROUTE_LIST,
            self::VALUE_VOICE_MAIL,
            self::VALUE_CTI_ROUTE_POINT,
            self::VALUE_MUSIC_ON_HOLD,
            self::VALUE_SIMULATION,
            self::VALUE_PILOT,
            self::VALUE_GATE_KEEPER,
            self::VALUE_ADD_ON_MODULES,
            self::VALUE_HIDDEN_PHONE,
            self::VALUE_TRUNK,
            self::VALUE_TONE_ANNOUNCEMENT_PLAYER,
            self::VALUE_REMOTE_DESTINATION_PROFILE,
            self::VALUE_EMCC_BASE_PHONE_TEMPLATE,
            self::VALUE_EMCC_BASE_PHONE,
            self::VALUE_REMOTE_DESTINATION_PROFILE_TEMPLATE,
            self::VALUE_GATEWAY_TEMPLATE,
            self::VALUE_UDP_TEMPLATE,
            self::VALUE_PHONE_TEMPLATE,
            self::VALUE_DEVICE_PROFILE,
            self::VALUE_INVALID,
            self::VALUE_INTERACTIVE_VOICE_RESPONSE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
