<?php

namespace EnumType;

/**
 * This class stands for XCertificateVerificationLevel EnumType
 * @subpackage Enumerations
 */
class XCertificateVerificationLevel
{
    /**
     * Constant for value 'Any Certificate'
     * @return string 'Any Certificate'
     */
    const VALUE_ANY_CERTIFICATE = 'Any Certificate';
    /**
     * Constant for value 'Self-signed or Keystore'
     * @return string 'Self-signed or Keystore'
     */
    const VALUE_SELF_SIGNED_OR_KEYSTORE = 'Self-signed or Keystore';
    /**
     * Constant for value 'Keystore Only'
     * @return string 'Keystore Only'
     */
    const VALUE_KEYSTORE_ONLY = 'Keystore Only';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANY_CERTIFICATE
     * @uses self::VALUE_SELF_SIGNED_OR_KEYSTORE
     * @uses self::VALUE_KEYSTORE_ONLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANY_CERTIFICATE,
            self::VALUE_SELF_SIGNED_OR_KEYSTORE,
            self::VALUE_KEYSTORE_ONLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
