<?php

namespace EnumType;

/**
 * This class stands for XAuthenticationType EnumType
 * @subpackage Enumerations
 */
class XAuthenticationType
{
    /**
     * Constant for value 'LDAP'
     * @return string 'LDAP'
     */
    const VALUE_LDAP = 'LDAP';
    /**
     * Constant for value 'Local'
     * @return string 'Local'
     */
    const VALUE_LOCAL = 'Local';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LDAP
     * @uses self::VALUE_LOCAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LDAP,
            self::VALUE_LOCAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
