<?php

namespace EnumType;

/**
 * This class stands for XAuthenticationMode EnumType
 * @subpackage Enumerations
 */
class XAuthenticationMode
{
    /**
     * Constant for value 'By Authentication String'
     * @return string 'By Authentication String'
     */
    const VALUE_BY_AUTHENTICATION_STRING = 'By Authentication String';
    /**
     * Constant for value 'By Null String'
     * @return string 'By Null String'
     */
    const VALUE_BY_NULL_STRING = 'By Null String';
    /**
     * Constant for value 'By Existing Certificate (precedence to LSC)'
     * @return string 'By Existing Certificate (precedence to LSC)'
     */
    const VALUE_BY_EXISTING_CERTIFICATE_PRECEDENCE_TO_LSC = 'By Existing Certificate (precedence to LSC)';
    /**
     * Constant for value 'By Existing Certificate (precedence to MIC)'
     * @return string 'By Existing Certificate (precedence to MIC)'
     */
    const VALUE_BY_EXISTING_CERTIFICATE_PRECEDENCE_TO_MIC = 'By Existing Certificate (precedence to MIC)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BY_AUTHENTICATION_STRING
     * @uses self::VALUE_BY_NULL_STRING
     * @uses self::VALUE_BY_EXISTING_CERTIFICATE_PRECEDENCE_TO_LSC
     * @uses self::VALUE_BY_EXISTING_CERTIFICATE_PRECEDENCE_TO_MIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BY_AUTHENTICATION_STRING,
            self::VALUE_BY_NULL_STRING,
            self::VALUE_BY_EXISTING_CERTIFICATE_PRECEDENCE_TO_LSC,
            self::VALUE_BY_EXISTING_CERTIFICATE_PRECEDENCE_TO_MIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
