<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipDialRules StructType
 * @subpackage Structs
 */
class XSipDialRules extends AbstractStructBase
{
    /**
     * The dialPattern
     * Meta informations extracted from the WSDL
     * - default: 7940_7960_OTHER
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $dialPattern;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The patterns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Patterns
     */
    public $patterns;
    /**
     * The plars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Plars
     */
    public $plars;
    /**
     * Constructor method for XSipDialRules
     * @uses XSipDialRules::setDialPattern()
     * @uses XSipDialRules::setName()
     * @uses XSipDialRules::setDescription()
     * @uses XSipDialRules::setPatterns()
     * @uses XSipDialRules::setPlars()
     * @param string $dialPattern
     * @param string $name
     * @param string $description
     * @param \StructType\Patterns $patterns
     * @param \StructType\Plars $plars
     */
    public function __construct($dialPattern = '7940_7960_OTHER', $name = null, $description = null, \StructType\Patterns $patterns = null, \StructType\Plars $plars = null)
    {
        $this
            ->setDialPattern($dialPattern)
            ->setName($name)
            ->setDescription($description)
            ->setPatterns($patterns)
            ->setPlars($plars);
    }
    /**
     * Get dialPattern value
     * @return string
     */
    public function getDialPattern()
    {
        return $this->dialPattern;
    }
    /**
     * Set dialPattern value
     * @uses \EnumType\XDialPattern::valueIsValid()
     * @uses \EnumType\XDialPattern::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPattern
     * @return \StructType\XSipDialRules
     */
    public function setDialPattern($dialPattern = '7940_7960_OTHER')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDialPattern::valueIsValid($dialPattern)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPattern, implode(', ', \EnumType\XDialPattern::getValidValues())), __LINE__);
        }
        $this->dialPattern = $dialPattern;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XSipDialRules
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\XSipDialRules
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get patterns value
     * @return \StructType\Patterns|null
     */
    public function getPatterns()
    {
        return $this->patterns;
    }
    /**
     * Set patterns value
     * @param \StructType\Patterns $patterns
     * @return \StructType\XSipDialRules
     */
    public function setPatterns(\StructType\Patterns $patterns = null)
    {
        $this->patterns = $patterns;
        return $this;
    }
    /**
     * Get plars value
     * @return \StructType\Plars|null
     */
    public function getPlars()
    {
        return $this->plars;
    }
    /**
     * Set plars value
     * @param \StructType\Plars $plars
     * @return \StructType\XSipDialRules
     */
    public function setPlars(\StructType\Plars $plars = null)
    {
        $this->plars = $plars;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XSipDialRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
