<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XProcessNode StructType
 * @subpackage Structs
 */
class XProcessNode extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The primary hostname of the process node.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The processNodeRole
     * Meta informations extracted from the WSDL
     * - default: CUCM Voice/Video
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $processNodeRole;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta informations extracted from the WSDL
     * - documentation: The mac address of the host.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: ([0-9]|[a-f]|[A-F]){12}
     * @var string
     */
    public $mac;
    /**
     * The ipv6Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipv6Name;
    /**
     * The lbmHubGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $lbmHubGroup;
    /**
     * The cupDomain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cupDomain;
    /**
     * Constructor method for XProcessNode
     * @uses XProcessNode::setName()
     * @uses XProcessNode::setProcessNodeRole()
     * @uses XProcessNode::setDescription()
     * @uses XProcessNode::setMac()
     * @uses XProcessNode::setIpv6Name()
     * @uses XProcessNode::setLbmHubGroup()
     * @uses XProcessNode::setCupDomain()
     * @param string $name
     * @param string $processNodeRole
     * @param string $description
     * @param string $mac
     * @param string $ipv6Name
     * @param \StructType\XFkType $lbmHubGroup
     * @param string $cupDomain
     */
    public function __construct($name = null, $processNodeRole = 'CUCM Voice/Video', $description = null, $mac = null, $ipv6Name = null, \StructType\XFkType $lbmHubGroup = null, $cupDomain = null)
    {
        $this
            ->setName($name)
            ->setProcessNodeRole($processNodeRole)
            ->setDescription($description)
            ->setMac($mac)
            ->setIpv6Name($ipv6Name)
            ->setLbmHubGroup($lbmHubGroup)
            ->setCupDomain($cupDomain);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XProcessNode
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get processNodeRole value
     * @return string
     */
    public function getProcessNodeRole()
    {
        return $this->processNodeRole;
    }
    /**
     * Set processNodeRole value
     * @uses \EnumType\XProcessNodeRole::valueIsValid()
     * @uses \EnumType\XProcessNodeRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $processNodeRole
     * @return \StructType\XProcessNode
     */
    public function setProcessNodeRole($processNodeRole = 'CUCM Voice/Video')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProcessNodeRole::valueIsValid($processNodeRole)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $processNodeRole, implode(', ', \EnumType\XProcessNodeRole::getValidValues())), __LINE__);
        }
        $this->processNodeRole = $processNodeRole;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XProcessNode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * @return string|null
     */
    public function getMac()
    {
        return $this->mac;
    }
    /**
     * Set mac value
     * @param string $mac
     * @return \StructType\XProcessNode
     */
    public function setMac($mac = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mac) && !preg_match('/([0-9]|[a-f]|[A-F]){12}/', $mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]|[a-f]|[A-F]){12}", "%s" given', var_export($mac, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mac)), __LINE__);
        }
        $this->mac = $mac;
        return $this;
    }
    /**
     * Get ipv6Name value
     * @return string|null
     */
    public function getIpv6Name()
    {
        return $this->ipv6Name;
    }
    /**
     * Set ipv6Name value
     * @param string $ipv6Name
     * @return \StructType\XProcessNode
     */
    public function setIpv6Name($ipv6Name = null)
    {
        // validation for constraint: string
        if (!is_null($ipv6Name) && !is_string($ipv6Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipv6Name)), __LINE__);
        }
        $this->ipv6Name = $ipv6Name;
        return $this;
    }
    /**
     * Get lbmHubGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getLbmHubGroup()
    {
        return isset($this->lbmHubGroup) ? $this->lbmHubGroup : null;
    }
    /**
     * Set lbmHubGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $lbmHubGroup
     * @return \StructType\XProcessNode
     */
    public function setLbmHubGroup(\StructType\XFkType $lbmHubGroup = null)
    {
        if (is_null($lbmHubGroup) || (is_array($lbmHubGroup) && empty($lbmHubGroup))) {
            unset($this->lbmHubGroup);
        } else {
            $this->lbmHubGroup = $lbmHubGroup;
        }
        return $this;
    }
    /**
     * Get cupDomain value
     * @return string|null
     */
    public function getCupDomain()
    {
        return $this->cupDomain;
    }
    /**
     * Set cupDomain value
     * @param string $cupDomain
     * @return \StructType\XProcessNode
     */
    public function setCupDomain($cupDomain = null)
    {
        // validation for constraint: string
        if (!is_null($cupDomain) && !is_string($cupDomain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cupDomain)), __LINE__);
        }
        $this->cupDomain = $cupDomain;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XProcessNode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
