<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPresenceRedundancyGroup StructType
 * @subpackage Structs
 */
class XPresenceRedundancyGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The server1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $server1;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The server2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $server2;
    /**
     * The haEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $haEnabled;
    /**
     * Constructor method for XPresenceRedundancyGroup
     * @uses XPresenceRedundancyGroup::setName()
     * @uses XPresenceRedundancyGroup::setServer1()
     * @uses XPresenceRedundancyGroup::setDescription()
     * @uses XPresenceRedundancyGroup::setServer2()
     * @uses XPresenceRedundancyGroup::setHaEnabled()
     * @param string $name
     * @param \StructType\XFkType $server1
     * @param string $description
     * @param \StructType\XFkType $server2
     * @param string $haEnabled
     */
    public function __construct($name = null, \StructType\XFkType $server1 = null, $description = null, \StructType\XFkType $server2 = null, $haEnabled = false)
    {
        $this
            ->setName($name)
            ->setServer1($server1)
            ->setDescription($description)
            ->setServer2($server2)
            ->setHaEnabled($haEnabled);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XPresenceRedundancyGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get server1 value
     * @return \StructType\XFkType
     */
    public function getServer1()
    {
        return $this->server1;
    }
    /**
     * Set server1 value
     * @param \StructType\XFkType $server1
     * @return \StructType\XPresenceRedundancyGroup
     */
    public function setServer1(\StructType\XFkType $server1 = null)
    {
        $this->server1 = $server1;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XPresenceRedundancyGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get server2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getServer2()
    {
        return isset($this->server2) ? $this->server2 : null;
    }
    /**
     * Set server2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $server2
     * @return \StructType\XPresenceRedundancyGroup
     */
    public function setServer2(\StructType\XFkType $server2 = null)
    {
        if (is_null($server2) || (is_array($server2) && empty($server2))) {
            unset($this->server2);
        } else {
            $this->server2 = $server2;
        }
        return $this;
    }
    /**
     * Get haEnabled value
     * @return string|null
     */
    public function getHaEnabled()
    {
        return $this->haEnabled;
    }
    /**
     * Set haEnabled value
     * @param string $haEnabled
     * @return \StructType\XPresenceRedundancyGroup
     */
    public function setHaEnabled($haEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($haEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($haEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($haEnabled) && !is_string($haEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($haEnabled)), __LINE__);
        }
        $this->haEnabled = $haEnabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XPresenceRedundancyGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
