<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPickupGroupMember StructType
 * @subpackage Structs
 */
class XPickupGroupMember extends AbstractStructBase
{
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $priority;
    /**
     * The pickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\XFkType
     */
    public $pickupGroupName;
    /**
     * The pickupDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PickupDnAndPartition
     */
    public $pickupDnAndPartition;
    /**
     * Constructor method for XPickupGroupMember
     * @uses XPickupGroupMember::setPriority()
     * @uses XPickupGroupMember::setPickupGroupName()
     * @uses XPickupGroupMember::setPickupDnAndPartition()
     * @param string $priority
     * @param \StructType\XFkType $pickupGroupName
     * @param \StructType\PickupDnAndPartition $pickupDnAndPartition
     */
    public function __construct($priority = null, \StructType\XFkType $pickupGroupName = null, \StructType\PickupDnAndPartition $pickupDnAndPartition = null)
    {
        $this
            ->setPriority($priority)
            ->setPickupGroupName($pickupGroupName)
            ->setPickupDnAndPartition($pickupDnAndPartition);
    }
    /**
     * Get priority value
     * @return string
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\XPickupGroupMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get pickupGroupName value
     * @return \StructType\XFkType
     */
    public function getPickupGroupName()
    {
        return $this->pickupGroupName;
    }
    /**
     * Set pickupGroupName value
     * @param \StructType\XFkType $pickupGroupName
     * @return \StructType\XPickupGroupMember
     */
    public function setPickupGroupName(\StructType\XFkType $pickupGroupName = null)
    {
        $this->pickupGroupName = $pickupGroupName;
        return $this;
    }
    /**
     * Get pickupDnAndPartition value
     * @return \StructType\PickupDnAndPartition
     */
    public function getPickupDnAndPartition()
    {
        return $this->pickupDnAndPartition;
    }
    /**
     * Set pickupDnAndPartition value
     * @param \StructType\PickupDnAndPartition $pickupDnAndPartition
     * @return \StructType\XPickupGroupMember
     */
    public function setPickupDnAndPartition(\StructType\PickupDnAndPartition $pickupDnAndPartition = null)
    {
        $this->pickupDnAndPartition = $pickupDnAndPartition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XPickupGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
