<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XInterClusterServiceProfile StructType
 * @subpackage Structs
 */
class XInterClusterServiceProfile extends AbstractStructBase
{
    /**
     * The interClusterService
     * Meta informations extracted from the WSDL
     * - default: EMCC
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $interClusterService;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for PSTN Access and RSVP Agent
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * Constructor method for XInterClusterServiceProfile
     * @uses XInterClusterServiceProfile::setInterClusterService()
     * @uses XInterClusterServiceProfile::setIsActivated()
     * @uses XInterClusterServiceProfile::setSipTrunkName()
     * @param string $interClusterService
     * @param string $isActivated
     * @param \StructType\XFkType $sipTrunkName
     */
    public function __construct($interClusterService = 'EMCC', $isActivated = false, \StructType\XFkType $sipTrunkName = null)
    {
        $this
            ->setInterClusterService($interClusterService)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName);
    }
    /**
     * Get interClusterService value
     * @return string
     */
    public function getInterClusterService()
    {
        return $this->interClusterService;
    }
    /**
     * Set interClusterService value
     * @uses \EnumType\XInterClusterService::valueIsValid()
     * @uses \EnumType\XInterClusterService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interClusterService
     * @return \StructType\XInterClusterServiceProfile
     */
    public function setInterClusterService($interClusterService = 'EMCC')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInterClusterService::valueIsValid($interClusterService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $interClusterService, implode(', ', \EnumType\XInterClusterService::getValidValues())), __LINE__);
        }
        $this->interClusterService = $interClusterService;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\XInterClusterServiceProfile
     */
    public function setIsActivated($isActivated = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\XInterClusterServiceProfile
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XInterClusterServiceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
