<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeServer StructType
 * @subpackage Structs
 */
class XImeServer extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The applicationUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $applicationUser;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 5620
     * - documentation: Value shpuld be between 1024 and 65535
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The deviceSecurityMode
     * Meta informations extracted from the WSDL
     * - default: Authenticated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The reconnectInterval
     * Meta informations extracted from the WSDL
     * - default: 120
     * - documentation: Value should be between 60 and 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $reconnectInterval;
    /**
     * Constructor method for XImeServer
     * @uses XImeServer::setName()
     * @uses XImeServer::setIpAddress()
     * @uses XImeServer::setApplicationUser()
     * @uses XImeServer::setDescription()
     * @uses XImeServer::setPort()
     * @uses XImeServer::setDeviceSecurityMode()
     * @uses XImeServer::setReconnectInterval()
     * @param string $name
     * @param string $ipAddress
     * @param \StructType\XFkType $applicationUser
     * @param string $description
     * @param string $port
     * @param string $deviceSecurityMode
     * @param string $reconnectInterval
     */
    public function __construct($name = null, $ipAddress = null, \StructType\XFkType $applicationUser = null, $description = null, $port = '5620', $deviceSecurityMode = 'Authenticated', $reconnectInterval = '120')
    {
        $this
            ->setName($name)
            ->setIpAddress($ipAddress)
            ->setApplicationUser($applicationUser)
            ->setDescription($description)
            ->setPort($port)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setReconnectInterval($reconnectInterval);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\XImeServer
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\XImeServer
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return \StructType\XFkType
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \StructType\XFkType $applicationUser
     * @return \StructType\XImeServer
     */
    public function setApplicationUser(\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\XImeServer
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\XImeServer
     */
    public function setPort($port = '5620')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @uses \EnumType\XServerSecurityMode::valueIsValid()
     * @uses \EnumType\XServerSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return \StructType\XImeServer
     */
    public function setDeviceSecurityMode($deviceSecurityMode = 'Authenticated')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XServerSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceSecurityMode, implode(', ', \EnumType\XServerSecurityMode::getValidValues())), __LINE__);
        }
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get reconnectInterval value
     * @return string|null
     */
    public function getReconnectInterval()
    {
        return $this->reconnectInterval;
    }
    /**
     * Set reconnectInterval value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reconnectInterval
     * @return \StructType\XImeServer
     */
    public function setReconnectInterval($reconnectInterval = '120')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($reconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reconnectInterval, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->reconnectInterval = $reconnectInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XImeServer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
