<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XExtensions StructType
 * @subpackage Structs
 */
class XExtensions extends AbstractStructBase
{
    /**
     * The extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $extension;
    /**
     * The linePrimaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $linePrimaryUri;
    /**
     * The partition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $partition;
    /**
     * Constructor method for XExtensions
     * @uses XExtensions::setExtension()
     * @uses XExtensions::setLinePrimaryUri()
     * @uses XExtensions::setPartition()
     * @param \StructType\XFkType $extension
     * @param string $linePrimaryUri
     * @param \StructType\XFkType $partition
     */
    public function __construct(\StructType\XFkType $extension = null, $linePrimaryUri = null, \StructType\XFkType $partition = null)
    {
        $this
            ->setExtension($extension)
            ->setLinePrimaryUri($linePrimaryUri)
            ->setPartition($partition);
    }
    /**
     * Get extension value
     * @return \StructType\XFkType|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param \StructType\XFkType $extension
     * @return \StructType\XExtensions
     */
    public function setExtension(\StructType\XFkType $extension = null)
    {
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get linePrimaryUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinePrimaryUri()
    {
        return isset($this->linePrimaryUri) ? $this->linePrimaryUri : null;
    }
    /**
     * Set linePrimaryUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linePrimaryUri
     * @return \StructType\XExtensions
     */
    public function setLinePrimaryUri($linePrimaryUri = null)
    {
        // validation for constraint: string
        if (!is_null($linePrimaryUri) && !is_string($linePrimaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($linePrimaryUri)), __LINE__);
        }
        if (is_null($linePrimaryUri) || (is_array($linePrimaryUri) && empty($linePrimaryUri))) {
            unset($this->linePrimaryUri);
        } else {
            $this->linePrimaryUri = $linePrimaryUri;
        }
        return $this;
    }
    /**
     * Get partition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getPartition()
    {
        return isset($this->partition) ? $this->partition : null;
    }
    /**
     * Set partition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $partition
     * @return \StructType\XExtensions
     */
    public function setPartition(\StructType\XFkType $partition = null)
    {
        if (is_null($partition) || (is_array($partition) && empty($partition))) {
            unset($this->partition);
        } else {
            $this->partition = $partition;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XExtensions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
