<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XEndUserCapfProfile StructType
 * @subpackage Structs
 */
class XEndUserCapfProfile extends AbstractStructBase
{
    /**
     * The endUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $endUserId;
    /**
     * The instanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $instanceId;
    /**
     * The certificationOperation
     * Meta informations extracted from the WSDL
     * - default: No Pending Operation
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $certificationOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - default: By Null String
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - default: 1024
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The keyOrder
     * Meta informations extracted from the WSDL
     * - default: RSA Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keyOrder;
    /**
     * The ecKeySize
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ecKeySize;
    /**
     * The operationCompletion
     * Meta informations extracted from the WSDL
     * - documentation: Format is YYYY:MM:DD:HH
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $operationCompletion;
    /**
     * Constructor method for XEndUserCapfProfile
     * @uses XEndUserCapfProfile::setEndUserId()
     * @uses XEndUserCapfProfile::setInstanceId()
     * @uses XEndUserCapfProfile::setCertificationOperation()
     * @uses XEndUserCapfProfile::setAuthenticationMode()
     * @uses XEndUserCapfProfile::setKeySize()
     * @uses XEndUserCapfProfile::setAuthenticationString()
     * @uses XEndUserCapfProfile::setKeyOrder()
     * @uses XEndUserCapfProfile::setEcKeySize()
     * @uses XEndUserCapfProfile::setOperationCompletion()
     * @param \StructType\XFkType $endUserId
     * @param string $instanceId
     * @param string $certificationOperation
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $authenticationString
     * @param string $keyOrder
     * @param string $ecKeySize
     * @param string $operationCompletion
     */
    public function __construct(\StructType\XFkType $endUserId = null, $instanceId = null, $certificationOperation = 'No Pending Operation', $authenticationMode = 'By Null String', $keySize = '1024', $authenticationString = null, $keyOrder = 'RSA Only', $ecKeySize = '384', $operationCompletion = null)
    {
        $this
            ->setEndUserId($endUserId)
            ->setInstanceId($instanceId)
            ->setCertificationOperation($certificationOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setAuthenticationString($authenticationString)
            ->setKeyOrder($keyOrder)
            ->setEcKeySize($ecKeySize)
            ->setOperationCompletion($operationCompletion);
    }
    /**
     * Get endUserId value
     * @return \StructType\XFkType
     */
    public function getEndUserId()
    {
        return $this->endUserId;
    }
    /**
     * Set endUserId value
     * @param \StructType\XFkType $endUserId
     * @return \StructType\XEndUserCapfProfile
     */
    public function setEndUserId(\StructType\XFkType $endUserId = null)
    {
        $this->endUserId = $endUserId;
        return $this;
    }
    /**
     * Get instanceId value
     * @return string
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return \StructType\XEndUserCapfProfile
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get certificationOperation value
     * @return string
     */
    public function getCertificationOperation()
    {
        return $this->certificationOperation;
    }
    /**
     * Set certificationOperation value
     * @uses \EnumType\XCertificateOperation::valueIsValid()
     * @uses \EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificationOperation
     * @return \StructType\XEndUserCapfProfile
     */
    public function setCertificationOperation($certificationOperation = 'No Pending Operation')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateOperation::valueIsValid($certificationOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificationOperation, implode(', ', \EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificationOperation = $certificationOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\XEndUserCapfProfile
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\XEndUserCapfProfile
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \StructType\XEndUserCapfProfile
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keyOrder value
     * @return string|null
     */
    public function getKeyOrder()
    {
        return $this->keyOrder;
    }
    /**
     * Set keyOrder value
     * @uses \EnumType\XKeyOrder::valueIsValid()
     * @uses \EnumType\XKeyOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keyOrder
     * @return \StructType\XEndUserCapfProfile
     */
    public function setKeyOrder($keyOrder = 'RSA Only')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeyOrder::valueIsValid($keyOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keyOrder, implode(', ', \EnumType\XKeyOrder::getValidValues())), __LINE__);
        }
        $this->keyOrder = $keyOrder;
        return $this;
    }
    /**
     * Get ecKeySize value
     * @return string|null
     */
    public function getEcKeySize()
    {
        return $this->ecKeySize;
    }
    /**
     * Set ecKeySize value
     * @uses \EnumType\XECKeySize::valueIsValid()
     * @uses \EnumType\XECKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ecKeySize
     * @return \StructType\XEndUserCapfProfile
     */
    public function setEcKeySize($ecKeySize = '384')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XECKeySize::valueIsValid($ecKeySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ecKeySize, implode(', ', \EnumType\XECKeySize::getValidValues())), __LINE__);
        }
        $this->ecKeySize = $ecKeySize;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return \StructType\XEndUserCapfProfile
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XEndUserCapfProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
