<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XAppServerInfo StructType
 * @subpackage Structs
 */
class XAppServerInfo extends AbstractStructBase
{
    /**
     * The appServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $appServerName;
    /**
     * The appServerContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $appServerContent;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XContent
     */
    public $content;
    /**
     * Constructor method for XAppServerInfo
     * @uses XAppServerInfo::setAppServerName()
     * @uses XAppServerInfo::setAppServerContent()
     * @uses XAppServerInfo::setContent()
     * @param \StructType\XFkType $appServerName
     * @param string $appServerContent
     * @param \StructType\XContent $content
     */
    public function __construct(\StructType\XFkType $appServerName = null, $appServerContent = null, \StructType\XContent $content = null)
    {
        $this
            ->setAppServerName($appServerName)
            ->setAppServerContent($appServerContent)
            ->setContent($content);
    }
    /**
     * Get appServerName value
     * @return \StructType\XFkType
     */
    public function getAppServerName()
    {
        return $this->appServerName;
    }
    /**
     * Set appServerName value
     * @param \StructType\XFkType $appServerName
     * @return \StructType\XAppServerInfo
     */
    public function setAppServerName(\StructType\XFkType $appServerName = null)
    {
        $this->appServerName = $appServerName;
        return $this;
    }
    /**
     * Get appServerContent value
     * @return string
     */
    public function getAppServerContent()
    {
        return $this->appServerContent;
    }
    /**
     * Set appServerContent value
     * @uses \EnumType\XAppServerContent::valueIsValid()
     * @uses \EnumType\XAppServerContent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerContent
     * @return \StructType\XAppServerInfo
     */
    public function setAppServerContent($appServerContent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAppServerContent::valueIsValid($appServerContent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appServerContent, implode(', ', \EnumType\XAppServerContent::getValidValues())), __LINE__);
        }
        $this->appServerContent = $appServerContent;
        return $this;
    }
    /**
     * Get content value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XContent|null
     */
    public function getContent()
    {
        return isset($this->content) ? $this->content : null;
    }
    /**
     * Set content value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XContent $content
     * @return \StructType\XAppServerInfo
     */
    public function setContent(\StructType\XContent $content = null)
    {
        if (is_null($content) || (is_array($content) && empty($content))) {
            unset($this->content);
        } else {
            $this->content = $content;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\XAppServerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
