<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userRoles StructType
 * @subpackage Structs
 */
class UserRoles extends XCommonMembersExtension
{
    /**
     * The userRole
     * Meta informations extracted from the WSDL
     * - documentation: READ ONLY: Name of the User Role associated with the user group will be taken. | READ ONLY: Name of the User Role associated with the user group will be taken. | READ ONLY: Name of the User role associated with the user group will be
     * taken | READ ONLY: Name of the User role associated with the user group will be taken | READ ONLY: Name of the User Role associated with the user group will be taken. | READ ONLY: Name of the User role associated with the user group will be taken
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\XUserGroupRoles[]
     */
    public $userRole;
    /**
     * Constructor method for userRoles
     * @uses UserRoles::setUserRole()
     * @param \StructType\XUserGroupRoles[] $userRole
     */
    public function __construct(array $userRole = array())
    {
        $this
            ->setUserRole($userRole);
    }
    /**
     * Get userRole value
     * @return \StructType\XUserGroupRoles[]|null
     */
    public function getUserRole()
    {
        return $this->userRole;
    }
    /**
     * Set userRole value
     * @throws \InvalidArgumentException
     * @param \StructType\XUserGroupRoles[] $userRole
     * @return \StructType\UserRoles
     */
    public function setUserRole(array $userRole = array())
    {
        foreach ($userRole as $userRolesUserRoleItem) {
            // validation for constraint: itemType
            if (!$userRolesUserRoleItem instanceof \StructType\XUserGroupRoles) {
                throw new \InvalidArgumentException(sprintf('The userRole property can only contain items of \StructType\XUserGroupRoles, "%s" given', is_object($userRolesUserRoleItem) ? get_class($userRolesUserRoleItem) : gettype($userRolesUserRoleItem)), __LINE__);
            }
        }
        $this->userRole = $userRole;
        return $this;
    }
    /**
     * Add item to userRole value
     * @throws \InvalidArgumentException
     * @param \StructType\XUserGroupRoles $item
     * @return \StructType\UserRoles
     */
    public function addToUserRole(\StructType\XUserGroupRoles $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XUserGroupRoles) {
            throw new \InvalidArgumentException(sprintf('The userRole property can only contain items of \StructType\XUserGroupRoles, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->userRole[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserRoles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
