<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVpnProfileReq StructType
 * @subpackage Structs
 */
class UpdateVpnProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The autoNetworkDetection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $autoNetworkDetection;
    /**
     * The mtu
     * Meta informations extracted from the WSDL
     * - default: 1290
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mtu;
    /**
     * The failToConnect
     * Meta informations extracted from the WSDL
     * - default: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $failToConnect;
    /**
     * The clientAuthentication
     * Meta informations extracted from the WSDL
     * - default: User and Password
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $clientAuthentication;
    /**
     * The pwdPersistant
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pwdPersistant;
    /**
     * The enableHostIdCheck
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableHostIdCheck;
    /**
     * Constructor method for UpdateVpnProfileReq
     * @uses UpdateVpnProfileReq::setNewName()
     * @uses UpdateVpnProfileReq::setDescription()
     * @uses UpdateVpnProfileReq::setAutoNetworkDetection()
     * @uses UpdateVpnProfileReq::setMtu()
     * @uses UpdateVpnProfileReq::setFailToConnect()
     * @uses UpdateVpnProfileReq::setClientAuthentication()
     * @uses UpdateVpnProfileReq::setPwdPersistant()
     * @uses UpdateVpnProfileReq::setEnableHostIdCheck()
     * @param string $newName
     * @param string $description
     * @param string $autoNetworkDetection
     * @param string $mtu
     * @param string $failToConnect
     * @param string $clientAuthentication
     * @param string $pwdPersistant
     * @param string $enableHostIdCheck
     */
    public function __construct($newName = null, $description = null, $autoNetworkDetection = null, $mtu = '1290', $failToConnect = '30', $clientAuthentication = 'User and Password', $pwdPersistant = null, $enableHostIdCheck = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAutoNetworkDetection($autoNetworkDetection)
            ->setMtu($mtu)
            ->setFailToConnect($failToConnect)
            ->setClientAuthentication($clientAuthentication)
            ->setPwdPersistant($pwdPersistant)
            ->setEnableHostIdCheck($enableHostIdCheck);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get autoNetworkDetection value
     * @return string|null
     */
    public function getAutoNetworkDetection()
    {
        return $this->autoNetworkDetection;
    }
    /**
     * Set autoNetworkDetection value
     * @param string $autoNetworkDetection
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setAutoNetworkDetection($autoNetworkDetection = null)
    {
        // validation for constraint: pattern
        if (is_scalar($autoNetworkDetection) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($autoNetworkDetection, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($autoNetworkDetection) && !is_string($autoNetworkDetection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoNetworkDetection)), __LINE__);
        }
        $this->autoNetworkDetection = $autoNetworkDetection;
        return $this;
    }
    /**
     * Get mtu value
     * @return string|null
     */
    public function getMtu()
    {
        return $this->mtu;
    }
    /**
     * Set mtu value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtu
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setMtu($mtu = '1290')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($mtu)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtu, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->mtu = $mtu;
        return $this;
    }
    /**
     * Get failToConnect value
     * @return string|null
     */
    public function getFailToConnect()
    {
        return $this->failToConnect;
    }
    /**
     * Set failToConnect value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failToConnect
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setFailToConnect($failToConnect = '30')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($failToConnect)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $failToConnect, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->failToConnect = $failToConnect;
        return $this;
    }
    /**
     * Get clientAuthentication value
     * @return string|null
     */
    public function getClientAuthentication()
    {
        return $this->clientAuthentication;
    }
    /**
     * Set clientAuthentication value
     * @uses \EnumType\XVPNClientAuthentication::valueIsValid()
     * @uses \EnumType\XVPNClientAuthentication::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientAuthentication
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setClientAuthentication($clientAuthentication = 'User and Password')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVPNClientAuthentication::valueIsValid($clientAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $clientAuthentication, implode(', ', \EnumType\XVPNClientAuthentication::getValidValues())), __LINE__);
        }
        $this->clientAuthentication = $clientAuthentication;
        return $this;
    }
    /**
     * Get pwdPersistant value
     * @return string|null
     */
    public function getPwdPersistant()
    {
        return $this->pwdPersistant;
    }
    /**
     * Set pwdPersistant value
     * @param string $pwdPersistant
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setPwdPersistant($pwdPersistant = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pwdPersistant) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pwdPersistant, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pwdPersistant) && !is_string($pwdPersistant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pwdPersistant)), __LINE__);
        }
        $this->pwdPersistant = $pwdPersistant;
        return $this;
    }
    /**
     * Get enableHostIdCheck value
     * @return string|null
     */
    public function getEnableHostIdCheck()
    {
        return $this->enableHostIdCheck;
    }
    /**
     * Set enableHostIdCheck value
     * @param string $enableHostIdCheck
     * @return \StructType\UpdateVpnProfileReq
     */
    public function setEnableHostIdCheck($enableHostIdCheck = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableHostIdCheck) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableHostIdCheck, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableHostIdCheck) && !is_string($enableHostIdCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableHostIdCheck)), __LINE__);
        }
        $this->enableHostIdCheck = $enableHostIdCheck;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateVpnProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
