<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTimePeriodReq StructType
 * @subpackage Structs
 */
class UpdateTimePeriodReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The startTime
     * Meta informations extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * Meta informations extracted from the WSDL
     * - default: No Office Hours
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endTime;
    /**
     * The startDay
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startDay;
    /**
     * The endDay
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $endDay;
    /**
     * The monthOfYear
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYear;
    /**
     * The dayOfMonth
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonth;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The dayOfMonthEnd
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dayOfMonthEnd;
    /**
     * The monthOfYearEnd
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $monthOfYearEnd;
    /**
     * Constructor method for UpdateTimePeriodReq
     * @uses UpdateTimePeriodReq::setNewName()
     * @uses UpdateTimePeriodReq::setStartTime()
     * @uses UpdateTimePeriodReq::setEndTime()
     * @uses UpdateTimePeriodReq::setStartDay()
     * @uses UpdateTimePeriodReq::setEndDay()
     * @uses UpdateTimePeriodReq::setMonthOfYear()
     * @uses UpdateTimePeriodReq::setDayOfMonth()
     * @uses UpdateTimePeriodReq::setDescription()
     * @uses UpdateTimePeriodReq::setDayOfMonthEnd()
     * @uses UpdateTimePeriodReq::setMonthOfYearEnd()
     * @param string $newName
     * @param string $startTime
     * @param string $endTime
     * @param string $startDay
     * @param string $endDay
     * @param string $monthOfYear
     * @param string $dayOfMonth
     * @param string $description
     * @param string $dayOfMonthEnd
     * @param string $monthOfYearEnd
     */
    public function __construct($newName = null, $startTime = 'No Office Hours', $endTime = 'No Office Hours', $startDay = 'None', $endDay = 'None', $monthOfYear = 'None', $dayOfMonth = '0', $description = null, $dayOfMonthEnd = '0', $monthOfYearEnd = 'None')
    {
        $this
            ->setNewName($newName)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setStartDay($startDay)
            ->setEndDay($endDay)
            ->setMonthOfYear($monthOfYear)
            ->setDayOfMonth($dayOfMonth)
            ->setDescription($description)
            ->setDayOfMonthEnd($dayOfMonthEnd)
            ->setMonthOfYearEnd($monthOfYearEnd);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startTime
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setStartTime($startTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($startTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startTime, implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @uses \EnumType\XTimeOfDay::valueIsValid()
     * @uses \EnumType\XTimeOfDay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endTime
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setEndTime($endTime = 'No Office Hours')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeOfDay::valueIsValid($endTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endTime, implode(', ', \EnumType\XTimeOfDay::getValidValues())), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get startDay value
     * @return string|null
     */
    public function getStartDay()
    {
        return $this->startDay;
    }
    /**
     * Set startDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDay
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setStartDay($startDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($startDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startDay, implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->startDay = $startDay;
        return $this;
    }
    /**
     * Get endDay value
     * @return string|null
     */
    public function getEndDay()
    {
        return $this->endDay;
    }
    /**
     * Set endDay value
     * @uses \EnumType\XDayOfWeek::valueIsValid()
     * @uses \EnumType\XDayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endDay
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setEndDay($endDay = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDayOfWeek::valueIsValid($endDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endDay, implode(', ', \EnumType\XDayOfWeek::getValidValues())), __LINE__);
        }
        $this->endDay = $endDay;
        return $this;
    }
    /**
     * Get monthOfYear value
     * @return string|null
     */
    public function getMonthOfYear()
    {
        return $this->monthOfYear;
    }
    /**
     * Set monthOfYear value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYear
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setMonthOfYear($monthOfYear = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYear)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monthOfYear, implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYear = $monthOfYear;
        return $this;
    }
    /**
     * Get dayOfMonth value
     * @return string|null
     */
    public function getDayOfMonth()
    {
        return $this->dayOfMonth;
    }
    /**
     * Set dayOfMonth value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonth
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setDayOfMonth($dayOfMonth = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfMonth, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonth = $dayOfMonth;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dayOfMonthEnd value
     * @return string|null
     */
    public function getDayOfMonthEnd()
    {
        return $this->dayOfMonthEnd;
    }
    /**
     * Set dayOfMonthEnd value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayOfMonthEnd
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setDayOfMonthEnd($dayOfMonthEnd = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($dayOfMonthEnd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dayOfMonthEnd, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dayOfMonthEnd = $dayOfMonthEnd;
        return $this;
    }
    /**
     * Get monthOfYearEnd value
     * @return string|null
     */
    public function getMonthOfYearEnd()
    {
        return $this->monthOfYearEnd;
    }
    /**
     * Set monthOfYearEnd value
     * @uses \EnumType\XMonthOfYear::valueIsValid()
     * @uses \EnumType\XMonthOfYear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $monthOfYearEnd
     * @return \StructType\UpdateTimePeriodReq
     */
    public function setMonthOfYearEnd($monthOfYearEnd = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMonthOfYear::valueIsValid($monthOfYearEnd)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $monthOfYearEnd, implode(', ', \EnumType\XMonthOfYear::getValidValues())), __LINE__);
        }
        $this->monthOfYearEnd = $monthOfYearEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateTimePeriodReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
