<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSyslogConfigurationReq StructType
 * @subpackage Structs
 */
class UpdateSyslogConfigurationReq extends APIRequest
{
    /**
     * The serverName
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $serverName;
    /**
     * The serviceGroup
     * Meta informations extracted from the WSDL
     * - default: CM Services
     * - nillable: false
     * @var string
     */
    public $serviceGroup;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The alarmConfigs
     * @var \StructType\AlarmConfigs
     */
    public $alarmConfigs;
    /**
     * The EndPointAlarm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $EndPointAlarm;
    /**
     * Constructor method for UpdateSyslogConfigurationReq
     * @uses UpdateSyslogConfigurationReq::setServerName()
     * @uses UpdateSyslogConfigurationReq::setServiceGroup()
     * @uses UpdateSyslogConfigurationReq::setService()
     * @uses UpdateSyslogConfigurationReq::setAlarmConfigs()
     * @uses UpdateSyslogConfigurationReq::setEndPointAlarm()
     * @param string $serverName
     * @param string $serviceGroup
     * @param string $service
     * @param \StructType\AlarmConfigs $alarmConfigs
     * @param string $endPointAlarm
     */
    public function __construct($serverName = null, $serviceGroup = 'CM Services', $service = null, \StructType\AlarmConfigs $alarmConfigs = null, $endPointAlarm = null)
    {
        $this
            ->setServerName($serverName)
            ->setServiceGroup($serviceGroup)
            ->setService($service)
            ->setAlarmConfigs($alarmConfigs)
            ->setEndPointAlarm($endPointAlarm);
    }
    /**
     * Get serverName value
     * @return string|null
     */
    public function getServerName()
    {
        return $this->serverName;
    }
    /**
     * Set serverName value
     * @param string $serverName
     * @return \StructType\UpdateSyslogConfigurationReq
     */
    public function setServerName($serverName = null)
    {
        // validation for constraint: string
        if (!is_null($serverName) && !is_string($serverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverName)), __LINE__);
        }
        $this->serverName = $serverName;
        return $this;
    }
    /**
     * Get serviceGroup value
     * @return string|null
     */
    public function getServiceGroup()
    {
        return $this->serviceGroup;
    }
    /**
     * Set serviceGroup value
     * @uses \EnumType\XServiceGrouping::valueIsValid()
     * @uses \EnumType\XServiceGrouping::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceGroup
     * @return \StructType\UpdateSyslogConfigurationReq
     */
    public function setServiceGroup($serviceGroup = 'CM Services')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XServiceGrouping::valueIsValid($serviceGroup)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceGroup, implode(', ', \EnumType\XServiceGrouping::getValidValues())), __LINE__);
        }
        $this->serviceGroup = $serviceGroup;
        return $this;
    }
    /**
     * Get service value
     * @return string|null
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param string $service
     * @return \StructType\UpdateSyslogConfigurationReq
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get alarmConfigs value
     * @return \StructType\AlarmConfigs|null
     */
    public function getAlarmConfigs()
    {
        return $this->alarmConfigs;
    }
    /**
     * Set alarmConfigs value
     * @param \StructType\AlarmConfigs $alarmConfigs
     * @return \StructType\UpdateSyslogConfigurationReq
     */
    public function setAlarmConfigs(\StructType\AlarmConfigs $alarmConfigs = null)
    {
        $this->alarmConfigs = $alarmConfigs;
        return $this;
    }
    /**
     * Get EndPointAlarm value
     * @return string|null
     */
    public function getEndPointAlarm()
    {
        return $this->EndPointAlarm;
    }
    /**
     * Set EndPointAlarm value
     * @param string $endPointAlarm
     * @return \StructType\UpdateSyslogConfigurationReq
     */
    public function setEndPointAlarm($endPointAlarm = null)
    {
        // validation for constraint: pattern
        if (is_scalar($endPointAlarm) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $endPointAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($endPointAlarm, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endPointAlarm) && !is_string($endPointAlarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endPointAlarm)), __LINE__);
        }
        $this->EndPointAlarm = $endPointAlarm;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSyslogConfigurationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
