<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSipTrunkReq StructType
 * @subpackage Structs
 */
class UpdateSipTrunkReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - default: Off
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The referCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $referCallingSearchSpaceName;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The unknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $unknownPrefix;
    /**
     * The destAddrIsSrv
     * Meta informations extracted from the WSDL
     * - documentation: This tag is ignored and destAddrIsSRV is set to false if destinationaddress is an IP address and destinationport is mentioned correctly.This tag will not be returned by list.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destAddrIsSrv;
    /**
     * The tkSipCodec
     * Meta informations extracted from the WSDL
     * - default: 711ulaw
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tkSipCodec;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - default: 99
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The connectedNamePresentation
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentation;
    /**
     * The connectedPartyIdPresentation
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedPartyIdPresentation;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingname
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingname;
    /**
     * The callingLineIdPresentation
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The prefixDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $prefixDn;
    /**
     * The callerName
     * Meta informations extracted from the WSDL
     * - documentation: Characters which are not valid for caller name are ampersand, braces, less than or greater than, percentage sign, double quotes, square brackets and pipe.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $callerName;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $callerIdDn;
    /**
     * The acceptInboundRdnis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptInboundRdnis;
    /**
     * The acceptOutboundRdnis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutboundRdnis;
    /**
     * The srtpAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The srtpFallbackAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This tag is valid only if srtpAllowed is set to false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpFallbackAllowed;
    /**
     * The isPaiEnabled
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPaiEnabled;
    /**
     * The sipPrivacy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPrivacy;
    /**
     * The isRpidEnabled
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isRpidEnabled;
    /**
     * The sipAssertedType
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipAssertedType;
    /**
     * The dtmfSignalingMethod
     * Meta informations extracted from the WSDL
     * - default: No Preference
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dtmfSignalingMethod;
    /**
     * The routeClassSignalling
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $routeClassSignalling;
    /**
     * The sipTrunkType
     * Meta informations extracted from the WSDL
     * - default: None(Default)
     * - documentation: This tag is not supported in the Update method.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipTrunkType;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useImePublicIpPort
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useImePublicIpPort;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The cntdPnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The rdnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $rdnTransformationCssName;
    /**
     * The useDevicePoolRdnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolRdnTransformCss;
    /**
     * The sipNormalizationScriptName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $sipNormalizationScriptName;
    /**
     * The runOnEveryNode
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * The removeDestinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveDestinations
     */
    public $removeDestinations;
    /**
     * The addDestinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddDestinations
     */
    public $addDestinations;
    /**
     * The destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Destinations
     */
    public $destinations;
    /**
     * The unknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The cgpnTransformationUnknownCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $cgpnTransformationUnknownCssName;
    /**
     * The tunneledProtocol
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta informations extracted from the WSDL
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta informations extracted from the WSDL
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qsigVariant;
    /**
     * The pathReplacementSupport
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The enableQsigUtf8
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableQsigUtf8;
    /**
     * The scriptParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scriptParameters;
    /**
     * The scriptTraceEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $scriptTraceEnabled;
    /**
     * The trunkTrafficSecure
     * Meta informations extracted from the WSDL
     * - default: When using both sRTP and TLS
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $trunkTrafficSecure;
    /**
     * The callingAndCalledPartyInfoFormat
     * Meta informations extracted from the WSDL
     * - default: Deliver DN only in connected party
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingAndCalledPartyInfoFormat;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The requestUriDomainName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for IP Multimedia Subsystem Service Control (ISC) Sip trunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $requestUriDomainName;
    /**
     * The enableCiscoRecordingQsigTunneling
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableCiscoRecordingQsigTunneling;
    /**
     * The recordingInformation
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: This field can have values 0,1 or 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingInformation;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartyUnknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartyUnknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * Constructor method for UpdateSipTrunkReq
     * @uses UpdateSipTrunkReq::setNewName()
     * @uses UpdateSipTrunkReq::setDescription()
     * @uses UpdateSipTrunkReq::setCallingSearchSpaceName()
     * @uses UpdateSipTrunkReq::setDevicePoolName()
     * @uses UpdateSipTrunkReq::setCommonDeviceConfigName()
     * @uses UpdateSipTrunkReq::setNetworkLocation()
     * @uses UpdateSipTrunkReq::setLocationName()
     * @uses UpdateSipTrunkReq::setMediaResourceListName()
     * @uses UpdateSipTrunkReq::setNetworkHoldMohAudioSourceId()
     * @uses UpdateSipTrunkReq::setUserHoldMohAudioSourceId()
     * @uses UpdateSipTrunkReq::setAutomatedAlternateRoutingCssName()
     * @uses UpdateSipTrunkReq::setAarNeighborhoodName()
     * @uses UpdateSipTrunkReq::setPacketCaptureMode()
     * @uses UpdateSipTrunkReq::setPacketCaptureDuration()
     * @uses UpdateSipTrunkReq::setMlppDomainId()
     * @uses UpdateSipTrunkReq::setMlppIndicationStatus()
     * @uses UpdateSipTrunkReq::setPreemption()
     * @uses UpdateSipTrunkReq::setUseTrustedRelayPoint()
     * @uses UpdateSipTrunkReq::setRetryVideoCallAsAudio()
     * @uses UpdateSipTrunkReq::setSecurityProfileName()
     * @uses UpdateSipTrunkReq::setSipProfileName()
     * @uses UpdateSipTrunkReq::setCgpnTransformationCssName()
     * @uses UpdateSipTrunkReq::setUseDevicePoolCgpnTransformCss()
     * @uses UpdateSipTrunkReq::setGeoLocationName()
     * @uses UpdateSipTrunkReq::setGeoLocationFilterName()
     * @uses UpdateSipTrunkReq::setSendGeoLocation()
     * @uses UpdateSipTrunkReq::setCdpnTransformationCssName()
     * @uses UpdateSipTrunkReq::setUseDevicePoolCdpnTransformCss()
     * @uses UpdateSipTrunkReq::setUnattendedPort()
     * @uses UpdateSipTrunkReq::setTransmitUtf8()
     * @uses UpdateSipTrunkReq::setSubscribeCallingSearchSpaceName()
     * @uses UpdateSipTrunkReq::setRerouteCallingSearchSpaceName()
     * @uses UpdateSipTrunkReq::setReferCallingSearchSpaceName()
     * @uses UpdateSipTrunkReq::setMtpRequired()
     * @uses UpdateSipTrunkReq::setPresenceGroupName()
     * @uses UpdateSipTrunkReq::setUnknownPrefix()
     * @uses UpdateSipTrunkReq::setDestAddrIsSrv()
     * @uses UpdateSipTrunkReq::setTkSipCodec()
     * @uses UpdateSipTrunkReq::setSigDigits()
     * @uses UpdateSipTrunkReq::setConnectedNamePresentation()
     * @uses UpdateSipTrunkReq::setConnectedPartyIdPresentation()
     * @uses UpdateSipTrunkReq::setCallingPartySelection()
     * @uses UpdateSipTrunkReq::setCallingname()
     * @uses UpdateSipTrunkReq::setCallingLineIdPresentation()
     * @uses UpdateSipTrunkReq::setPrefixDn()
     * @uses UpdateSipTrunkReq::setCallerName()
     * @uses UpdateSipTrunkReq::setCallerIdDn()
     * @uses UpdateSipTrunkReq::setAcceptInboundRdnis()
     * @uses UpdateSipTrunkReq::setAcceptOutboundRdnis()
     * @uses UpdateSipTrunkReq::setSrtpAllowed()
     * @uses UpdateSipTrunkReq::setSrtpFallbackAllowed()
     * @uses UpdateSipTrunkReq::setIsPaiEnabled()
     * @uses UpdateSipTrunkReq::setSipPrivacy()
     * @uses UpdateSipTrunkReq::setIsRpidEnabled()
     * @uses UpdateSipTrunkReq::setSipAssertedType()
     * @uses UpdateSipTrunkReq::setDtmfSignalingMethod()
     * @uses UpdateSipTrunkReq::setRouteClassSignalling()
     * @uses UpdateSipTrunkReq::setSipTrunkType()
     * @uses UpdateSipTrunkReq::setPstnAccess()
     * @uses UpdateSipTrunkReq::setImeE164TransformationName()
     * @uses UpdateSipTrunkReq::setUseImePublicIpPort()
     * @uses UpdateSipTrunkReq::setUseDevicePoolCntdPnTransformationCss()
     * @uses UpdateSipTrunkReq::setCntdPnTransformationCssName()
     * @uses UpdateSipTrunkReq::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses UpdateSipTrunkReq::setRdnTransformationCssName()
     * @uses UpdateSipTrunkReq::setUseDevicePoolRdnTransformCss()
     * @uses UpdateSipTrunkReq::setSipNormalizationScriptName()
     * @uses UpdateSipTrunkReq::setRunOnEveryNode()
     * @uses UpdateSipTrunkReq::setRemoveDestinations()
     * @uses UpdateSipTrunkReq::setAddDestinations()
     * @uses UpdateSipTrunkReq::setDestinations()
     * @uses UpdateSipTrunkReq::setUnknownStripDigits()
     * @uses UpdateSipTrunkReq::setCgpnTransformationUnknownCssName()
     * @uses UpdateSipTrunkReq::setTunneledProtocol()
     * @uses UpdateSipTrunkReq::setAsn1RoseOidEncoding()
     * @uses UpdateSipTrunkReq::setQsigVariant()
     * @uses UpdateSipTrunkReq::setPathReplacementSupport()
     * @uses UpdateSipTrunkReq::setEnableQsigUtf8()
     * @uses UpdateSipTrunkReq::setScriptParameters()
     * @uses UpdateSipTrunkReq::setScriptTraceEnabled()
     * @uses UpdateSipTrunkReq::setTrunkTrafficSecure()
     * @uses UpdateSipTrunkReq::setCallingAndCalledPartyInfoFormat()
     * @uses UpdateSipTrunkReq::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses UpdateSipTrunkReq::setRequestUriDomainName()
     * @uses UpdateSipTrunkReq::setEnableCiscoRecordingQsigTunneling()
     * @uses UpdateSipTrunkReq::setRecordingInformation()
     * @uses UpdateSipTrunkReq::setCalledPartyUnknownTransformationCssName()
     * @uses UpdateSipTrunkReq::setCalledPartyUnknownPrefix()
     * @uses UpdateSipTrunkReq::setCalledPartyUnknownStripDigits()
     * @uses UpdateSipTrunkReq::setUseDevicePoolCalledCssUnkn()
     * @uses UpdateSipTrunkReq::setConfidentialAccess()
     * @param string $newName
     * @param string $description
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \StructType\XFkType $locationName
     * @param \StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \StructType\XFkType $securityProfileName
     * @param \StructType\XFkType $sipProfileName
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $unattendedPort
     * @param string $transmitUtf8
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \StructType\XFkType $rerouteCallingSearchSpaceName
     * @param \StructType\XFkType $referCallingSearchSpaceName
     * @param string $mtpRequired
     * @param \StructType\XFkType $presenceGroupName
     * @param string $unknownPrefix
     * @param string $destAddrIsSrv
     * @param string $tkSipCodec
     * @param \StructType\SigDigits $sigDigits
     * @param string $connectedNamePresentation
     * @param string $connectedPartyIdPresentation
     * @param string $callingPartySelection
     * @param string $callingname
     * @param string $callingLineIdPresentation
     * @param string $prefixDn
     * @param string $callerName
     * @param string $callerIdDn
     * @param string $acceptInboundRdnis
     * @param string $acceptOutboundRdnis
     * @param string $srtpAllowed
     * @param string $srtpFallbackAllowed
     * @param string $isPaiEnabled
     * @param string $sipPrivacy
     * @param string $isRpidEnabled
     * @param string $sipAssertedType
     * @param string $dtmfSignalingMethod
     * @param string $routeClassSignalling
     * @param string $sipTrunkType
     * @param string $pstnAccess
     * @param \StructType\XFkType $imeE164TransformationName
     * @param string $useImePublicIpPort
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param \StructType\XFkType $rdnTransformationCssName
     * @param string $useDevicePoolRdnTransformCss
     * @param \StructType\XFkType $sipNormalizationScriptName
     * @param string $runOnEveryNode
     * @param \StructType\RemoveDestinations $removeDestinations
     * @param \StructType\AddDestinations $addDestinations
     * @param \StructType\Destinations $destinations
     * @param string $unknownStripDigits
     * @param \StructType\XFkType $cgpnTransformationUnknownCssName
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param string $pathReplacementSupport
     * @param string $enableQsigUtf8
     * @param string $scriptParameters
     * @param string $scriptTraceEnabled
     * @param string $trunkTrafficSecure
     * @param string $callingAndCalledPartyInfoFormat
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $requestUriDomainName
     * @param string $enableCiscoRecordingQsigTunneling
     * @param string $recordingInformation
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartyUnknownStripDigits
     * @param string $useDevicePoolCalledCssUnkn
     * @param \StructType\ConfidentialAccess $confidentialAccess
     */
    public function __construct($newName = null, $description = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \StructType\XFkType $locationName = null, \StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $aarNeighborhoodName = null, $packetCaptureMode = 'None', $packetCaptureDuration = '0', $mlppDomainId = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', $useTrustedRelayPoint = 'Default', $retryVideoCallAsAudio = true, \StructType\XFkType $securityProfileName = null, \StructType\XFkType $sipProfileName = null, \StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = true, \StructType\XFkType $geoLocationName = null, \StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = true, $unattendedPort = false, $transmitUtf8 = false, \StructType\XFkType $subscribeCallingSearchSpaceName = null, \StructType\XFkType $rerouteCallingSearchSpaceName = null, \StructType\XFkType $referCallingSearchSpaceName = null, $mtpRequired = null, \StructType\XFkType $presenceGroupName = null, $unknownPrefix = null, $destAddrIsSrv = null, $tkSipCodec = '711ulaw', \StructType\SigDigits $sigDigits = '99', $connectedNamePresentation = 'Default', $connectedPartyIdPresentation = 'Default', $callingPartySelection = 'Originator', $callingname = 'Default', $callingLineIdPresentation = 'Default', $prefixDn = null, $callerName = null, $callerIdDn = null, $acceptInboundRdnis = null, $acceptOutboundRdnis = null, $srtpAllowed = false, $srtpFallbackAllowed = false, $isPaiEnabled = true, $sipPrivacy = 'Default', $isRpidEnabled = true, $sipAssertedType = 'Default', $dtmfSignalingMethod = 'No Preference', $routeClassSignalling = 'Default', $sipTrunkType = None(Default), $pstnAccess = true, \StructType\XFkType $imeE164TransformationName = null, $useImePublicIpPort = false, $useDevicePoolCntdPnTransformationCss = true, \StructType\XFkType $cntdPnTransformationCssName = null, $useDevicePoolCgpnTransformCssUnkn = true, \StructType\XFkType $rdnTransformationCssName = null, $useDevicePoolRdnTransformCss = true, \StructType\XFkType $sipNormalizationScriptName = null, $runOnEveryNode = false, \StructType\RemoveDestinations $removeDestinations = null, \StructType\AddDestinations $addDestinations = null, \StructType\Destinations $destinations = null, $unknownStripDigits = null, \StructType\XFkType $cgpnTransformationUnknownCssName = null, $tunneledProtocol = 'None', $asn1RoseOidEncoding = 'No Changes', $qsigVariant = 'No Changes', $pathReplacementSupport = false, $enableQsigUtf8 = false, $scriptParameters = null, $scriptTraceEnabled = false, $trunkTrafficSecure = 'When using both sRTP and TLS', $callingAndCalledPartyInfoFormat = 'Deliver DN only in connected party', $useCallerIdCallerNameinUriOutgoingRequest = null, $requestUriDomainName = null, $enableCiscoRecordingQsigTunneling = false, $recordingInformation = '0', \StructType\XFkType $calledPartyUnknownTransformationCssName = null, $calledPartyUnknownPrefix = null, $calledPartyUnknownStripDigits = null, $useDevicePoolCalledCssUnkn = true, \StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setUnattendedPort($unattendedPort)
            ->setTransmitUtf8($transmitUtf8)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setReferCallingSearchSpaceName($referCallingSearchSpaceName)
            ->setMtpRequired($mtpRequired)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnknownPrefix($unknownPrefix)
            ->setDestAddrIsSrv($destAddrIsSrv)
            ->setTkSipCodec($tkSipCodec)
            ->setSigDigits($sigDigits)
            ->setConnectedNamePresentation($connectedNamePresentation)
            ->setConnectedPartyIdPresentation($connectedPartyIdPresentation)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingname($callingname)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setPrefixDn($prefixDn)
            ->setCallerName($callerName)
            ->setCallerIdDn($callerIdDn)
            ->setAcceptInboundRdnis($acceptInboundRdnis)
            ->setAcceptOutboundRdnis($acceptOutboundRdnis)
            ->setSrtpAllowed($srtpAllowed)
            ->setSrtpFallbackAllowed($srtpFallbackAllowed)
            ->setIsPaiEnabled($isPaiEnabled)
            ->setSipPrivacy($sipPrivacy)
            ->setIsRpidEnabled($isRpidEnabled)
            ->setSipAssertedType($sipAssertedType)
            ->setDtmfSignalingMethod($dtmfSignalingMethod)
            ->setRouteClassSignalling($routeClassSignalling)
            ->setSipTrunkType($sipTrunkType)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseImePublicIpPort($useImePublicIpPort)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setRdnTransformationCssName($rdnTransformationCssName)
            ->setUseDevicePoolRdnTransformCss($useDevicePoolRdnTransformCss)
            ->setSipNormalizationScriptName($sipNormalizationScriptName)
            ->setRunOnEveryNode($runOnEveryNode)
            ->setRemoveDestinations($removeDestinations)
            ->setAddDestinations($addDestinations)
            ->setDestinations($destinations)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setCgpnTransformationUnknownCssName($cgpnTransformationUnknownCssName)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setEnableQsigUtf8($enableQsigUtf8)
            ->setScriptParameters($scriptParameters)
            ->setScriptTraceEnabled($scriptTraceEnabled)
            ->setTrunkTrafficSecure($trunkTrafficSecure)
            ->setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setRequestUriDomainName($requestUriDomainName)
            ->setEnableCiscoRecordingQsigTunneling($enableCiscoRecordingQsigTunneling)
            ->setRecordingInformation($recordingInformation)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setConfidentialAccess($confidentialAccess);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 128) || (is_array($newName) && count($newName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \EnumType\XNetworkLocation::valueIsValid()
     * @uses \EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', \EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \EnumType\XPreemption::valueIsValid()
     * @uses \EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = true)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $securityProfileName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSecurityProfileName(\StructType\XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get sipProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSipProfileName()
    {
        return isset($this->sipProfileName) ? $this->sipProfileName : null;
    }
    /**
     * Set sipProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $sipProfileName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSipProfileName(\StructType\XFkType $sipProfileName = null)
    {
        if (is_null($sipProfileName) || (is_array($sipProfileName) && empty($sipProfileName))) {
            unset($this->sipProfileName);
        } else {
            $this->sipProfileName = $sipProfileName;
        }
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUnattendedPort($unattendedPort = false)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setTransmitUtf8($transmitUtf8 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSubscribeCallingSearchSpaceName(\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return isset($this->rerouteCallingSearchSpaceName) ? $this->rerouteCallingSearchSpaceName : null;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRerouteCallingSearchSpaceName(\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        if (is_null($rerouteCallingSearchSpaceName) || (is_array($rerouteCallingSearchSpaceName) && empty($rerouteCallingSearchSpaceName))) {
            unset($this->rerouteCallingSearchSpaceName);
        } else {
            $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get referCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getReferCallingSearchSpaceName()
    {
        return isset($this->referCallingSearchSpaceName) ? $this->referCallingSearchSpaceName : null;
    }
    /**
     * Set referCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $referCallingSearchSpaceName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setReferCallingSearchSpaceName(\StructType\XFkType $referCallingSearchSpaceName = null)
    {
        if (is_null($referCallingSearchSpaceName) || (is_array($referCallingSearchSpaceName) && empty($referCallingSearchSpaceName))) {
            unset($this->referCallingSearchSpaceName);
        } else {
            $this->referCallingSearchSpaceName = $referCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \StructType\XFkType $presenceGroupName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setPresenceGroupName(\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unknownPrefix) && strlen($unknownPrefix) > 16) || (is_array($unknownPrefix) && count($unknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($unknownPrefix) ? strlen($unknownPrefix) : count($unknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get destAddrIsSrv value
     * @return string|null
     */
    public function getDestAddrIsSrv()
    {
        return $this->destAddrIsSrv;
    }
    /**
     * Set destAddrIsSrv value
     * @param string $destAddrIsSrv
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setDestAddrIsSrv($destAddrIsSrv = null)
    {
        // validation for constraint: pattern
        if (is_scalar($destAddrIsSrv) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($destAddrIsSrv, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destAddrIsSrv) && !is_string($destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destAddrIsSrv)), __LINE__);
        }
        $this->destAddrIsSrv = $destAddrIsSrv;
        return $this;
    }
    /**
     * Get tkSipCodec value
     * @return string|null
     */
    public function getTkSipCodec()
    {
        return $this->tkSipCodec;
    }
    /**
     * Set tkSipCodec value
     * @uses \EnumType\XSIPCodec::valueIsValid()
     * @uses \EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tkSipCodec
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setTkSipCodec($tkSipCodec = '711ulaw')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPCodec::valueIsValid($tkSipCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tkSipCodec, implode(', ', \EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->tkSipCodec = $tkSipCodec;
        return $this;
    }
    /**
     * Get sigDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return isset($this->sigDigits) ? $this->sigDigits : null;
    }
    /**
     * Set sigDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SigDigits $sigDigits
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSigDigits(\StructType\SigDigits $sigDigits = '99')
    {
        if (is_null($sigDigits) || (is_array($sigDigits) && empty($sigDigits))) {
            unset($this->sigDigits);
        } else {
            $this->sigDigits = $sigDigits;
        }
        return $this;
    }
    /**
     * Get connectedNamePresentation value
     * @return string|null
     */
    public function getConnectedNamePresentation()
    {
        return $this->connectedNamePresentation;
    }
    /**
     * Set connectedNamePresentation value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentation
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setConnectedNamePresentation($connectedNamePresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($connectedNamePresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedNamePresentation, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentation = $connectedNamePresentation;
        return $this;
    }
    /**
     * Get connectedPartyIdPresentation value
     * @return string|null
     */
    public function getConnectedPartyIdPresentation()
    {
        return $this->connectedPartyIdPresentation;
    }
    /**
     * Set connectedPartyIdPresentation value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedPartyIdPresentation
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setConnectedPartyIdPresentation($connectedPartyIdPresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($connectedPartyIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedPartyIdPresentation, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedPartyIdPresentation = $connectedPartyIdPresentation;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \EnumType\XCallingPartySelection::valueIsValid()
     * @uses \EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', \EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingname value
     * @return string|null
     */
    public function getCallingname()
    {
        return $this->callingname;
    }
    /**
     * Set callingname value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingname
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCallingname($callingname = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($callingname)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingname, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingname = $callingname;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses \EnumType\XPresentationBit::valueIsValid()
     * @uses \EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLineIdPresentation, implode(', ', \EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get prefixDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDn()
    {
        return isset($this->prefixDn) ? $this->prefixDn : null;
    }
    /**
     * Set prefixDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDn
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDn) && strlen($prefixDn) > 50) || (is_array($prefixDn) && count($prefixDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($prefixDn) ? strlen($prefixDn) : count($prefixDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDn)), __LINE__);
        }
        if (is_null($prefixDn) || (is_array($prefixDn) && empty($prefixDn))) {
            unset($this->prefixDn);
        } else {
            $this->prefixDn = $prefixDn;
        }
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerName) && strlen($callerName) > 50) || (is_array($callerName) && count($callerName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerName) ? strlen($callerName) : count($callerName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 50) || (is_array($callerIdDn) && count($callerIdDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get acceptInboundRdnis value
     * @return string|null
     */
    public function getAcceptInboundRdnis()
    {
        return $this->acceptInboundRdnis;
    }
    /**
     * Set acceptInboundRdnis value
     * @param string $acceptInboundRdnis
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setAcceptInboundRdnis($acceptInboundRdnis = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptInboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptInboundRdnis, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptInboundRdnis) && !is_string($acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptInboundRdnis)), __LINE__);
        }
        $this->acceptInboundRdnis = $acceptInboundRdnis;
        return $this;
    }
    /**
     * Get acceptOutboundRdnis value
     * @return string|null
     */
    public function getAcceptOutboundRdnis()
    {
        return $this->acceptOutboundRdnis;
    }
    /**
     * Set acceptOutboundRdnis value
     * @param string $acceptOutboundRdnis
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setAcceptOutboundRdnis($acceptOutboundRdnis = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptOutboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptOutboundRdnis, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptOutboundRdnis) && !is_string($acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptOutboundRdnis)), __LINE__);
        }
        $this->acceptOutboundRdnis = $acceptOutboundRdnis;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSrtpAllowed($srtpAllowed = false)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpAllowed)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get srtpFallbackAllowed value
     * @return string|null
     */
    public function getSrtpFallbackAllowed()
    {
        return $this->srtpFallbackAllowed;
    }
    /**
     * Set srtpFallbackAllowed value
     * @param string $srtpFallbackAllowed
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSrtpFallbackAllowed($srtpFallbackAllowed = false)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpFallbackAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpFallbackAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpFallbackAllowed) && !is_string($srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpFallbackAllowed)), __LINE__);
        }
        $this->srtpFallbackAllowed = $srtpFallbackAllowed;
        return $this;
    }
    /**
     * Get isPaiEnabled value
     * @return string|null
     */
    public function getIsPaiEnabled()
    {
        return $this->isPaiEnabled;
    }
    /**
     * Set isPaiEnabled value
     * @param string $isPaiEnabled
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setIsPaiEnabled($isPaiEnabled = true)
    {
        // validation for constraint: pattern
        if (is_scalar($isPaiEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPaiEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPaiEnabled) && !is_string($isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPaiEnabled)), __LINE__);
        }
        $this->isPaiEnabled = $isPaiEnabled;
        return $this;
    }
    /**
     * Get sipPrivacy value
     * @return string|null
     */
    public function getSipPrivacy()
    {
        return $this->sipPrivacy;
    }
    /**
     * Set sipPrivacy value
     * @uses \EnumType\XSipPrivacy::valueIsValid()
     * @uses \EnumType\XSipPrivacy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPrivacy
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSipPrivacy($sipPrivacy = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSipPrivacy::valueIsValid($sipPrivacy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipPrivacy, implode(', ', \EnumType\XSipPrivacy::getValidValues())), __LINE__);
        }
        $this->sipPrivacy = $sipPrivacy;
        return $this;
    }
    /**
     * Get isRpidEnabled value
     * @return string|null
     */
    public function getIsRpidEnabled()
    {
        return $this->isRpidEnabled;
    }
    /**
     * Set isRpidEnabled value
     * @param string $isRpidEnabled
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setIsRpidEnabled($isRpidEnabled = true)
    {
        // validation for constraint: pattern
        if (is_scalar($isRpidEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isRpidEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isRpidEnabled) && !is_string($isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isRpidEnabled)), __LINE__);
        }
        $this->isRpidEnabled = $isRpidEnabled;
        return $this;
    }
    /**
     * Get sipAssertedType value
     * @return string|null
     */
    public function getSipAssertedType()
    {
        return $this->sipAssertedType;
    }
    /**
     * Set sipAssertedType value
     * @uses \EnumType\XSipAssertedType::valueIsValid()
     * @uses \EnumType\XSipAssertedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipAssertedType
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSipAssertedType($sipAssertedType = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSipAssertedType::valueIsValid($sipAssertedType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipAssertedType, implode(', ', \EnumType\XSipAssertedType::getValidValues())), __LINE__);
        }
        $this->sipAssertedType = $sipAssertedType;
        return $this;
    }
    /**
     * Get dtmfSignalingMethod value
     * @return string|null
     */
    public function getDtmfSignalingMethod()
    {
        return $this->dtmfSignalingMethod;
    }
    /**
     * Set dtmfSignalingMethod value
     * @uses \EnumType\XDTMFSignaling::valueIsValid()
     * @uses \EnumType\XDTMFSignaling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfSignalingMethod
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setDtmfSignalingMethod($dtmfSignalingMethod = 'No Preference')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDTMFSignaling::valueIsValid($dtmfSignalingMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfSignalingMethod, implode(', ', \EnumType\XDTMFSignaling::getValidValues())), __LINE__);
        }
        $this->dtmfSignalingMethod = $dtmfSignalingMethod;
        return $this;
    }
    /**
     * Get routeClassSignalling value
     * @return string|null
     */
    public function getRouteClassSignalling()
    {
        return $this->routeClassSignalling;
    }
    /**
     * Set routeClassSignalling value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClassSignalling
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRouteClassSignalling($routeClassSignalling = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($routeClassSignalling)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routeClassSignalling, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->routeClassSignalling = $routeClassSignalling;
        return $this;
    }
    /**
     * Get sipTrunkType value
     * @return string|null
     */
    public function getSipTrunkType()
    {
        return $this->sipTrunkType;
    }
    /**
     * Set sipTrunkType value
     * @uses \EnumType\XTrunkService::valueIsValid()
     * @uses \EnumType\XTrunkService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipTrunkType
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSipTrunkType($sipTrunkType = None(Default))
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkService::valueIsValid($sipTrunkType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipTrunkType, implode(', ', \EnumType\XTrunkService::getValidValues())), __LINE__);
        }
        $this->sipTrunkType = $sipTrunkType;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setPstnAccess($pstnAccess = true)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $imeE164TransformationName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setImeE164TransformationName(\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get useImePublicIpPort value
     * @return string|null
     */
    public function getUseImePublicIpPort()
    {
        return $this->useImePublicIpPort;
    }
    /**
     * Set useImePublicIpPort value
     * @param string $useImePublicIpPort
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseImePublicIpPort($useImePublicIpPort = false)
    {
        // validation for constraint: pattern
        if (is_scalar($useImePublicIpPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useImePublicIpPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useImePublicIpPort) && !is_string($useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useImePublicIpPort)), __LINE__);
        }
        $this->useImePublicIpPort = $useImePublicIpPort;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCntdPnTransformationCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCntdPnTransformationCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !is_string($useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCntdPnTransformationCss)), __LINE__);
        }
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cntdPnTransformationCssName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCntdPnTransformationCssName(\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get rdnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRdnTransformationCssName()
    {
        return isset($this->rdnTransformationCssName) ? $this->rdnTransformationCssName : null;
    }
    /**
     * Set rdnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $rdnTransformationCssName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRdnTransformationCssName(\StructType\XFkType $rdnTransformationCssName = null)
    {
        if (is_null($rdnTransformationCssName) || (is_array($rdnTransformationCssName) && empty($rdnTransformationCssName))) {
            unset($this->rdnTransformationCssName);
        } else {
            $this->rdnTransformationCssName = $rdnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolRdnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolRdnTransformCss()
    {
        return $this->useDevicePoolRdnTransformCss;
    }
    /**
     * Set useDevicePoolRdnTransformCss value
     * @param string $useDevicePoolRdnTransformCss
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseDevicePoolRdnTransformCss($useDevicePoolRdnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolRdnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolRdnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolRdnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolRdnTransformCss) && !is_string($useDevicePoolRdnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolRdnTransformCss)), __LINE__);
        }
        $this->useDevicePoolRdnTransformCss = $useDevicePoolRdnTransformCss;
        return $this;
    }
    /**
     * Get sipNormalizationScriptName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSipNormalizationScriptName()
    {
        return isset($this->sipNormalizationScriptName) ? $this->sipNormalizationScriptName : null;
    }
    /**
     * Set sipNormalizationScriptName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $sipNormalizationScriptName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setSipNormalizationScriptName(\StructType\XFkType $sipNormalizationScriptName = null)
    {
        if (is_null($sipNormalizationScriptName) || (is_array($sipNormalizationScriptName) && empty($sipNormalizationScriptName))) {
            unset($this->sipNormalizationScriptName);
        } else {
            $this->sipNormalizationScriptName = $sipNormalizationScriptName;
        }
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRunOnEveryNode($runOnEveryNode = false)
    {
        // validation for constraint: pattern
        if (is_scalar($runOnEveryNode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($runOnEveryNode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runOnEveryNode) && !is_string($runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runOnEveryNode)), __LINE__);
        }
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Get removeDestinations value
     * @return \StructType\RemoveDestinations|null
     */
    public function getRemoveDestinations()
    {
        return $this->removeDestinations;
    }
    /**
     * Set removeDestinations value
     * @param \StructType\RemoveDestinations $removeDestinations
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRemoveDestinations(\StructType\RemoveDestinations $removeDestinations = null)
    {
        $this->removeDestinations = $removeDestinations;
        return $this;
    }
    /**
     * Get addDestinations value
     * @return \StructType\AddDestinations|null
     */
    public function getAddDestinations()
    {
        return $this->addDestinations;
    }
    /**
     * Set addDestinations value
     * @param \StructType\AddDestinations $addDestinations
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setAddDestinations(\StructType\AddDestinations $addDestinations = null)
    {
        $this->addDestinations = $addDestinations;
        return $this;
    }
    /**
     * Get destinations value
     * @return \StructType\Destinations|null
     */
    public function getDestinations()
    {
        return $this->destinations;
    }
    /**
     * Set destinations value
     * @param \StructType\Destinations $destinations
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setDestinations(\StructType\Destinations $destinations = null)
    {
        $this->destinations = $destinations;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unknownStripDigits
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unknownStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get cgpnTransformationUnknownCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationUnknownCssName()
    {
        return isset($this->cgpnTransformationUnknownCssName) ? $this->cgpnTransformationUnknownCssName : null;
    }
    /**
     * Set cgpnTransformationUnknownCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $cgpnTransformationUnknownCssName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCgpnTransformationUnknownCssName(\StructType\XFkType $cgpnTransformationUnknownCssName = null)
    {
        if (is_null($cgpnTransformationUnknownCssName) || (is_array($cgpnTransformationUnknownCssName) && empty($cgpnTransformationUnknownCssName))) {
            unset($this->cgpnTransformationUnknownCssName);
        } else {
            $this->cgpnTransformationUnknownCssName = $cgpnTransformationUnknownCssName;
        }
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @uses \EnumType\XTunneledProtocol::valueIsValid()
     * @uses \EnumType\XTunneledProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunneledProtocol
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setTunneledProtocol($tunneledProtocol = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTunneledProtocol::valueIsValid($tunneledProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tunneledProtocol, implode(', ', \EnumType\XTunneledProtocol::getValidValues())), __LINE__);
        }
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses \EnumType\XASN1RoseOidEncoding::valueIsValid()
     * @uses \EnumType\XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $asn1RoseOidEncoding, implode(', ', \EnumType\XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @uses \EnumType\XQSIGVariant::valueIsValid()
     * @uses \EnumType\XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qsigVariant
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setQsigVariant($qsigVariant = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XQSIGVariant::valueIsValid($qsigVariant)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qsigVariant, implode(', ', \EnumType\XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setPathReplacementSupport($pathReplacementSupport = false)
    {
        // validation for constraint: pattern
        if (is_scalar($pathReplacementSupport) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pathReplacementSupport, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pathReplacementSupport) && !is_string($pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pathReplacementSupport)), __LINE__);
        }
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get enableQsigUtf8 value
     * @return string|null
     */
    public function getEnableQsigUtf8()
    {
        return $this->enableQsigUtf8;
    }
    /**
     * Set enableQsigUtf8 value
     * @param string $enableQsigUtf8
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setEnableQsigUtf8($enableQsigUtf8 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableQsigUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableQsigUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableQsigUtf8) && !is_string($enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableQsigUtf8)), __LINE__);
        }
        $this->enableQsigUtf8 = $enableQsigUtf8;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setScriptParameters($scriptParameters = null)
    {
        // validation for constraint: string
        if (!is_null($scriptParameters) && !is_string($scriptParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptParameters)), __LINE__);
        }
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get scriptTraceEnabled value
     * @return string|null
     */
    public function getScriptTraceEnabled()
    {
        return $this->scriptTraceEnabled;
    }
    /**
     * Set scriptTraceEnabled value
     * @param string $scriptTraceEnabled
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setScriptTraceEnabled($scriptTraceEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($scriptTraceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($scriptTraceEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($scriptTraceEnabled) && !is_string($scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptTraceEnabled)), __LINE__);
        }
        $this->scriptTraceEnabled = $scriptTraceEnabled;
        return $this;
    }
    /**
     * Get trunkTrafficSecure value
     * @return string|null
     */
    public function getTrunkTrafficSecure()
    {
        return $this->trunkTrafficSecure;
    }
    /**
     * Set trunkTrafficSecure value
     * @uses \EnumType\XSIPTrunkCallLegSecurity::valueIsValid()
     * @uses \EnumType\XSIPTrunkCallLegSecurity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkTrafficSecure
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setTrunkTrafficSecure($trunkTrafficSecure = 'When using both sRTP and TLS')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPTrunkCallLegSecurity::valueIsValid($trunkTrafficSecure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkTrafficSecure, implode(', ', \EnumType\XSIPTrunkCallLegSecurity::getValidValues())), __LINE__);
        }
        $this->trunkTrafficSecure = $trunkTrafficSecure;
        return $this;
    }
    /**
     * Get callingAndCalledPartyInfoFormat value
     * @return string|null
     */
    public function getCallingAndCalledPartyInfoFormat()
    {
        return $this->callingAndCalledPartyInfoFormat;
    }
    /**
     * Set callingAndCalledPartyInfoFormat value
     * @uses \EnumType\XSIPIdentityBlend::valueIsValid()
     * @uses \EnumType\XSIPIdentityBlend::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingAndCalledPartyInfoFormat
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCallingAndCalledPartyInfoFormat($callingAndCalledPartyInfoFormat = 'Deliver DN only in connected party')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPIdentityBlend::valueIsValid($callingAndCalledPartyInfoFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingAndCalledPartyInfoFormat, implode(', ', \EnumType\XSIPIdentityBlend::getValidValues())), __LINE__);
        }
        $this->callingAndCalledPartyInfoFormat = $callingAndCalledPartyInfoFormat;
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useCallerIdCallerNameinUriOutgoingRequest) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useCallerIdCallerNameinUriOutgoingRequest, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !is_string($useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCallerIdCallerNameinUriOutgoingRequest)), __LINE__);
        }
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get requestUriDomainName value
     * @return string|null
     */
    public function getRequestUriDomainName()
    {
        return $this->requestUriDomainName;
    }
    /**
     * Set requestUriDomainName value
     * @param string $requestUriDomainName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRequestUriDomainName($requestUriDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($requestUriDomainName) && !is_string($requestUriDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestUriDomainName)), __LINE__);
        }
        $this->requestUriDomainName = $requestUriDomainName;
        return $this;
    }
    /**
     * Get enableCiscoRecordingQsigTunneling value
     * @return string|null
     */
    public function getEnableCiscoRecordingQsigTunneling()
    {
        return $this->enableCiscoRecordingQsigTunneling;
    }
    /**
     * Set enableCiscoRecordingQsigTunneling value
     * @param string $enableCiscoRecordingQsigTunneling
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setEnableCiscoRecordingQsigTunneling($enableCiscoRecordingQsigTunneling = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableCiscoRecordingQsigTunneling) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableCiscoRecordingQsigTunneling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableCiscoRecordingQsigTunneling, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableCiscoRecordingQsigTunneling) && !is_string($enableCiscoRecordingQsigTunneling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableCiscoRecordingQsigTunneling)), __LINE__);
        }
        $this->enableCiscoRecordingQsigTunneling = $enableCiscoRecordingQsigTunneling;
        return $this;
    }
    /**
     * Get recordingInformation value
     * @return string|null
     */
    public function getRecordingInformation()
    {
        return $this->recordingInformation;
    }
    /**
     * Set recordingInformation value
     * @param string $recordingInformation
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setRecordingInformation($recordingInformation = '0')
    {
        // validation for constraint: string
        if (!is_null($recordingInformation) && !is_string($recordingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recordingInformation)), __LINE__);
        }
        $this->recordingInformation = $recordingInformation;
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return isset($this->calledPartyUnknownTransformationCssName) ? $this->calledPartyUnknownTransformationCssName : null;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCalledPartyUnknownTransformationCssName(\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        if (is_null($calledPartyUnknownTransformationCssName) || (is_array($calledPartyUnknownTransformationCssName) && empty($calledPartyUnknownTransformationCssName))) {
            unset($this->calledPartyUnknownTransformationCssName);
        } else {
            $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyUnknownPrefix) && strlen($calledPartyUnknownPrefix) > 16) || (is_array($calledPartyUnknownPrefix) && count($calledPartyUnknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyUnknownPrefix) ? strlen($calledPartyUnknownPrefix) : count($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return isset($this->calledPartyUnknownStripDigits) ? $this->calledPartyUnknownStripDigits : null;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyUnknownStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($calledPartyUnknownStripDigits) || (is_array($calledPartyUnknownStripDigits) && empty($calledPartyUnknownStripDigits))) {
            unset($this->calledPartyUnknownStripDigits);
        } else {
            $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssUnkn) && !is_string($useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\UpdateSipTrunkReq
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSipTrunkReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
