<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSipProfileReq StructType
 * @subpackage Structs
 */
class UpdateSipProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 100
     * @var string
     */
    public $description;
    /**
     * The defaultTelephonyEventPayloadType
     * Meta informations extracted from the WSDL
     * - default: 101
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $defaultTelephonyEventPayloadType;
    /**
     * The redirectByApplication
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectByApplication;
    /**
     * The ringing180
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ringing180;
    /**
     * The timerInvite
     * Meta informations extracted from the WSDL
     * - default: 180
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerInvite;
    /**
     * The timerRegisterDelta
     * Meta informations extracted from the WSDL
     * - default: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerRegisterDelta;
    /**
     * The timerRegister
     * Meta informations extracted from the WSDL
     * - default: 3600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerRegister;
    /**
     * The timerT1
     * Meta informations extracted from the WSDL
     * - default: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerT1;
    /**
     * The timerT2
     * Meta informations extracted from the WSDL
     * - default: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerT2;
    /**
     * The retryInvite
     * Meta informations extracted from the WSDL
     * - default: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $retryInvite;
    /**
     * The retryNotInvite
     * Meta informations extracted from the WSDL
     * - default: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $retryNotInvite;
    /**
     * The startMediaPort
     * Meta informations extracted from the WSDL
     * - default: 16384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startMediaPort;
    /**
     * The stopMediaPort
     * Meta informations extracted from the WSDL
     * - default: 32766
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $stopMediaPort;
    /**
     * The startVideoPort
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $startVideoPort;
    /**
     * The stopVideoPort
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $stopVideoPort;
    /**
     * The dscpForAudioCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dscpForAudioCalls;
    /**
     * The dscpForVideoCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dscpForVideoCalls;
    /**
     * The dscpForAudioPortionOfVideoCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dscpForAudioPortionOfVideoCalls;
    /**
     * The dscpForTelePresenceCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dscpForTelePresenceCalls;
    /**
     * The dscpForAudioPortionOfTelePresenceCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dscpForAudioPortionOfTelePresenceCalls;
    /**
     * The callpickupListUri
     * Meta informations extracted from the WSDL
     * - default: x-cisco-serviceuri-opickup
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $callpickupListUri;
    /**
     * The callpickupGroupUri
     * Meta informations extracted from the WSDL
     * - default: x-cisco-serviceuri-gpickup
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $callpickupGroupUri;
    /**
     * The meetmeServiceUrl
     * Meta informations extracted from the WSDL
     * - default: x-cisco-serviceuri-meetme
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $meetmeServiceUrl;
    /**
     * The userInfo
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userInfo;
    /**
     * The dtmfDbLevel
     * Meta informations extracted from the WSDL
     * - default: Nominal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dtmfDbLevel;
    /**
     * The callHoldRingback
     * Meta informations extracted from the WSDL
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callHoldRingback;
    /**
     * The anonymousCallBlock
     * Meta informations extracted from the WSDL
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $anonymousCallBlock;
    /**
     * The callerIdBlock
     * Meta informations extracted from the WSDL
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callerIdBlock;
    /**
     * The dndControl
     * Meta informations extracted from the WSDL
     * - default: User
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndControl;
    /**
     * The telnetLevel
     * Meta informations extracted from the WSDL
     * - default: Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $telnetLevel;
    /**
     * The timerKeepAlive
     * Meta informations extracted from the WSDL
     * - default: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerKeepAlive;
    /**
     * The timerSubscribe
     * Meta informations extracted from the WSDL
     * - default: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerSubscribe;
    /**
     * The timerSubscribeDelta
     * Meta informations extracted from the WSDL
     * - default: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerSubscribeDelta;
    /**
     * The maxRedirects
     * Meta informations extracted from the WSDL
     * - default: 70
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxRedirects;
    /**
     * The timerOffHookToFirstDigit
     * Meta informations extracted from the WSDL
     * - default: 15000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timerOffHookToFirstDigit;
    /**
     * The callForwardUri
     * Meta informations extracted from the WSDL
     * - default: x-cisco-serviceuri-cfwdall
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $callForwardUri;
    /**
     * The abbreviatedDialUri
     * Meta informations extracted from the WSDL
     * - default: x-cisco-serviceuri-abbrdial
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $abbreviatedDialUri;
    /**
     * The confJointEnable
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $confJointEnable;
    /**
     * The rfc2543Hold
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2543Hold;
    /**
     * The semiAttendedTransfer
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $semiAttendedTransfer;
    /**
     * The enableVad
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableVad;
    /**
     * The stutterMsgWaiting
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $stutterMsgWaiting;
    /**
     * The callStats
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $callStats;
    /**
     * The t38Invite
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $t38Invite;
    /**
     * The rerouteIncomingRequest
     * Meta informations extracted from the WSDL
     * - default: Never
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rerouteIncomingRequest;
    /**
     * The resourcePriorityNamespaceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $resourcePriorityNamespaceListName;
    /**
     * The enableAnatForEarlyOfferCalls
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableAnatForEarlyOfferCalls;
    /**
     * The rsvpOverSip
     * Meta informations extracted from the WSDL
     * - default: Local RSVP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rsvpOverSip;
    /**
     * The fallbackToLocalRsvp
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $fallbackToLocalRsvp;
    /**
     * The sipRe11XxEnabled
     * Meta informations extracted from the WSDL
     * - default: Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipRe11XxEnabled;
    /**
     * The gClear
     * Meta informations extracted from the WSDL
     * - default: Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $gClear;
    /**
     * The sendRecvSDPInMidCallInvite
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This field is editable only if earlyOfferSupportForVoiceCall is set to true.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRecvSDPInMidCallInvite;
    /**
     * The enableOutboundOptionsPing
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundOptionsPing;
    /**
     * The optionsPingIntervalWhenStatusOK
     * Meta informations extracted from the WSDL
     * - default: 60
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $optionsPingIntervalWhenStatusOK;
    /**
     * The optionsPingIntervalWhenStatusNotOK
     * Meta informations extracted from the WSDL
     * - default: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $optionsPingIntervalWhenStatusNotOK;
    /**
     * The deliverConferenceBridgeIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $deliverConferenceBridgeIdentifier;
    /**
     * The sipOptionsRetryCount
     * Meta informations extracted from the WSDL
     * - default: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipOptionsRetryCount;
    /**
     * The sipOptionsRetryTimer
     * Meta informations extracted from the WSDL
     * - default: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipOptionsRetryTimer;
    /**
     * The sipBandwidthModifier
     * Meta informations extracted from the WSDL
     * - default: TIAS and AS
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipBandwidthModifier;
    /**
     * The enableUriOutdialSupport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $enableUriOutdialSupport;
    /**
     * The userAgentServerHeaderInfo
     * Meta informations extracted from the WSDL
     * - default: Send Unified CM Version Information as User-Agent Header
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $userAgentServerHeaderInfo;
    /**
     * The allowPresentationSharingUsingBfcp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowPresentationSharingUsingBfcp;
    /**
     * The scriptParameters
     * Meta informations extracted from the WSDL
     * - documentation: This field will be enabled only when SIP Normalization Script is present.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scriptParameters;
    /**
     * The isScriptTraceEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This field will be enabled only when SIP Normalization Script is present.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isScriptTraceEnabled;
    /**
     * The sipNormalizationScript
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $sipNormalizationScript;
    /**
     * The allowiXApplicationMedia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowiXApplicationMedia;
    /**
     * The dialStringInterpretation
     * Meta informations extracted from the WSDL
     * - default: Phone number consists of characters 0-9, *, #, and + (others treated as URI addresses)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dialStringInterpretation;
    /**
     * The acceptAudioCodecPreferences
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $acceptAudioCodecPreferences;
    /**
     * The mlppUserAuthorization
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mlppUserAuthorization;
    /**
     * The isAssuredSipServiceEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isAssuredSipServiceEnabled;
    /**
     * The resourcePriorityNamespace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $resourcePriorityNamespace;
    /**
     * The useCallerIdCallerNameinUriOutgoingRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useCallerIdCallerNameinUriOutgoingRequest;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $callerIdDn;
    /**
     * The callerName
     * Meta informations extracted from the WSDL
     * - documentation: Characters which are not valid for caller name are ampersand, braces, less than or greater than, percentage sign, double quotes, square brackets and pipe.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $callerName;
    /**
     * The callingLineIdentification
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLineIdentification;
    /**
     * The rejectAnonymousIncomingCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousIncomingCall;
    /**
     * The callpickupUri
     * Meta informations extracted from the WSDL
     * - default: x-cisco-serviceuri-pickup
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $callpickupUri;
    /**
     * The rejectAnonymousOutgoingCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rejectAnonymousOutgoingCall;
    /**
     * The videoCallTrafficClass
     * Meta informations extracted from the WSDL
     * - default: Mixed
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $videoCallTrafficClass;
    /**
     * The sdpTransparency
     * Meta informations extracted from the WSDL
     * - documentation: SDP Transparency Profile for SIP Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $sdpTransparency;
    /**
     * The allowMultipleCodecs
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowMultipleCodecs;
    /**
     * The sipSessionRefreshMethod
     * Meta informations extracted from the WSDL
     * - default: Invite
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipSessionRefreshMethod;
    /**
     * The earlyOfferSuppVoiceCall
     * Meta informations extracted from the WSDL
     * - default: Disabled (Default value)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $earlyOfferSuppVoiceCall;
    /**
     * The cucmVersionInSipHeader
     * Meta informations extracted from the WSDL
     * - default: Major And Minor
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cucmVersionInSipHeader;
    /**
     * The confidentialAccessLevelHeaders
     * Meta informations extracted from the WSDL
     * - default: Disabled
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $confidentialAccessLevelHeaders;
    /**
     * The destRouteString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destRouteString;
    /**
     * The inactiveSDPRequired
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $inactiveSDPRequired;
    /**
     * Constructor method for UpdateSipProfileReq
     * @uses UpdateSipProfileReq::setNewName()
     * @uses UpdateSipProfileReq::setDescription()
     * @uses UpdateSipProfileReq::setDefaultTelephonyEventPayloadType()
     * @uses UpdateSipProfileReq::setRedirectByApplication()
     * @uses UpdateSipProfileReq::setRinging180()
     * @uses UpdateSipProfileReq::setTimerInvite()
     * @uses UpdateSipProfileReq::setTimerRegisterDelta()
     * @uses UpdateSipProfileReq::setTimerRegister()
     * @uses UpdateSipProfileReq::setTimerT1()
     * @uses UpdateSipProfileReq::setTimerT2()
     * @uses UpdateSipProfileReq::setRetryInvite()
     * @uses UpdateSipProfileReq::setRetryNotInvite()
     * @uses UpdateSipProfileReq::setStartMediaPort()
     * @uses UpdateSipProfileReq::setStopMediaPort()
     * @uses UpdateSipProfileReq::setStartVideoPort()
     * @uses UpdateSipProfileReq::setStopVideoPort()
     * @uses UpdateSipProfileReq::setDscpForAudioCalls()
     * @uses UpdateSipProfileReq::setDscpForVideoCalls()
     * @uses UpdateSipProfileReq::setDscpForAudioPortionOfVideoCalls()
     * @uses UpdateSipProfileReq::setDscpForTelePresenceCalls()
     * @uses UpdateSipProfileReq::setDscpForAudioPortionOfTelePresenceCalls()
     * @uses UpdateSipProfileReq::setCallpickupListUri()
     * @uses UpdateSipProfileReq::setCallpickupGroupUri()
     * @uses UpdateSipProfileReq::setMeetmeServiceUrl()
     * @uses UpdateSipProfileReq::setUserInfo()
     * @uses UpdateSipProfileReq::setDtmfDbLevel()
     * @uses UpdateSipProfileReq::setCallHoldRingback()
     * @uses UpdateSipProfileReq::setAnonymousCallBlock()
     * @uses UpdateSipProfileReq::setCallerIdBlock()
     * @uses UpdateSipProfileReq::setDndControl()
     * @uses UpdateSipProfileReq::setTelnetLevel()
     * @uses UpdateSipProfileReq::setTimerKeepAlive()
     * @uses UpdateSipProfileReq::setTimerSubscribe()
     * @uses UpdateSipProfileReq::setTimerSubscribeDelta()
     * @uses UpdateSipProfileReq::setMaxRedirects()
     * @uses UpdateSipProfileReq::setTimerOffHookToFirstDigit()
     * @uses UpdateSipProfileReq::setCallForwardUri()
     * @uses UpdateSipProfileReq::setAbbreviatedDialUri()
     * @uses UpdateSipProfileReq::setConfJointEnable()
     * @uses UpdateSipProfileReq::setRfc2543Hold()
     * @uses UpdateSipProfileReq::setSemiAttendedTransfer()
     * @uses UpdateSipProfileReq::setEnableVad()
     * @uses UpdateSipProfileReq::setStutterMsgWaiting()
     * @uses UpdateSipProfileReq::setCallStats()
     * @uses UpdateSipProfileReq::setT38Invite()
     * @uses UpdateSipProfileReq::setRerouteIncomingRequest()
     * @uses UpdateSipProfileReq::setResourcePriorityNamespaceListName()
     * @uses UpdateSipProfileReq::setEnableAnatForEarlyOfferCalls()
     * @uses UpdateSipProfileReq::setRsvpOverSip()
     * @uses UpdateSipProfileReq::setFallbackToLocalRsvp()
     * @uses UpdateSipProfileReq::setSipRe11XxEnabled()
     * @uses UpdateSipProfileReq::setGClear()
     * @uses UpdateSipProfileReq::setSendRecvSDPInMidCallInvite()
     * @uses UpdateSipProfileReq::setEnableOutboundOptionsPing()
     * @uses UpdateSipProfileReq::setOptionsPingIntervalWhenStatusOK()
     * @uses UpdateSipProfileReq::setOptionsPingIntervalWhenStatusNotOK()
     * @uses UpdateSipProfileReq::setDeliverConferenceBridgeIdentifier()
     * @uses UpdateSipProfileReq::setSipOptionsRetryCount()
     * @uses UpdateSipProfileReq::setSipOptionsRetryTimer()
     * @uses UpdateSipProfileReq::setSipBandwidthModifier()
     * @uses UpdateSipProfileReq::setEnableUriOutdialSupport()
     * @uses UpdateSipProfileReq::setUserAgentServerHeaderInfo()
     * @uses UpdateSipProfileReq::setAllowPresentationSharingUsingBfcp()
     * @uses UpdateSipProfileReq::setScriptParameters()
     * @uses UpdateSipProfileReq::setIsScriptTraceEnabled()
     * @uses UpdateSipProfileReq::setSipNormalizationScript()
     * @uses UpdateSipProfileReq::setAllowiXApplicationMedia()
     * @uses UpdateSipProfileReq::setDialStringInterpretation()
     * @uses UpdateSipProfileReq::setAcceptAudioCodecPreferences()
     * @uses UpdateSipProfileReq::setMlppUserAuthorization()
     * @uses UpdateSipProfileReq::setIsAssuredSipServiceEnabled()
     * @uses UpdateSipProfileReq::setResourcePriorityNamespace()
     * @uses UpdateSipProfileReq::setUseCallerIdCallerNameinUriOutgoingRequest()
     * @uses UpdateSipProfileReq::setCallerIdDn()
     * @uses UpdateSipProfileReq::setCallerName()
     * @uses UpdateSipProfileReq::setCallingLineIdentification()
     * @uses UpdateSipProfileReq::setRejectAnonymousIncomingCall()
     * @uses UpdateSipProfileReq::setCallpickupUri()
     * @uses UpdateSipProfileReq::setRejectAnonymousOutgoingCall()
     * @uses UpdateSipProfileReq::setVideoCallTrafficClass()
     * @uses UpdateSipProfileReq::setSdpTransparency()
     * @uses UpdateSipProfileReq::setAllowMultipleCodecs()
     * @uses UpdateSipProfileReq::setSipSessionRefreshMethod()
     * @uses UpdateSipProfileReq::setEarlyOfferSuppVoiceCall()
     * @uses UpdateSipProfileReq::setCucmVersionInSipHeader()
     * @uses UpdateSipProfileReq::setConfidentialAccessLevelHeaders()
     * @uses UpdateSipProfileReq::setDestRouteString()
     * @uses UpdateSipProfileReq::setInactiveSDPRequired()
     * @param string $newName
     * @param string $description
     * @param string $defaultTelephonyEventPayloadType
     * @param string $redirectByApplication
     * @param string $ringing180
     * @param string $timerInvite
     * @param string $timerRegisterDelta
     * @param string $timerRegister
     * @param string $timerT1
     * @param string $timerT2
     * @param string $retryInvite
     * @param string $retryNotInvite
     * @param string $startMediaPort
     * @param string $stopMediaPort
     * @param string $startVideoPort
     * @param string $stopVideoPort
     * @param string $dscpForAudioCalls
     * @param string $dscpForVideoCalls
     * @param string $dscpForAudioPortionOfVideoCalls
     * @param string $dscpForTelePresenceCalls
     * @param string $dscpForAudioPortionOfTelePresenceCalls
     * @param string $callpickupListUri
     * @param string $callpickupGroupUri
     * @param string $meetmeServiceUrl
     * @param string $userInfo
     * @param string $dtmfDbLevel
     * @param string $callHoldRingback
     * @param string $anonymousCallBlock
     * @param string $callerIdBlock
     * @param string $dndControl
     * @param string $telnetLevel
     * @param string $timerKeepAlive
     * @param string $timerSubscribe
     * @param string $timerSubscribeDelta
     * @param string $maxRedirects
     * @param string $timerOffHookToFirstDigit
     * @param string $callForwardUri
     * @param string $abbreviatedDialUri
     * @param string $confJointEnable
     * @param string $rfc2543Hold
     * @param string $semiAttendedTransfer
     * @param string $enableVad
     * @param string $stutterMsgWaiting
     * @param string $callStats
     * @param string $t38Invite
     * @param string $rerouteIncomingRequest
     * @param \StructType\XFkType $resourcePriorityNamespaceListName
     * @param string $enableAnatForEarlyOfferCalls
     * @param string $rsvpOverSip
     * @param string $fallbackToLocalRsvp
     * @param string $sipRe11XxEnabled
     * @param string $gClear
     * @param string $sendRecvSDPInMidCallInvite
     * @param string $enableOutboundOptionsPing
     * @param string $optionsPingIntervalWhenStatusOK
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @param string $deliverConferenceBridgeIdentifier
     * @param string $sipOptionsRetryCount
     * @param string $sipOptionsRetryTimer
     * @param string $sipBandwidthModifier
     * @param string $enableUriOutdialSupport
     * @param string $userAgentServerHeaderInfo
     * @param string $allowPresentationSharingUsingBfcp
     * @param string $scriptParameters
     * @param string $isScriptTraceEnabled
     * @param \StructType\XFkType $sipNormalizationScript
     * @param string $allowiXApplicationMedia
     * @param string $dialStringInterpretation
     * @param string $acceptAudioCodecPreferences
     * @param string $mlppUserAuthorization
     * @param string $isAssuredSipServiceEnabled
     * @param \StructType\XFkType $resourcePriorityNamespace
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @param string $callerIdDn
     * @param string $callerName
     * @param string $callingLineIdentification
     * @param string $rejectAnonymousIncomingCall
     * @param string $callpickupUri
     * @param string $rejectAnonymousOutgoingCall
     * @param string $videoCallTrafficClass
     * @param \StructType\XFkType $sdpTransparency
     * @param string $allowMultipleCodecs
     * @param string $sipSessionRefreshMethod
     * @param string $earlyOfferSuppVoiceCall
     * @param string $cucmVersionInSipHeader
     * @param string $confidentialAccessLevelHeaders
     * @param string $destRouteString
     * @param string $inactiveSDPRequired
     */
    public function __construct($newName = null, $description = null, $defaultTelephonyEventPayloadType = '101', $redirectByApplication = false, $ringing180 = false, $timerInvite = '180', $timerRegisterDelta = '5', $timerRegister = '3600', $timerT1 = '500', $timerT2 = '4000', $retryInvite = '6', $retryNotInvite = '10', $startMediaPort = '16384', $stopMediaPort = '32766', $startVideoPort = '0', $stopVideoPort = '0', $dscpForAudioCalls = null, $dscpForVideoCalls = null, $dscpForAudioPortionOfVideoCalls = null, $dscpForTelePresenceCalls = null, $dscpForAudioPortionOfTelePresenceCalls = null, $callpickupListUri = 'x-cisco-serviceuri-opickup', $callpickupGroupUri = 'x-cisco-serviceuri-gpickup', $meetmeServiceUrl = 'x-cisco-serviceuri-meetme', $userInfo = 'None', $dtmfDbLevel = 'Nominal', $callHoldRingback = 'Off', $anonymousCallBlock = 'Off', $callerIdBlock = 'Off', $dndControl = 'User', $telnetLevel = 'Disabled', $timerKeepAlive = '120', $timerSubscribe = '120', $timerSubscribeDelta = '5', $maxRedirects = '70', $timerOffHookToFirstDigit = '15000', $callForwardUri = 'x-cisco-serviceuri-cfwdall', $abbreviatedDialUri = 'x-cisco-serviceuri-abbrdial', $confJointEnable = true, $rfc2543Hold = false, $semiAttendedTransfer = true, $enableVad = false, $stutterMsgWaiting = false, $callStats = false, $t38Invite = false, $rerouteIncomingRequest = 'Never', \StructType\XFkType $resourcePriorityNamespaceListName = null, $enableAnatForEarlyOfferCalls = false, $rsvpOverSip = 'Local RSVP', $fallbackToLocalRsvp = true, $sipRe11XxEnabled = 'Disabled', $gClear = 'Disabled', $sendRecvSDPInMidCallInvite = false, $enableOutboundOptionsPing = false, $optionsPingIntervalWhenStatusOK = '60', $optionsPingIntervalWhenStatusNotOK = '120', $deliverConferenceBridgeIdentifier = null, $sipOptionsRetryCount = '6', $sipOptionsRetryTimer = '500', $sipBandwidthModifier = 'TIAS and AS', $enableUriOutdialSupport = null, $userAgentServerHeaderInfo = 'Send Unified CM Version Information as User-Agent Header', $allowPresentationSharingUsingBfcp = null, $scriptParameters = null, $isScriptTraceEnabled = false, \StructType\XFkType $sipNormalizationScript = null, $allowiXApplicationMedia = null, $dialStringInterpretation = Phone number consists of characters 0-9, *, #, and + (others treated as URI addresses), $acceptAudioCodecPreferences = 'Default', $mlppUserAuthorization = false, $isAssuredSipServiceEnabled = false, \StructType\XFkType $resourcePriorityNamespace = null, $useCallerIdCallerNameinUriOutgoingRequest = null, $callerIdDn = null, $callerName = null, $callingLineIdentification = 'Default', $rejectAnonymousIncomingCall = null, $callpickupUri = 'x-cisco-serviceuri-pickup', $rejectAnonymousOutgoingCall = null, $videoCallTrafficClass = 'Mixed', \StructType\XFkType $sdpTransparency = null, $allowMultipleCodecs = false, $sipSessionRefreshMethod = 'Invite', $earlyOfferSuppVoiceCall = Disabled (Default value), $cucmVersionInSipHeader = 'Major And Minor', $confidentialAccessLevelHeaders = 'Disabled', $destRouteString = null, $inactiveSDPRequired = false)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType)
            ->setRedirectByApplication($redirectByApplication)
            ->setRinging180($ringing180)
            ->setTimerInvite($timerInvite)
            ->setTimerRegisterDelta($timerRegisterDelta)
            ->setTimerRegister($timerRegister)
            ->setTimerT1($timerT1)
            ->setTimerT2($timerT2)
            ->setRetryInvite($retryInvite)
            ->setRetryNotInvite($retryNotInvite)
            ->setStartMediaPort($startMediaPort)
            ->setStopMediaPort($stopMediaPort)
            ->setStartVideoPort($startVideoPort)
            ->setStopVideoPort($stopVideoPort)
            ->setDscpForAudioCalls($dscpForAudioCalls)
            ->setDscpForVideoCalls($dscpForVideoCalls)
            ->setDscpForAudioPortionOfVideoCalls($dscpForAudioPortionOfVideoCalls)
            ->setDscpForTelePresenceCalls($dscpForTelePresenceCalls)
            ->setDscpForAudioPortionOfTelePresenceCalls($dscpForAudioPortionOfTelePresenceCalls)
            ->setCallpickupListUri($callpickupListUri)
            ->setCallpickupGroupUri($callpickupGroupUri)
            ->setMeetmeServiceUrl($meetmeServiceUrl)
            ->setUserInfo($userInfo)
            ->setDtmfDbLevel($dtmfDbLevel)
            ->setCallHoldRingback($callHoldRingback)
            ->setAnonymousCallBlock($anonymousCallBlock)
            ->setCallerIdBlock($callerIdBlock)
            ->setDndControl($dndControl)
            ->setTelnetLevel($telnetLevel)
            ->setTimerKeepAlive($timerKeepAlive)
            ->setTimerSubscribe($timerSubscribe)
            ->setTimerSubscribeDelta($timerSubscribeDelta)
            ->setMaxRedirects($maxRedirects)
            ->setTimerOffHookToFirstDigit($timerOffHookToFirstDigit)
            ->setCallForwardUri($callForwardUri)
            ->setAbbreviatedDialUri($abbreviatedDialUri)
            ->setConfJointEnable($confJointEnable)
            ->setRfc2543Hold($rfc2543Hold)
            ->setSemiAttendedTransfer($semiAttendedTransfer)
            ->setEnableVad($enableVad)
            ->setStutterMsgWaiting($stutterMsgWaiting)
            ->setCallStats($callStats)
            ->setT38Invite($t38Invite)
            ->setRerouteIncomingRequest($rerouteIncomingRequest)
            ->setResourcePriorityNamespaceListName($resourcePriorityNamespaceListName)
            ->setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls)
            ->setRsvpOverSip($rsvpOverSip)
            ->setFallbackToLocalRsvp($fallbackToLocalRsvp)
            ->setSipRe11XxEnabled($sipRe11XxEnabled)
            ->setGClear($gClear)
            ->setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite)
            ->setEnableOutboundOptionsPing($enableOutboundOptionsPing)
            ->setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK)
            ->setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK)
            ->setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier)
            ->setSipOptionsRetryCount($sipOptionsRetryCount)
            ->setSipOptionsRetryTimer($sipOptionsRetryTimer)
            ->setSipBandwidthModifier($sipBandwidthModifier)
            ->setEnableUriOutdialSupport($enableUriOutdialSupport)
            ->setUserAgentServerHeaderInfo($userAgentServerHeaderInfo)
            ->setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp)
            ->setScriptParameters($scriptParameters)
            ->setIsScriptTraceEnabled($isScriptTraceEnabled)
            ->setSipNormalizationScript($sipNormalizationScript)
            ->setAllowiXApplicationMedia($allowiXApplicationMedia)
            ->setDialStringInterpretation($dialStringInterpretation)
            ->setAcceptAudioCodecPreferences($acceptAudioCodecPreferences)
            ->setMlppUserAuthorization($mlppUserAuthorization)
            ->setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled)
            ->setResourcePriorityNamespace($resourcePriorityNamespace)
            ->setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest)
            ->setCallerIdDn($callerIdDn)
            ->setCallerName($callerName)
            ->setCallingLineIdentification($callingLineIdentification)
            ->setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall)
            ->setCallpickupUri($callpickupUri)
            ->setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall)
            ->setVideoCallTrafficClass($videoCallTrafficClass)
            ->setSdpTransparency($sdpTransparency)
            ->setAllowMultipleCodecs($allowMultipleCodecs)
            ->setSipSessionRefreshMethod($sipSessionRefreshMethod)
            ->setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall)
            ->setCucmVersionInSipHeader($cucmVersionInSipHeader)
            ->setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders)
            ->setDestRouteString($destRouteString)
            ->setInactiveSDPRequired($inactiveSDPRequired);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateSipProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get defaultTelephonyEventPayloadType value
     * @return string|null
     */
    public function getDefaultTelephonyEventPayloadType()
    {
        return $this->defaultTelephonyEventPayloadType;
    }
    /**
     * Set defaultTelephonyEventPayloadType value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultTelephonyEventPayloadType
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDefaultTelephonyEventPayloadType($defaultTelephonyEventPayloadType = '101')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($defaultTelephonyEventPayloadType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $defaultTelephonyEventPayloadType, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->defaultTelephonyEventPayloadType = $defaultTelephonyEventPayloadType;
        return $this;
    }
    /**
     * Get redirectByApplication value
     * @return string|null
     */
    public function getRedirectByApplication()
    {
        return $this->redirectByApplication;
    }
    /**
     * Set redirectByApplication value
     * @param string $redirectByApplication
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRedirectByApplication($redirectByApplication = false)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectByApplication) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectByApplication, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectByApplication) && !is_string($redirectByApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectByApplication)), __LINE__);
        }
        $this->redirectByApplication = $redirectByApplication;
        return $this;
    }
    /**
     * Get ringing180 value
     * @return string|null
     */
    public function getRinging180()
    {
        return $this->ringing180;
    }
    /**
     * Set ringing180 value
     * @param string $ringing180
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRinging180($ringing180 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($ringing180) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ringing180, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ringing180) && !is_string($ringing180)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ringing180)), __LINE__);
        }
        $this->ringing180 = $ringing180;
        return $this;
    }
    /**
     * Get timerInvite value
     * @return string|null
     */
    public function getTimerInvite()
    {
        return $this->timerInvite;
    }
    /**
     * Set timerInvite value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerInvite
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerInvite($timerInvite = '180')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerInvite, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerInvite = $timerInvite;
        return $this;
    }
    /**
     * Get timerRegisterDelta value
     * @return string|null
     */
    public function getTimerRegisterDelta()
    {
        return $this->timerRegisterDelta;
    }
    /**
     * Set timerRegisterDelta value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegisterDelta
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerRegisterDelta($timerRegisterDelta = '5')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerRegisterDelta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerRegisterDelta, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegisterDelta = $timerRegisterDelta;
        return $this;
    }
    /**
     * Get timerRegister value
     * @return string|null
     */
    public function getTimerRegister()
    {
        return $this->timerRegister;
    }
    /**
     * Set timerRegister value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerRegister
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerRegister($timerRegister = '3600')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerRegister)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerRegister, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerRegister = $timerRegister;
        return $this;
    }
    /**
     * Get timerT1 value
     * @return string|null
     */
    public function getTimerT1()
    {
        return $this->timerT1;
    }
    /**
     * Set timerT1 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT1
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerT1($timerT1 = '500')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerT1)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerT1, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerT1 = $timerT1;
        return $this;
    }
    /**
     * Get timerT2 value
     * @return string|null
     */
    public function getTimerT2()
    {
        return $this->timerT2;
    }
    /**
     * Set timerT2 value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerT2
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerT2($timerT2 = '4000')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerT2)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerT2, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerT2 = $timerT2;
        return $this;
    }
    /**
     * Get retryInvite value
     * @return string|null
     */
    public function getRetryInvite()
    {
        return $this->retryInvite;
    }
    /**
     * Set retryInvite value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryInvite
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRetryInvite($retryInvite = '6')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($retryInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryInvite, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryInvite = $retryInvite;
        return $this;
    }
    /**
     * Get retryNotInvite value
     * @return string|null
     */
    public function getRetryNotInvite()
    {
        return $this->retryNotInvite;
    }
    /**
     * Set retryNotInvite value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $retryNotInvite
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRetryNotInvite($retryNotInvite = '10')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($retryNotInvite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $retryNotInvite, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->retryNotInvite = $retryNotInvite;
        return $this;
    }
    /**
     * Get startMediaPort value
     * @return string|null
     */
    public function getStartMediaPort()
    {
        return $this->startMediaPort;
    }
    /**
     * Set startMediaPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startMediaPort
     * @return \StructType\UpdateSipProfileReq
     */
    public function setStartMediaPort($startMediaPort = '16384')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($startMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startMediaPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->startMediaPort = $startMediaPort;
        return $this;
    }
    /**
     * Get stopMediaPort value
     * @return string|null
     */
    public function getStopMediaPort()
    {
        return $this->stopMediaPort;
    }
    /**
     * Set stopMediaPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopMediaPort
     * @return \StructType\UpdateSipProfileReq
     */
    public function setStopMediaPort($stopMediaPort = '32766')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($stopMediaPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopMediaPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->stopMediaPort = $stopMediaPort;
        return $this;
    }
    /**
     * Get startVideoPort value
     * @return string|null
     */
    public function getStartVideoPort()
    {
        return $this->startVideoPort;
    }
    /**
     * Set startVideoPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startVideoPort
     * @return \StructType\UpdateSipProfileReq
     */
    public function setStartVideoPort($startVideoPort = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($startVideoPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $startVideoPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->startVideoPort = $startVideoPort;
        return $this;
    }
    /**
     * Get stopVideoPort value
     * @return string|null
     */
    public function getStopVideoPort()
    {
        return $this->stopVideoPort;
    }
    /**
     * Set stopVideoPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopVideoPort
     * @return \StructType\UpdateSipProfileReq
     */
    public function setStopVideoPort($stopVideoPort = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($stopVideoPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopVideoPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->stopVideoPort = $stopVideoPort;
        return $this;
    }
    /**
     * Get dscpForAudioCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDscpForAudioCalls()
    {
        return isset($this->dscpForAudioCalls) ? $this->dscpForAudioCalls : null;
    }
    /**
     * Set dscpForAudioCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dscpForAudioCalls
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDscpForAudioCalls($dscpForAudioCalls = null)
    {
        // validation for constraint: string
        if (!is_null($dscpForAudioCalls) && !is_string($dscpForAudioCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dscpForAudioCalls)), __LINE__);
        }
        if (is_null($dscpForAudioCalls) || (is_array($dscpForAudioCalls) && empty($dscpForAudioCalls))) {
            unset($this->dscpForAudioCalls);
        } else {
            $this->dscpForAudioCalls = $dscpForAudioCalls;
        }
        return $this;
    }
    /**
     * Get dscpForVideoCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDscpForVideoCalls()
    {
        return isset($this->dscpForVideoCalls) ? $this->dscpForVideoCalls : null;
    }
    /**
     * Set dscpForVideoCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dscpForVideoCalls
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDscpForVideoCalls($dscpForVideoCalls = null)
    {
        // validation for constraint: string
        if (!is_null($dscpForVideoCalls) && !is_string($dscpForVideoCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dscpForVideoCalls)), __LINE__);
        }
        if (is_null($dscpForVideoCalls) || (is_array($dscpForVideoCalls) && empty($dscpForVideoCalls))) {
            unset($this->dscpForVideoCalls);
        } else {
            $this->dscpForVideoCalls = $dscpForVideoCalls;
        }
        return $this;
    }
    /**
     * Get dscpForAudioPortionOfVideoCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDscpForAudioPortionOfVideoCalls()
    {
        return isset($this->dscpForAudioPortionOfVideoCalls) ? $this->dscpForAudioPortionOfVideoCalls : null;
    }
    /**
     * Set dscpForAudioPortionOfVideoCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dscpForAudioPortionOfVideoCalls
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDscpForAudioPortionOfVideoCalls($dscpForAudioPortionOfVideoCalls = null)
    {
        // validation for constraint: string
        if (!is_null($dscpForAudioPortionOfVideoCalls) && !is_string($dscpForAudioPortionOfVideoCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dscpForAudioPortionOfVideoCalls)), __LINE__);
        }
        if (is_null($dscpForAudioPortionOfVideoCalls) || (is_array($dscpForAudioPortionOfVideoCalls) && empty($dscpForAudioPortionOfVideoCalls))) {
            unset($this->dscpForAudioPortionOfVideoCalls);
        } else {
            $this->dscpForAudioPortionOfVideoCalls = $dscpForAudioPortionOfVideoCalls;
        }
        return $this;
    }
    /**
     * Get dscpForTelePresenceCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDscpForTelePresenceCalls()
    {
        return isset($this->dscpForTelePresenceCalls) ? $this->dscpForTelePresenceCalls : null;
    }
    /**
     * Set dscpForTelePresenceCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dscpForTelePresenceCalls
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDscpForTelePresenceCalls($dscpForTelePresenceCalls = null)
    {
        // validation for constraint: string
        if (!is_null($dscpForTelePresenceCalls) && !is_string($dscpForTelePresenceCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dscpForTelePresenceCalls)), __LINE__);
        }
        if (is_null($dscpForTelePresenceCalls) || (is_array($dscpForTelePresenceCalls) && empty($dscpForTelePresenceCalls))) {
            unset($this->dscpForTelePresenceCalls);
        } else {
            $this->dscpForTelePresenceCalls = $dscpForTelePresenceCalls;
        }
        return $this;
    }
    /**
     * Get dscpForAudioPortionOfTelePresenceCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDscpForAudioPortionOfTelePresenceCalls()
    {
        return isset($this->dscpForAudioPortionOfTelePresenceCalls) ? $this->dscpForAudioPortionOfTelePresenceCalls : null;
    }
    /**
     * Set dscpForAudioPortionOfTelePresenceCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dscpForAudioPortionOfTelePresenceCalls
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDscpForAudioPortionOfTelePresenceCalls($dscpForAudioPortionOfTelePresenceCalls = null)
    {
        // validation for constraint: string
        if (!is_null($dscpForAudioPortionOfTelePresenceCalls) && !is_string($dscpForAudioPortionOfTelePresenceCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dscpForAudioPortionOfTelePresenceCalls)), __LINE__);
        }
        if (is_null($dscpForAudioPortionOfTelePresenceCalls) || (is_array($dscpForAudioPortionOfTelePresenceCalls) && empty($dscpForAudioPortionOfTelePresenceCalls))) {
            unset($this->dscpForAudioPortionOfTelePresenceCalls);
        } else {
            $this->dscpForAudioPortionOfTelePresenceCalls = $dscpForAudioPortionOfTelePresenceCalls;
        }
        return $this;
    }
    /**
     * Get callpickupListUri value
     * @return string|null
     */
    public function getCallpickupListUri()
    {
        return $this->callpickupListUri;
    }
    /**
     * Set callpickupListUri value
     * @param string $callpickupListUri
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallpickupListUri($callpickupListUri = 'x-cisco-serviceuri-opickup')
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupListUri) && strlen($callpickupListUri) > 128) || (is_array($callpickupListUri) && count($callpickupListUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupListUri) ? strlen($callpickupListUri) : count($callpickupListUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupListUri) && !is_string($callpickupListUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupListUri)), __LINE__);
        }
        $this->callpickupListUri = $callpickupListUri;
        return $this;
    }
    /**
     * Get callpickupGroupUri value
     * @return string|null
     */
    public function getCallpickupGroupUri()
    {
        return $this->callpickupGroupUri;
    }
    /**
     * Set callpickupGroupUri value
     * @param string $callpickupGroupUri
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallpickupGroupUri($callpickupGroupUri = 'x-cisco-serviceuri-gpickup')
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupGroupUri) && strlen($callpickupGroupUri) > 128) || (is_array($callpickupGroupUri) && count($callpickupGroupUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupGroupUri) ? strlen($callpickupGroupUri) : count($callpickupGroupUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupGroupUri) && !is_string($callpickupGroupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupGroupUri)), __LINE__);
        }
        $this->callpickupGroupUri = $callpickupGroupUri;
        return $this;
    }
    /**
     * Get meetmeServiceUrl value
     * @return string|null
     */
    public function getMeetmeServiceUrl()
    {
        return $this->meetmeServiceUrl;
    }
    /**
     * Set meetmeServiceUrl value
     * @param string $meetmeServiceUrl
     * @return \StructType\UpdateSipProfileReq
     */
    public function setMeetmeServiceUrl($meetmeServiceUrl = 'x-cisco-serviceuri-meetme')
    {
        // validation for constraint: maxLength
        if ((is_scalar($meetmeServiceUrl) && strlen($meetmeServiceUrl) > 128) || (is_array($meetmeServiceUrl) && count($meetmeServiceUrl) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($meetmeServiceUrl) ? strlen($meetmeServiceUrl) : count($meetmeServiceUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($meetmeServiceUrl) && !is_string($meetmeServiceUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meetmeServiceUrl)), __LINE__);
        }
        $this->meetmeServiceUrl = $meetmeServiceUrl;
        return $this;
    }
    /**
     * Get userInfo value
     * @return string|null
     */
    public function getUserInfo()
    {
        return $this->userInfo;
    }
    /**
     * Set userInfo value
     * @uses \EnumType\XZzuserInfo::valueIsValid()
     * @uses \EnumType\XZzuserInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userInfo
     * @return \StructType\UpdateSipProfileReq
     */
    public function setUserInfo($userInfo = 'None')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzuserInfo::valueIsValid($userInfo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userInfo, implode(', ', \EnumType\XZzuserInfo::getValidValues())), __LINE__);
        }
        $this->userInfo = $userInfo;
        return $this;
    }
    /**
     * Get dtmfDbLevel value
     * @return string|null
     */
    public function getDtmfDbLevel()
    {
        return $this->dtmfDbLevel;
    }
    /**
     * Set dtmfDbLevel value
     * @uses \EnumType\XZzdtmfDbLevel::valueIsValid()
     * @uses \EnumType\XZzdtmfDbLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfDbLevel
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDtmfDbLevel($dtmfDbLevel = 'Nominal')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzdtmfDbLevel::valueIsValid($dtmfDbLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfDbLevel, implode(', ', \EnumType\XZzdtmfDbLevel::getValidValues())), __LINE__);
        }
        $this->dtmfDbLevel = $dtmfDbLevel;
        return $this;
    }
    /**
     * Get callHoldRingback value
     * @return string|null
     */
    public function getCallHoldRingback()
    {
        return $this->callHoldRingback;
    }
    /**
     * Set callHoldRingback value
     * @uses \EnumType\XZzpreff::valueIsValid()
     * @uses \EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callHoldRingback
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallHoldRingback($callHoldRingback = 'Off')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzpreff::valueIsValid($callHoldRingback)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callHoldRingback, implode(', ', \EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->callHoldRingback = $callHoldRingback;
        return $this;
    }
    /**
     * Get anonymousCallBlock value
     * @return string|null
     */
    public function getAnonymousCallBlock()
    {
        return $this->anonymousCallBlock;
    }
    /**
     * Set anonymousCallBlock value
     * @uses \EnumType\XZzpreff::valueIsValid()
     * @uses \EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $anonymousCallBlock
     * @return \StructType\UpdateSipProfileReq
     */
    public function setAnonymousCallBlock($anonymousCallBlock = 'Off')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzpreff::valueIsValid($anonymousCallBlock)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $anonymousCallBlock, implode(', ', \EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->anonymousCallBlock = $anonymousCallBlock;
        return $this;
    }
    /**
     * Get callerIdBlock value
     * @return string|null
     */
    public function getCallerIdBlock()
    {
        return $this->callerIdBlock;
    }
    /**
     * Set callerIdBlock value
     * @uses \EnumType\XZzpreff::valueIsValid()
     * @uses \EnumType\XZzpreff::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callerIdBlock
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallerIdBlock($callerIdBlock = 'Off')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzpreff::valueIsValid($callerIdBlock)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callerIdBlock, implode(', ', \EnumType\XZzpreff::getValidValues())), __LINE__);
        }
        $this->callerIdBlock = $callerIdBlock;
        return $this;
    }
    /**
     * Get dndControl value
     * @return string|null
     */
    public function getDndControl()
    {
        return $this->dndControl;
    }
    /**
     * Set dndControl value
     * @uses \EnumType\XZzdndcontrol::valueIsValid()
     * @uses \EnumType\XZzdndcontrol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndControl
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDndControl($dndControl = 'User')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XZzdndcontrol::valueIsValid($dndControl)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndControl, implode(', ', \EnumType\XZzdndcontrol::getValidValues())), __LINE__);
        }
        $this->dndControl = $dndControl;
        return $this;
    }
    /**
     * Get telnetLevel value
     * @return string|null
     */
    public function getTelnetLevel()
    {
        return $this->telnetLevel;
    }
    /**
     * Set telnetLevel value
     * @uses \EnumType\XTelnetLevel::valueIsValid()
     * @uses \EnumType\XTelnetLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $telnetLevel
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTelnetLevel($telnetLevel = 'Disabled')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTelnetLevel::valueIsValid($telnetLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $telnetLevel, implode(', ', \EnumType\XTelnetLevel::getValidValues())), __LINE__);
        }
        $this->telnetLevel = $telnetLevel;
        return $this;
    }
    /**
     * Get timerKeepAlive value
     * @return string|null
     */
    public function getTimerKeepAlive()
    {
        return $this->timerKeepAlive;
    }
    /**
     * Set timerKeepAlive value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerKeepAlive
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerKeepAlive($timerKeepAlive = '120')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerKeepAlive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerKeepAlive, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerKeepAlive = $timerKeepAlive;
        return $this;
    }
    /**
     * Get timerSubscribe value
     * @return string|null
     */
    public function getTimerSubscribe()
    {
        return $this->timerSubscribe;
    }
    /**
     * Set timerSubscribe value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribe
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerSubscribe($timerSubscribe = '120')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerSubscribe)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerSubscribe, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribe = $timerSubscribe;
        return $this;
    }
    /**
     * Get timerSubscribeDelta value
     * @return string|null
     */
    public function getTimerSubscribeDelta()
    {
        return $this->timerSubscribeDelta;
    }
    /**
     * Set timerSubscribeDelta value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerSubscribeDelta
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerSubscribeDelta($timerSubscribeDelta = '5')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerSubscribeDelta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerSubscribeDelta, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerSubscribeDelta = $timerSubscribeDelta;
        return $this;
    }
    /**
     * Get maxRedirects value
     * @return string|null
     */
    public function getMaxRedirects()
    {
        return $this->maxRedirects;
    }
    /**
     * Set maxRedirects value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxRedirects
     * @return \StructType\UpdateSipProfileReq
     */
    public function setMaxRedirects($maxRedirects = '70')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($maxRedirects)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxRedirects, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxRedirects = $maxRedirects;
        return $this;
    }
    /**
     * Get timerOffHookToFirstDigit value
     * @return string|null
     */
    public function getTimerOffHookToFirstDigit()
    {
        return $this->timerOffHookToFirstDigit;
    }
    /**
     * Set timerOffHookToFirstDigit value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timerOffHookToFirstDigit
     * @return \StructType\UpdateSipProfileReq
     */
    public function setTimerOffHookToFirstDigit($timerOffHookToFirstDigit = '15000')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($timerOffHookToFirstDigit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timerOffHookToFirstDigit, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->timerOffHookToFirstDigit = $timerOffHookToFirstDigit;
        return $this;
    }
    /**
     * Get callForwardUri value
     * @return string|null
     */
    public function getCallForwardUri()
    {
        return $this->callForwardUri;
    }
    /**
     * Set callForwardUri value
     * @param string $callForwardUri
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallForwardUri($callForwardUri = 'x-cisco-serviceuri-cfwdall')
    {
        // validation for constraint: maxLength
        if ((is_scalar($callForwardUri) && strlen($callForwardUri) > 128) || (is_array($callForwardUri) && count($callForwardUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callForwardUri) ? strlen($callForwardUri) : count($callForwardUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callForwardUri) && !is_string($callForwardUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callForwardUri)), __LINE__);
        }
        $this->callForwardUri = $callForwardUri;
        return $this;
    }
    /**
     * Get abbreviatedDialUri value
     * @return string|null
     */
    public function getAbbreviatedDialUri()
    {
        return $this->abbreviatedDialUri;
    }
    /**
     * Set abbreviatedDialUri value
     * @param string $abbreviatedDialUri
     * @return \StructType\UpdateSipProfileReq
     */
    public function setAbbreviatedDialUri($abbreviatedDialUri = 'x-cisco-serviceuri-abbrdial')
    {
        // validation for constraint: maxLength
        if ((is_scalar($abbreviatedDialUri) && strlen($abbreviatedDialUri) > 128) || (is_array($abbreviatedDialUri) && count($abbreviatedDialUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($abbreviatedDialUri) ? strlen($abbreviatedDialUri) : count($abbreviatedDialUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abbreviatedDialUri) && !is_string($abbreviatedDialUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviatedDialUri)), __LINE__);
        }
        $this->abbreviatedDialUri = $abbreviatedDialUri;
        return $this;
    }
    /**
     * Get confJointEnable value
     * @return string|null
     */
    public function getConfJointEnable()
    {
        return $this->confJointEnable;
    }
    /**
     * Set confJointEnable value
     * @param string $confJointEnable
     * @return \StructType\UpdateSipProfileReq
     */
    public function setConfJointEnable($confJointEnable = true)
    {
        // validation for constraint: pattern
        if (is_scalar($confJointEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($confJointEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($confJointEnable) && !is_string($confJointEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($confJointEnable)), __LINE__);
        }
        $this->confJointEnable = $confJointEnable;
        return $this;
    }
    /**
     * Get rfc2543Hold value
     * @return string|null
     */
    public function getRfc2543Hold()
    {
        return $this->rfc2543Hold;
    }
    /**
     * Set rfc2543Hold value
     * @param string $rfc2543Hold
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRfc2543Hold($rfc2543Hold = false)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2543Hold) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2543Hold, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2543Hold) && !is_string($rfc2543Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2543Hold)), __LINE__);
        }
        $this->rfc2543Hold = $rfc2543Hold;
        return $this;
    }
    /**
     * Get semiAttendedTransfer value
     * @return string|null
     */
    public function getSemiAttendedTransfer()
    {
        return $this->semiAttendedTransfer;
    }
    /**
     * Set semiAttendedTransfer value
     * @param string $semiAttendedTransfer
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSemiAttendedTransfer($semiAttendedTransfer = true)
    {
        // validation for constraint: pattern
        if (is_scalar($semiAttendedTransfer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($semiAttendedTransfer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($semiAttendedTransfer) && !is_string($semiAttendedTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($semiAttendedTransfer)), __LINE__);
        }
        $this->semiAttendedTransfer = $semiAttendedTransfer;
        return $this;
    }
    /**
     * Get enableVad value
     * @return string|null
     */
    public function getEnableVad()
    {
        return $this->enableVad;
    }
    /**
     * Set enableVad value
     * @param string $enableVad
     * @return \StructType\UpdateSipProfileReq
     */
    public function setEnableVad($enableVad = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableVad) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableVad, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableVad) && !is_string($enableVad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableVad)), __LINE__);
        }
        $this->enableVad = $enableVad;
        return $this;
    }
    /**
     * Get stutterMsgWaiting value
     * @return string|null
     */
    public function getStutterMsgWaiting()
    {
        return $this->stutterMsgWaiting;
    }
    /**
     * Set stutterMsgWaiting value
     * @param string $stutterMsgWaiting
     * @return \StructType\UpdateSipProfileReq
     */
    public function setStutterMsgWaiting($stutterMsgWaiting = false)
    {
        // validation for constraint: pattern
        if (is_scalar($stutterMsgWaiting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($stutterMsgWaiting, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stutterMsgWaiting) && !is_string($stutterMsgWaiting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stutterMsgWaiting)), __LINE__);
        }
        $this->stutterMsgWaiting = $stutterMsgWaiting;
        return $this;
    }
    /**
     * Get callStats value
     * @return string|null
     */
    public function getCallStats()
    {
        return $this->callStats;
    }
    /**
     * Set callStats value
     * @param string $callStats
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallStats($callStats = false)
    {
        // validation for constraint: pattern
        if (is_scalar($callStats) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($callStats, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callStats) && !is_string($callStats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callStats)), __LINE__);
        }
        $this->callStats = $callStats;
        return $this;
    }
    /**
     * Get t38Invite value
     * @return string|null
     */
    public function getT38Invite()
    {
        return $this->t38Invite;
    }
    /**
     * Set t38Invite value
     * @param string $t38Invite
     * @return \StructType\UpdateSipProfileReq
     */
    public function setT38Invite($t38Invite = false)
    {
        // validation for constraint: pattern
        if (is_scalar($t38Invite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($t38Invite, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($t38Invite) && !is_string($t38Invite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($t38Invite)), __LINE__);
        }
        $this->t38Invite = $t38Invite;
        return $this;
    }
    /**
     * Get rerouteIncomingRequest value
     * @return string|null
     */
    public function getRerouteIncomingRequest()
    {
        return $this->rerouteIncomingRequest;
    }
    /**
     * Set rerouteIncomingRequest value
     * @uses \EnumType\XSIPReroute::valueIsValid()
     * @uses \EnumType\XSIPReroute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rerouteIncomingRequest
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRerouteIncomingRequest($rerouteIncomingRequest = 'Never')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPReroute::valueIsValid($rerouteIncomingRequest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rerouteIncomingRequest, implode(', ', \EnumType\XSIPReroute::getValidValues())), __LINE__);
        }
        $this->rerouteIncomingRequest = $rerouteIncomingRequest;
        return $this;
    }
    /**
     * Get resourcePriorityNamespaceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getResourcePriorityNamespaceListName()
    {
        return isset($this->resourcePriorityNamespaceListName) ? $this->resourcePriorityNamespaceListName : null;
    }
    /**
     * Set resourcePriorityNamespaceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $resourcePriorityNamespaceListName
     * @return \StructType\UpdateSipProfileReq
     */
    public function setResourcePriorityNamespaceListName(\StructType\XFkType $resourcePriorityNamespaceListName = null)
    {
        if (is_null($resourcePriorityNamespaceListName) || (is_array($resourcePriorityNamespaceListName) && empty($resourcePriorityNamespaceListName))) {
            unset($this->resourcePriorityNamespaceListName);
        } else {
            $this->resourcePriorityNamespaceListName = $resourcePriorityNamespaceListName;
        }
        return $this;
    }
    /**
     * Get enableAnatForEarlyOfferCalls value
     * @return string|null
     */
    public function getEnableAnatForEarlyOfferCalls()
    {
        return $this->enableAnatForEarlyOfferCalls;
    }
    /**
     * Set enableAnatForEarlyOfferCalls value
     * @param string $enableAnatForEarlyOfferCalls
     * @return \StructType\UpdateSipProfileReq
     */
    public function setEnableAnatForEarlyOfferCalls($enableAnatForEarlyOfferCalls = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableAnatForEarlyOfferCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableAnatForEarlyOfferCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableAnatForEarlyOfferCalls) && !is_string($enableAnatForEarlyOfferCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableAnatForEarlyOfferCalls)), __LINE__);
        }
        $this->enableAnatForEarlyOfferCalls = $enableAnatForEarlyOfferCalls;
        return $this;
    }
    /**
     * Get rsvpOverSip value
     * @return string|null
     */
    public function getRsvpOverSip()
    {
        return $this->rsvpOverSip;
    }
    /**
     * Set rsvpOverSip value
     * @uses \EnumType\XRSVPOverSIP::valueIsValid()
     * @uses \EnumType\XRSVPOverSIP::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpOverSip
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRsvpOverSip($rsvpOverSip = 'Local RSVP')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XRSVPOverSIP::valueIsValid($rsvpOverSip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rsvpOverSip, implode(', ', \EnumType\XRSVPOverSIP::getValidValues())), __LINE__);
        }
        $this->rsvpOverSip = $rsvpOverSip;
        return $this;
    }
    /**
     * Get fallbackToLocalRsvp value
     * @return string|null
     */
    public function getFallbackToLocalRsvp()
    {
        return $this->fallbackToLocalRsvp;
    }
    /**
     * Set fallbackToLocalRsvp value
     * @param string $fallbackToLocalRsvp
     * @return \StructType\UpdateSipProfileReq
     */
    public function setFallbackToLocalRsvp($fallbackToLocalRsvp = true)
    {
        // validation for constraint: pattern
        if (is_scalar($fallbackToLocalRsvp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($fallbackToLocalRsvp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fallbackToLocalRsvp) && !is_string($fallbackToLocalRsvp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fallbackToLocalRsvp)), __LINE__);
        }
        $this->fallbackToLocalRsvp = $fallbackToLocalRsvp;
        return $this;
    }
    /**
     * Get sipRe11XxEnabled value
     * @return string|null
     */
    public function getSipRe11XxEnabled()
    {
        return $this->sipRe11XxEnabled;
    }
    /**
     * Set sipRe11XxEnabled value
     * @uses \EnumType\XSIPRel1XXOptions::valueIsValid()
     * @uses \EnumType\XSIPRel1XXOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipRe11XxEnabled
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSipRe11XxEnabled($sipRe11XxEnabled = 'Disabled')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPRel1XXOptions::valueIsValid($sipRe11XxEnabled)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipRe11XxEnabled, implode(', ', \EnumType\XSIPRel1XXOptions::getValidValues())), __LINE__);
        }
        $this->sipRe11XxEnabled = $sipRe11XxEnabled;
        return $this;
    }
    /**
     * Get gClear value
     * @return string|null
     */
    public function getGClear()
    {
        return $this->gClear;
    }
    /**
     * Set gClear value
     * @uses \EnumType\XGClear::valueIsValid()
     * @uses \EnumType\XGClear::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gClear
     * @return \StructType\UpdateSipProfileReq
     */
    public function setGClear($gClear = 'Disabled')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGClear::valueIsValid($gClear)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gClear, implode(', ', \EnumType\XGClear::getValidValues())), __LINE__);
        }
        $this->gClear = $gClear;
        return $this;
    }
    /**
     * Get sendRecvSDPInMidCallInvite value
     * @return string|null
     */
    public function getSendRecvSDPInMidCallInvite()
    {
        return $this->sendRecvSDPInMidCallInvite;
    }
    /**
     * Set sendRecvSDPInMidCallInvite value
     * @param string $sendRecvSDPInMidCallInvite
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSendRecvSDPInMidCallInvite($sendRecvSDPInMidCallInvite = false)
    {
        // validation for constraint: pattern
        if (is_scalar($sendRecvSDPInMidCallInvite) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendRecvSDPInMidCallInvite, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendRecvSDPInMidCallInvite) && !is_string($sendRecvSDPInMidCallInvite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendRecvSDPInMidCallInvite)), __LINE__);
        }
        $this->sendRecvSDPInMidCallInvite = $sendRecvSDPInMidCallInvite;
        return $this;
    }
    /**
     * Get enableOutboundOptionsPing value
     * @return string|null
     */
    public function getEnableOutboundOptionsPing()
    {
        return $this->enableOutboundOptionsPing;
    }
    /**
     * Set enableOutboundOptionsPing value
     * @param string $enableOutboundOptionsPing
     * @return \StructType\UpdateSipProfileReq
     */
    public function setEnableOutboundOptionsPing($enableOutboundOptionsPing = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableOutboundOptionsPing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableOutboundOptionsPing, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableOutboundOptionsPing) && !is_string($enableOutboundOptionsPing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableOutboundOptionsPing)), __LINE__);
        }
        $this->enableOutboundOptionsPing = $enableOutboundOptionsPing;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusOK()
    {
        return $this->optionsPingIntervalWhenStatusOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusOK value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusOK
     * @return \StructType\UpdateSipProfileReq
     */
    public function setOptionsPingIntervalWhenStatusOK($optionsPingIntervalWhenStatusOK = '60')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($optionsPingIntervalWhenStatusOK)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optionsPingIntervalWhenStatusOK, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusOK = $optionsPingIntervalWhenStatusOK;
        return $this;
    }
    /**
     * Get optionsPingIntervalWhenStatusNotOK value
     * @return string|null
     */
    public function getOptionsPingIntervalWhenStatusNotOK()
    {
        return $this->optionsPingIntervalWhenStatusNotOK;
    }
    /**
     * Set optionsPingIntervalWhenStatusNotOK value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optionsPingIntervalWhenStatusNotOK
     * @return \StructType\UpdateSipProfileReq
     */
    public function setOptionsPingIntervalWhenStatusNotOK($optionsPingIntervalWhenStatusNotOK = '120')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($optionsPingIntervalWhenStatusNotOK)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optionsPingIntervalWhenStatusNotOK, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->optionsPingIntervalWhenStatusNotOK = $optionsPingIntervalWhenStatusNotOK;
        return $this;
    }
    /**
     * Get deliverConferenceBridgeIdentifier value
     * @return string|null
     */
    public function getDeliverConferenceBridgeIdentifier()
    {
        return $this->deliverConferenceBridgeIdentifier;
    }
    /**
     * Set deliverConferenceBridgeIdentifier value
     * @param string $deliverConferenceBridgeIdentifier
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDeliverConferenceBridgeIdentifier($deliverConferenceBridgeIdentifier = null)
    {
        // validation for constraint: pattern
        if (is_scalar($deliverConferenceBridgeIdentifier) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($deliverConferenceBridgeIdentifier, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deliverConferenceBridgeIdentifier) && !is_string($deliverConferenceBridgeIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliverConferenceBridgeIdentifier)), __LINE__);
        }
        $this->deliverConferenceBridgeIdentifier = $deliverConferenceBridgeIdentifier;
        return $this;
    }
    /**
     * Get sipOptionsRetryCount value
     * @return string|null
     */
    public function getSipOptionsRetryCount()
    {
        return $this->sipOptionsRetryCount;
    }
    /**
     * Set sipOptionsRetryCount value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryCount
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSipOptionsRetryCount($sipOptionsRetryCount = '6')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipOptionsRetryCount)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipOptionsRetryCount, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryCount = $sipOptionsRetryCount;
        return $this;
    }
    /**
     * Get sipOptionsRetryTimer value
     * @return string|null
     */
    public function getSipOptionsRetryTimer()
    {
        return $this->sipOptionsRetryTimer;
    }
    /**
     * Set sipOptionsRetryTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipOptionsRetryTimer
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSipOptionsRetryTimer($sipOptionsRetryTimer = '500')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($sipOptionsRetryTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipOptionsRetryTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sipOptionsRetryTimer = $sipOptionsRetryTimer;
        return $this;
    }
    /**
     * Get sipBandwidthModifier value
     * @return string|null
     */
    public function getSipBandwidthModifier()
    {
        return $this->sipBandwidthModifier;
    }
    /**
     * Set sipBandwidthModifier value
     * @uses \EnumType\XSIPBandwidthModifier::valueIsValid()
     * @uses \EnumType\XSIPBandwidthModifier::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipBandwidthModifier
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSipBandwidthModifier($sipBandwidthModifier = 'TIAS and AS')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPBandwidthModifier::valueIsValid($sipBandwidthModifier)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipBandwidthModifier, implode(', ', \EnumType\XSIPBandwidthModifier::getValidValues())), __LINE__);
        }
        $this->sipBandwidthModifier = $sipBandwidthModifier;
        return $this;
    }
    /**
     * Get enableUriOutdialSupport value
     * @return string|null
     */
    public function getEnableUriOutdialSupport()
    {
        return $this->enableUriOutdialSupport;
    }
    /**
     * Set enableUriOutdialSupport value
     * @param string $enableUriOutdialSupport
     * @return \StructType\UpdateSipProfileReq
     */
    public function setEnableUriOutdialSupport($enableUriOutdialSupport = null)
    {
        // validation for constraint: string
        if (!is_null($enableUriOutdialSupport) && !is_string($enableUriOutdialSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUriOutdialSupport)), __LINE__);
        }
        $this->enableUriOutdialSupport = $enableUriOutdialSupport;
        return $this;
    }
    /**
     * Get userAgentServerHeaderInfo value
     * @return string|null
     */
    public function getUserAgentServerHeaderInfo()
    {
        return $this->userAgentServerHeaderInfo;
    }
    /**
     * Set userAgentServerHeaderInfo value
     * @uses \EnumType\XUserAgentServerHeaderInfo::valueIsValid()
     * @uses \EnumType\XUserAgentServerHeaderInfo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userAgentServerHeaderInfo
     * @return \StructType\UpdateSipProfileReq
     */
    public function setUserAgentServerHeaderInfo($userAgentServerHeaderInfo = 'Send Unified CM Version Information as User-Agent Header')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XUserAgentServerHeaderInfo::valueIsValid($userAgentServerHeaderInfo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userAgentServerHeaderInfo, implode(', ', \EnumType\XUserAgentServerHeaderInfo::getValidValues())), __LINE__);
        }
        $this->userAgentServerHeaderInfo = $userAgentServerHeaderInfo;
        return $this;
    }
    /**
     * Get allowPresentationSharingUsingBfcp value
     * @return string|null
     */
    public function getAllowPresentationSharingUsingBfcp()
    {
        return $this->allowPresentationSharingUsingBfcp;
    }
    /**
     * Set allowPresentationSharingUsingBfcp value
     * @param string $allowPresentationSharingUsingBfcp
     * @return \StructType\UpdateSipProfileReq
     */
    public function setAllowPresentationSharingUsingBfcp($allowPresentationSharingUsingBfcp = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowPresentationSharingUsingBfcp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowPresentationSharingUsingBfcp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowPresentationSharingUsingBfcp) && !is_string($allowPresentationSharingUsingBfcp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowPresentationSharingUsingBfcp)), __LINE__);
        }
        $this->allowPresentationSharingUsingBfcp = $allowPresentationSharingUsingBfcp;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return \StructType\UpdateSipProfileReq
     */
    public function setScriptParameters($scriptParameters = null)
    {
        // validation for constraint: string
        if (!is_null($scriptParameters) && !is_string($scriptParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptParameters)), __LINE__);
        }
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get isScriptTraceEnabled value
     * @return string|null
     */
    public function getIsScriptTraceEnabled()
    {
        return $this->isScriptTraceEnabled;
    }
    /**
     * Set isScriptTraceEnabled value
     * @param string $isScriptTraceEnabled
     * @return \StructType\UpdateSipProfileReq
     */
    public function setIsScriptTraceEnabled($isScriptTraceEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isScriptTraceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isScriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isScriptTraceEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isScriptTraceEnabled) && !is_string($isScriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isScriptTraceEnabled)), __LINE__);
        }
        $this->isScriptTraceEnabled = $isScriptTraceEnabled;
        return $this;
    }
    /**
     * Get sipNormalizationScript value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSipNormalizationScript()
    {
        return isset($this->sipNormalizationScript) ? $this->sipNormalizationScript : null;
    }
    /**
     * Set sipNormalizationScript value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $sipNormalizationScript
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSipNormalizationScript(\StructType\XFkType $sipNormalizationScript = null)
    {
        if (is_null($sipNormalizationScript) || (is_array($sipNormalizationScript) && empty($sipNormalizationScript))) {
            unset($this->sipNormalizationScript);
        } else {
            $this->sipNormalizationScript = $sipNormalizationScript;
        }
        return $this;
    }
    /**
     * Get allowiXApplicationMedia value
     * @return string|null
     */
    public function getAllowiXApplicationMedia()
    {
        return $this->allowiXApplicationMedia;
    }
    /**
     * Set allowiXApplicationMedia value
     * @param string $allowiXApplicationMedia
     * @return \StructType\UpdateSipProfileReq
     */
    public function setAllowiXApplicationMedia($allowiXApplicationMedia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowiXApplicationMedia) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowiXApplicationMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowiXApplicationMedia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowiXApplicationMedia) && !is_string($allowiXApplicationMedia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowiXApplicationMedia)), __LINE__);
        }
        $this->allowiXApplicationMedia = $allowiXApplicationMedia;
        return $this;
    }
    /**
     * Get dialStringInterpretation value
     * @return string|null
     */
    public function getDialStringInterpretation()
    {
        return $this->dialStringInterpretation;
    }
    /**
     * Set dialStringInterpretation value
     * @uses \EnumType\XURIDisambiguationPolicy::valueIsValid()
     * @uses \EnumType\XURIDisambiguationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialStringInterpretation
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDialStringInterpretation($dialStringInterpretation = Phone number consists of characters 0-9, *, #, and + (others treated as URI addresses))
    {
        // validation for constraint: enumeration
        if (!\EnumType\XURIDisambiguationPolicy::valueIsValid($dialStringInterpretation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialStringInterpretation, implode(', ', \EnumType\XURIDisambiguationPolicy::getValidValues())), __LINE__);
        }
        $this->dialStringInterpretation = $dialStringInterpretation;
        return $this;
    }
    /**
     * Get acceptAudioCodecPreferences value
     * @return string|null
     */
    public function getAcceptAudioCodecPreferences()
    {
        return $this->acceptAudioCodecPreferences;
    }
    /**
     * Set acceptAudioCodecPreferences value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $acceptAudioCodecPreferences
     * @return \StructType\UpdateSipProfileReq
     */
    public function setAcceptAudioCodecPreferences($acceptAudioCodecPreferences = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($acceptAudioCodecPreferences)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $acceptAudioCodecPreferences, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->acceptAudioCodecPreferences = $acceptAudioCodecPreferences;
        return $this;
    }
    /**
     * Get mlppUserAuthorization value
     * @return string|null
     */
    public function getMlppUserAuthorization()
    {
        return $this->mlppUserAuthorization;
    }
    /**
     * Set mlppUserAuthorization value
     * @param string $mlppUserAuthorization
     * @return \StructType\UpdateSipProfileReq
     */
    public function setMlppUserAuthorization($mlppUserAuthorization = false)
    {
        // validation for constraint: pattern
        if (is_scalar($mlppUserAuthorization) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mlppUserAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mlppUserAuthorization, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppUserAuthorization) && !is_string($mlppUserAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppUserAuthorization)), __LINE__);
        }
        $this->mlppUserAuthorization = $mlppUserAuthorization;
        return $this;
    }
    /**
     * Get isAssuredSipServiceEnabled value
     * @return string|null
     */
    public function getIsAssuredSipServiceEnabled()
    {
        return $this->isAssuredSipServiceEnabled;
    }
    /**
     * Set isAssuredSipServiceEnabled value
     * @param string $isAssuredSipServiceEnabled
     * @return \StructType\UpdateSipProfileReq
     */
    public function setIsAssuredSipServiceEnabled($isAssuredSipServiceEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isAssuredSipServiceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isAssuredSipServiceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isAssuredSipServiceEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isAssuredSipServiceEnabled) && !is_string($isAssuredSipServiceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isAssuredSipServiceEnabled)), __LINE__);
        }
        $this->isAssuredSipServiceEnabled = $isAssuredSipServiceEnabled;
        return $this;
    }
    /**
     * Get resourcePriorityNamespace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getResourcePriorityNamespace()
    {
        return isset($this->resourcePriorityNamespace) ? $this->resourcePriorityNamespace : null;
    }
    /**
     * Set resourcePriorityNamespace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $resourcePriorityNamespace
     * @return \StructType\UpdateSipProfileReq
     */
    public function setResourcePriorityNamespace(\StructType\XFkType $resourcePriorityNamespace = null)
    {
        if (is_null($resourcePriorityNamespace) || (is_array($resourcePriorityNamespace) && empty($resourcePriorityNamespace))) {
            unset($this->resourcePriorityNamespace);
        } else {
            $this->resourcePriorityNamespace = $resourcePriorityNamespace;
        }
        return $this;
    }
    /**
     * Get useCallerIdCallerNameinUriOutgoingRequest value
     * @return string|null
     */
    public function getUseCallerIdCallerNameinUriOutgoingRequest()
    {
        return $this->useCallerIdCallerNameinUriOutgoingRequest;
    }
    /**
     * Set useCallerIdCallerNameinUriOutgoingRequest value
     * @param string $useCallerIdCallerNameinUriOutgoingRequest
     * @return \StructType\UpdateSipProfileReq
     */
    public function setUseCallerIdCallerNameinUriOutgoingRequest($useCallerIdCallerNameinUriOutgoingRequest = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useCallerIdCallerNameinUriOutgoingRequest) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useCallerIdCallerNameinUriOutgoingRequest, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useCallerIdCallerNameinUriOutgoingRequest) && !is_string($useCallerIdCallerNameinUriOutgoingRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useCallerIdCallerNameinUriOutgoingRequest)), __LINE__);
        }
        $this->useCallerIdCallerNameinUriOutgoingRequest = $useCallerIdCallerNameinUriOutgoingRequest;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 50) || (is_array($callerIdDn) && count($callerIdDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerName) && strlen($callerName) > 50) || (is_array($callerName) && count($callerName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerName) ? strlen($callerName) : count($callerName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callingLineIdentification value
     * @return string|null
     */
    public function getCallingLineIdentification()
    {
        return $this->callingLineIdentification;
    }
    /**
     * Set callingLineIdentification value
     * @uses \EnumType\XCallingLineIdentification::valueIsValid()
     * @uses \EnumType\XCallingLineIdentification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdentification
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallingLineIdentification($callingLineIdentification = 'Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCallingLineIdentification::valueIsValid($callingLineIdentification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLineIdentification, implode(', ', \EnumType\XCallingLineIdentification::getValidValues())), __LINE__);
        }
        $this->callingLineIdentification = $callingLineIdentification;
        return $this;
    }
    /**
     * Get rejectAnonymousIncomingCall value
     * @return string|null
     */
    public function getRejectAnonymousIncomingCall()
    {
        return $this->rejectAnonymousIncomingCall;
    }
    /**
     * Set rejectAnonymousIncomingCall value
     * @param string $rejectAnonymousIncomingCall
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRejectAnonymousIncomingCall($rejectAnonymousIncomingCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejectAnonymousIncomingCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousIncomingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rejectAnonymousIncomingCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rejectAnonymousIncomingCall) && !is_string($rejectAnonymousIncomingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rejectAnonymousIncomingCall)), __LINE__);
        }
        $this->rejectAnonymousIncomingCall = $rejectAnonymousIncomingCall;
        return $this;
    }
    /**
     * Get callpickupUri value
     * @return string|null
     */
    public function getCallpickupUri()
    {
        return $this->callpickupUri;
    }
    /**
     * Set callpickupUri value
     * @param string $callpickupUri
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCallpickupUri($callpickupUri = 'x-cisco-serviceuri-pickup')
    {
        // validation for constraint: maxLength
        if ((is_scalar($callpickupUri) && strlen($callpickupUri) > 128) || (is_array($callpickupUri) && count($callpickupUri) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($callpickupUri) ? strlen($callpickupUri) : count($callpickupUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callpickupUri) && !is_string($callpickupUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callpickupUri)), __LINE__);
        }
        $this->callpickupUri = $callpickupUri;
        return $this;
    }
    /**
     * Get rejectAnonymousOutgoingCall value
     * @return string|null
     */
    public function getRejectAnonymousOutgoingCall()
    {
        return $this->rejectAnonymousOutgoingCall;
    }
    /**
     * Set rejectAnonymousOutgoingCall value
     * @param string $rejectAnonymousOutgoingCall
     * @return \StructType\UpdateSipProfileReq
     */
    public function setRejectAnonymousOutgoingCall($rejectAnonymousOutgoingCall = null)
    {
        // validation for constraint: pattern
        if (is_scalar($rejectAnonymousOutgoingCall) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rejectAnonymousOutgoingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rejectAnonymousOutgoingCall, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rejectAnonymousOutgoingCall) && !is_string($rejectAnonymousOutgoingCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rejectAnonymousOutgoingCall)), __LINE__);
        }
        $this->rejectAnonymousOutgoingCall = $rejectAnonymousOutgoingCall;
        return $this;
    }
    /**
     * Get videoCallTrafficClass value
     * @return string|null
     */
    public function getVideoCallTrafficClass()
    {
        return $this->videoCallTrafficClass;
    }
    /**
     * Set videoCallTrafficClass value
     * @uses \EnumType\XVideoCallTrafficClass::valueIsValid()
     * @uses \EnumType\XVideoCallTrafficClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoCallTrafficClass
     * @return \StructType\UpdateSipProfileReq
     */
    public function setVideoCallTrafficClass($videoCallTrafficClass = 'Mixed')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVideoCallTrafficClass::valueIsValid($videoCallTrafficClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoCallTrafficClass, implode(', ', \EnumType\XVideoCallTrafficClass::getValidValues())), __LINE__);
        }
        $this->videoCallTrafficClass = $videoCallTrafficClass;
        return $this;
    }
    /**
     * Get sdpTransparency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getSdpTransparency()
    {
        return isset($this->sdpTransparency) ? $this->sdpTransparency : null;
    }
    /**
     * Set sdpTransparency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $sdpTransparency
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSdpTransparency(\StructType\XFkType $sdpTransparency = null)
    {
        if (is_null($sdpTransparency) || (is_array($sdpTransparency) && empty($sdpTransparency))) {
            unset($this->sdpTransparency);
        } else {
            $this->sdpTransparency = $sdpTransparency;
        }
        return $this;
    }
    /**
     * Get allowMultipleCodecs value
     * @return string|null
     */
    public function getAllowMultipleCodecs()
    {
        return $this->allowMultipleCodecs;
    }
    /**
     * Set allowMultipleCodecs value
     * @param string $allowMultipleCodecs
     * @return \StructType\UpdateSipProfileReq
     */
    public function setAllowMultipleCodecs($allowMultipleCodecs = false)
    {
        // validation for constraint: pattern
        if (is_scalar($allowMultipleCodecs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowMultipleCodecs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowMultipleCodecs, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowMultipleCodecs) && !is_string($allowMultipleCodecs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowMultipleCodecs)), __LINE__);
        }
        $this->allowMultipleCodecs = $allowMultipleCodecs;
        return $this;
    }
    /**
     * Get sipSessionRefreshMethod value
     * @return string|null
     */
    public function getSipSessionRefreshMethod()
    {
        return $this->sipSessionRefreshMethod;
    }
    /**
     * Set sipSessionRefreshMethod value
     * @uses \EnumType\XSipSessionRefreshMethod::valueIsValid()
     * @uses \EnumType\XSipSessionRefreshMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipSessionRefreshMethod
     * @return \StructType\UpdateSipProfileReq
     */
    public function setSipSessionRefreshMethod($sipSessionRefreshMethod = 'Invite')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSipSessionRefreshMethod::valueIsValid($sipSessionRefreshMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipSessionRefreshMethod, implode(', ', \EnumType\XSipSessionRefreshMethod::getValidValues())), __LINE__);
        }
        $this->sipSessionRefreshMethod = $sipSessionRefreshMethod;
        return $this;
    }
    /**
     * Get earlyOfferSuppVoiceCall value
     * @return string|null
     */
    public function getEarlyOfferSuppVoiceCall()
    {
        return $this->earlyOfferSuppVoiceCall;
    }
    /**
     * Set earlyOfferSuppVoiceCall value
     * @uses \EnumType\XEOSuppVoiceCall::valueIsValid()
     * @uses \EnumType\XEOSuppVoiceCall::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $earlyOfferSuppVoiceCall
     * @return \StructType\UpdateSipProfileReq
     */
    public function setEarlyOfferSuppVoiceCall($earlyOfferSuppVoiceCall = Disabled (Default value))
    {
        // validation for constraint: enumeration
        if (!\EnumType\XEOSuppVoiceCall::valueIsValid($earlyOfferSuppVoiceCall)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $earlyOfferSuppVoiceCall, implode(', ', \EnumType\XEOSuppVoiceCall::getValidValues())), __LINE__);
        }
        $this->earlyOfferSuppVoiceCall = $earlyOfferSuppVoiceCall;
        return $this;
    }
    /**
     * Get cucmVersionInSipHeader value
     * @return string|null
     */
    public function getCucmVersionInSipHeader()
    {
        return $this->cucmVersionInSipHeader;
    }
    /**
     * Set cucmVersionInSipHeader value
     * @uses \EnumType\XCUCMVersionInSipHeader::valueIsValid()
     * @uses \EnumType\XCUCMVersionInSipHeader::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cucmVersionInSipHeader
     * @return \StructType\UpdateSipProfileReq
     */
    public function setCucmVersionInSipHeader($cucmVersionInSipHeader = 'Major And Minor')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCUCMVersionInSipHeader::valueIsValid($cucmVersionInSipHeader)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cucmVersionInSipHeader, implode(', ', \EnumType\XCUCMVersionInSipHeader::getValidValues())), __LINE__);
        }
        $this->cucmVersionInSipHeader = $cucmVersionInSipHeader;
        return $this;
    }
    /**
     * Get confidentialAccessLevelHeaders value
     * @return string|null
     */
    public function getConfidentialAccessLevelHeaders()
    {
        return $this->confidentialAccessLevelHeaders;
    }
    /**
     * Set confidentialAccessLevelHeaders value
     * @uses \EnumType\XCALHeaders::valueIsValid()
     * @uses \EnumType\XCALHeaders::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $confidentialAccessLevelHeaders
     * @return \StructType\UpdateSipProfileReq
     */
    public function setConfidentialAccessLevelHeaders($confidentialAccessLevelHeaders = 'Disabled')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCALHeaders::valueIsValid($confidentialAccessLevelHeaders)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $confidentialAccessLevelHeaders, implode(', ', \EnumType\XCALHeaders::getValidValues())), __LINE__);
        }
        $this->confidentialAccessLevelHeaders = $confidentialAccessLevelHeaders;
        return $this;
    }
    /**
     * Get destRouteString value
     * @return string|null
     */
    public function getDestRouteString()
    {
        return $this->destRouteString;
    }
    /**
     * Set destRouteString value
     * @param string $destRouteString
     * @return \StructType\UpdateSipProfileReq
     */
    public function setDestRouteString($destRouteString = null)
    {
        // validation for constraint: pattern
        if (is_scalar($destRouteString) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $destRouteString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($destRouteString, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destRouteString) && !is_string($destRouteString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destRouteString)), __LINE__);
        }
        $this->destRouteString = $destRouteString;
        return $this;
    }
    /**
     * Get inactiveSDPRequired value
     * @return string|null
     */
    public function getInactiveSDPRequired()
    {
        return $this->inactiveSDPRequired;
    }
    /**
     * Set inactiveSDPRequired value
     * @param string $inactiveSDPRequired
     * @return \StructType\UpdateSipProfileReq
     */
    public function setInactiveSDPRequired($inactiveSDPRequired = false)
    {
        // validation for constraint: pattern
        if (is_scalar($inactiveSDPRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $inactiveSDPRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($inactiveSDPRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inactiveSDPRequired) && !is_string($inactiveSDPRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inactiveSDPRequired)), __LINE__);
        }
        $this->inactiveSDPRequired = $inactiveSDPRequired;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSipProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
