<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRemoteDestinationReq StructType
 * @subpackage Structs
 */
class UpdateRemoteDestinationReq extends APIRequest
{
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $destination;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The newDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newDestination;
    /**
     * The answerTooSoonTimer
     * Meta informations extracted from the WSDL
     * - default: 1500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $answerTooSoonTimer;
    /**
     * The answerTooLateTimer
     * Meta informations extracted from the WSDL
     * - default: 19000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $answerTooLateTimer;
    /**
     * The delayBeforeRingingCell
     * Meta informations extracted from the WSDL
     * - default: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $delayBeforeRingingCell;
    /**
     * The ownerUserId
     * Meta informations extracted from the WSDL
     * - documentation: From 10.5, to get proper value of this tag in get handler's response it is required to have value of todaccess, in case if user does not give any value in todaccesss tag, axl will insert a random row so that get handler response can
     * return proper value of Owner User id
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $ownerUserId;
    /**
     * The enableUnifiedMobility
     * Meta informations extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete enable Unified Mobility feature.Use only while update
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableUnifiedMobility;
    /**
     * The remoteDestinationProfileName
     * Meta informations extracted from the WSDL
     * - documentation: If you are giving value to dualModeDeviceName then you can't give value to remoteDestinationProfileName,viceversa
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $remoteDestinationProfileName;
    /**
     * The enableExtendAndConnect
     * Meta informations extracted from the WSDL
     * - documentation: While UPDATE set it to false if you want to delete Enable Extend and Connect.Use only while update
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtendAndConnect;
    /**
     * The ctiRemoteDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $ctiRemoteDeviceName;
    /**
     * The dualModeDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $dualModeDeviceName;
    /**
     * The isMobilePhone
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMobilePhone;
    /**
     * The enableMobileConnect
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileConnect;
    /**
     * The lineAssociations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LineAssociations
     */
    public $lineAssociations;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - default: Etc/GMT
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The todAccessName
     * Meta informations extracted from the WSDL
     * - documentation: From 10.5 version if a user doesn't specify a value in this tag, AXL will still insert a random row in todaccess because value in todaccess is required to fetch value of owner user id properly in get handler
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $todAccessName;
    /**
     * The mobileSmartClientName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not applicable for dualmode phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mobileSmartClientName;
    /**
     * The mobilityProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to CUMC devices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $mobilityProfileName;
    /**
     * The singleNumberReachVoicemail
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleNumberReachVoicemail;
    /**
     * The dialViaOfficeReverseVoicemail
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: This tag is for Mobility Identity
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dialViaOfficeReverseVoicemail;
    /**
     * The removeRingSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveRingSchedule
     */
    public $removeRingSchedule;
    /**
     * The addRingSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddRingSchedule
     */
    public $addRingSchedule;
    /**
     * The ringSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RingSchedule
     */
    public $ringSchedule;
    /**
     * The accessListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $accessListName;
    /**
     * Constructor method for UpdateRemoteDestinationReq
     * @uses UpdateRemoteDestinationReq::setDestination()
     * @uses UpdateRemoteDestinationReq::setUuid()
     * @uses UpdateRemoteDestinationReq::setNewName()
     * @uses UpdateRemoteDestinationReq::setNewDestination()
     * @uses UpdateRemoteDestinationReq::setAnswerTooSoonTimer()
     * @uses UpdateRemoteDestinationReq::setAnswerTooLateTimer()
     * @uses UpdateRemoteDestinationReq::setDelayBeforeRingingCell()
     * @uses UpdateRemoteDestinationReq::setOwnerUserId()
     * @uses UpdateRemoteDestinationReq::setEnableUnifiedMobility()
     * @uses UpdateRemoteDestinationReq::setRemoteDestinationProfileName()
     * @uses UpdateRemoteDestinationReq::setEnableExtendAndConnect()
     * @uses UpdateRemoteDestinationReq::setCtiRemoteDeviceName()
     * @uses UpdateRemoteDestinationReq::setDualModeDeviceName()
     * @uses UpdateRemoteDestinationReq::setIsMobilePhone()
     * @uses UpdateRemoteDestinationReq::setEnableMobileConnect()
     * @uses UpdateRemoteDestinationReq::setLineAssociations()
     * @uses UpdateRemoteDestinationReq::setTimeZone()
     * @uses UpdateRemoteDestinationReq::setTodAccessName()
     * @uses UpdateRemoteDestinationReq::setMobileSmartClientName()
     * @uses UpdateRemoteDestinationReq::setMobilityProfileName()
     * @uses UpdateRemoteDestinationReq::setSingleNumberReachVoicemail()
     * @uses UpdateRemoteDestinationReq::setDialViaOfficeReverseVoicemail()
     * @uses UpdateRemoteDestinationReq::setRemoveRingSchedule()
     * @uses UpdateRemoteDestinationReq::setAddRingSchedule()
     * @uses UpdateRemoteDestinationReq::setRingSchedule()
     * @uses UpdateRemoteDestinationReq::setAccessListName()
     * @param string $destination
     * @param string $uuid
     * @param string $newName
     * @param string $newDestination
     * @param string $answerTooSoonTimer
     * @param string $answerTooLateTimer
     * @param string $delayBeforeRingingCell
     * @param \StructType\XFkType $ownerUserId
     * @param string $enableUnifiedMobility
     * @param \StructType\XFkType $remoteDestinationProfileName
     * @param string $enableExtendAndConnect
     * @param \StructType\XFkType $ctiRemoteDeviceName
     * @param \StructType\XFkType $dualModeDeviceName
     * @param string $isMobilePhone
     * @param string $enableMobileConnect
     * @param \StructType\LineAssociations $lineAssociations
     * @param string $timeZone
     * @param \StructType\XFkType $todAccessName
     * @param \StructType\XFkType $mobileSmartClientName
     * @param \StructType\XFkType $mobilityProfileName
     * @param string $singleNumberReachVoicemail
     * @param string $dialViaOfficeReverseVoicemail
     * @param \StructType\RemoveRingSchedule $removeRingSchedule
     * @param \StructType\AddRingSchedule $addRingSchedule
     * @param \StructType\RingSchedule $ringSchedule
     * @param \StructType\XFkType $accessListName
     */
    public function __construct($destination = null, $uuid = null, $newName = null, $newDestination = null, $answerTooSoonTimer = '1500', $answerTooLateTimer = '19000', $delayBeforeRingingCell = '4000', \StructType\XFkType $ownerUserId = null, $enableUnifiedMobility = null, \StructType\XFkType $remoteDestinationProfileName = null, $enableExtendAndConnect = null, \StructType\XFkType $ctiRemoteDeviceName = null, \StructType\XFkType $dualModeDeviceName = null, $isMobilePhone = false, $enableMobileConnect = true, \StructType\LineAssociations $lineAssociations = null, $timeZone = 'Etc/GMT', \StructType\XFkType $todAccessName = null, \StructType\XFkType $mobileSmartClientName = null, \StructType\XFkType $mobilityProfileName = null, $singleNumberReachVoicemail = 'Use System Default', $dialViaOfficeReverseVoicemail = 'Use System Default', \StructType\RemoveRingSchedule $removeRingSchedule = null, \StructType\AddRingSchedule $addRingSchedule = null, \StructType\RingSchedule $ringSchedule = null, \StructType\XFkType $accessListName = null)
    {
        $this
            ->setDestination($destination)
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setNewDestination($newDestination)
            ->setAnswerTooSoonTimer($answerTooSoonTimer)
            ->setAnswerTooLateTimer($answerTooLateTimer)
            ->setDelayBeforeRingingCell($delayBeforeRingingCell)
            ->setOwnerUserId($ownerUserId)
            ->setEnableUnifiedMobility($enableUnifiedMobility)
            ->setRemoteDestinationProfileName($remoteDestinationProfileName)
            ->setEnableExtendAndConnect($enableExtendAndConnect)
            ->setCtiRemoteDeviceName($ctiRemoteDeviceName)
            ->setDualModeDeviceName($dualModeDeviceName)
            ->setIsMobilePhone($isMobilePhone)
            ->setEnableMobileConnect($enableMobileConnect)
            ->setLineAssociations($lineAssociations)
            ->setTimeZone($timeZone)
            ->setTodAccessName($todAccessName)
            ->setMobileSmartClientName($mobileSmartClientName)
            ->setMobilityProfileName($mobilityProfileName)
            ->setSingleNumberReachVoicemail($singleNumberReachVoicemail)
            ->setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail)
            ->setRemoveRingSchedule($removeRingSchedule)
            ->setAddRingSchedule($addRingSchedule)
            ->setRingSchedule($ringSchedule)
            ->setAccessListName($accessListName);
    }
    /**
     * Get destination value
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get newDestination value
     * @return string|null
     */
    public function getNewDestination()
    {
        return $this->newDestination;
    }
    /**
     * Set newDestination value
     * @param string $newDestination
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setNewDestination($newDestination = null)
    {
        // validation for constraint: string
        if (!is_null($newDestination) && !is_string($newDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDestination)), __LINE__);
        }
        $this->newDestination = $newDestination;
        return $this;
    }
    /**
     * Get answerTooSoonTimer value
     * @return string|null
     */
    public function getAnswerTooSoonTimer()
    {
        return $this->answerTooSoonTimer;
    }
    /**
     * Set answerTooSoonTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooSoonTimer
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setAnswerTooSoonTimer($answerTooSoonTimer = '1500')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($answerTooSoonTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooSoonTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooSoonTimer = $answerTooSoonTimer;
        return $this;
    }
    /**
     * Get answerTooLateTimer value
     * @return string|null
     */
    public function getAnswerTooLateTimer()
    {
        return $this->answerTooLateTimer;
    }
    /**
     * Set answerTooLateTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooLateTimer
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setAnswerTooLateTimer($answerTooLateTimer = '19000')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($answerTooLateTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooLateTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooLateTimer = $answerTooLateTimer;
        return $this;
    }
    /**
     * Get delayBeforeRingingCell value
     * @return string|null
     */
    public function getDelayBeforeRingingCell()
    {
        return $this->delayBeforeRingingCell;
    }
    /**
     * Set delayBeforeRingingCell value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBeforeRingingCell
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setDelayBeforeRingingCell($delayBeforeRingingCell = '4000')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($delayBeforeRingingCell)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayBeforeRingingCell, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->delayBeforeRingingCell = $delayBeforeRingingCell;
        return $this;
    }
    /**
     * Get ownerUserId value
     * @return \StructType\XFkType|null
     */
    public function getOwnerUserId()
    {
        return $this->ownerUserId;
    }
    /**
     * Set ownerUserId value
     * @param \StructType\XFkType $ownerUserId
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setOwnerUserId(\StructType\XFkType $ownerUserId = null)
    {
        $this->ownerUserId = $ownerUserId;
        return $this;
    }
    /**
     * Get enableUnifiedMobility value
     * @return string|null
     */
    public function getEnableUnifiedMobility()
    {
        return $this->enableUnifiedMobility;
    }
    /**
     * Set enableUnifiedMobility value
     * @param string $enableUnifiedMobility
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setEnableUnifiedMobility($enableUnifiedMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableUnifiedMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableUnifiedMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableUnifiedMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableUnifiedMobility) && !is_string($enableUnifiedMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableUnifiedMobility)), __LINE__);
        }
        $this->enableUnifiedMobility = $enableUnifiedMobility;
        return $this;
    }
    /**
     * Get remoteDestinationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRemoteDestinationProfileName()
    {
        return isset($this->remoteDestinationProfileName) ? $this->remoteDestinationProfileName : null;
    }
    /**
     * Set remoteDestinationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $remoteDestinationProfileName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setRemoteDestinationProfileName(\StructType\XFkType $remoteDestinationProfileName = null)
    {
        if (is_null($remoteDestinationProfileName) || (is_array($remoteDestinationProfileName) && empty($remoteDestinationProfileName))) {
            unset($this->remoteDestinationProfileName);
        } else {
            $this->remoteDestinationProfileName = $remoteDestinationProfileName;
        }
        return $this;
    }
    /**
     * Get enableExtendAndConnect value
     * @return string|null
     */
    public function getEnableExtendAndConnect()
    {
        return $this->enableExtendAndConnect;
    }
    /**
     * Set enableExtendAndConnect value
     * @param string $enableExtendAndConnect
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setEnableExtendAndConnect($enableExtendAndConnect = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtendAndConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtendAndConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtendAndConnect, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtendAndConnect) && !is_string($enableExtendAndConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtendAndConnect)), __LINE__);
        }
        $this->enableExtendAndConnect = $enableExtendAndConnect;
        return $this;
    }
    /**
     * Get ctiRemoteDeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCtiRemoteDeviceName()
    {
        return isset($this->ctiRemoteDeviceName) ? $this->ctiRemoteDeviceName : null;
    }
    /**
     * Set ctiRemoteDeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $ctiRemoteDeviceName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setCtiRemoteDeviceName(\StructType\XFkType $ctiRemoteDeviceName = null)
    {
        if (is_null($ctiRemoteDeviceName) || (is_array($ctiRemoteDeviceName) && empty($ctiRemoteDeviceName))) {
            unset($this->ctiRemoteDeviceName);
        } else {
            $this->ctiRemoteDeviceName = $ctiRemoteDeviceName;
        }
        return $this;
    }
    /**
     * Get dualModeDeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDualModeDeviceName()
    {
        return isset($this->dualModeDeviceName) ? $this->dualModeDeviceName : null;
    }
    /**
     * Set dualModeDeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $dualModeDeviceName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setDualModeDeviceName(\StructType\XFkType $dualModeDeviceName = null)
    {
        if (is_null($dualModeDeviceName) || (is_array($dualModeDeviceName) && empty($dualModeDeviceName))) {
            unset($this->dualModeDeviceName);
        } else {
            $this->dualModeDeviceName = $dualModeDeviceName;
        }
        return $this;
    }
    /**
     * Get isMobilePhone value
     * @return string|null
     */
    public function getIsMobilePhone()
    {
        return $this->isMobilePhone;
    }
    /**
     * Set isMobilePhone value
     * @param string $isMobilePhone
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setIsMobilePhone($isMobilePhone = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isMobilePhone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isMobilePhone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isMobilePhone) && !is_string($isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMobilePhone)), __LINE__);
        }
        $this->isMobilePhone = $isMobilePhone;
        return $this;
    }
    /**
     * Get enableMobileConnect value
     * @return string|null
     */
    public function getEnableMobileConnect()
    {
        return $this->enableMobileConnect;
    }
    /**
     * Set enableMobileConnect value
     * @param string $enableMobileConnect
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setEnableMobileConnect($enableMobileConnect = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileConnect, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileConnect) && !is_string($enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileConnect)), __LINE__);
        }
        $this->enableMobileConnect = $enableMobileConnect;
        return $this;
    }
    /**
     * Get lineAssociations value
     * @return \StructType\LineAssociations|null
     */
    public function getLineAssociations()
    {
        return $this->lineAssociations;
    }
    /**
     * Set lineAssociations value
     * @param \StructType\LineAssociations $lineAssociations
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setLineAssociations(\StructType\LineAssociations $lineAssociations = null)
    {
        $this->lineAssociations = $lineAssociations;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \EnumType\XTimeZone::valueIsValid()
     * @uses \EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setTimeZone($timeZone = 'Etc/GMT')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', \EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get todAccessName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getTodAccessName()
    {
        return isset($this->todAccessName) ? $this->todAccessName : null;
    }
    /**
     * Set todAccessName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $todAccessName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setTodAccessName(\StructType\XFkType $todAccessName = null)
    {
        if (is_null($todAccessName) || (is_array($todAccessName) && empty($todAccessName))) {
            unset($this->todAccessName);
        } else {
            $this->todAccessName = $todAccessName;
        }
        return $this;
    }
    /**
     * Get mobileSmartClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMobileSmartClientName()
    {
        return isset($this->mobileSmartClientName) ? $this->mobileSmartClientName : null;
    }
    /**
     * Set mobileSmartClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mobileSmartClientName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setMobileSmartClientName(\StructType\XFkType $mobileSmartClientName = null)
    {
        if (is_null($mobileSmartClientName) || (is_array($mobileSmartClientName) && empty($mobileSmartClientName))) {
            unset($this->mobileSmartClientName);
        } else {
            $this->mobileSmartClientName = $mobileSmartClientName;
        }
        return $this;
    }
    /**
     * Get mobilityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getMobilityProfileName()
    {
        return isset($this->mobilityProfileName) ? $this->mobilityProfileName : null;
    }
    /**
     * Set mobilityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $mobilityProfileName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setMobilityProfileName(\StructType\XFkType $mobilityProfileName = null)
    {
        if (is_null($mobilityProfileName) || (is_array($mobilityProfileName) && empty($mobilityProfileName))) {
            unset($this->mobilityProfileName);
        } else {
            $this->mobilityProfileName = $mobilityProfileName;
        }
        return $this;
    }
    /**
     * Get singleNumberReachVoicemail value
     * @return string|null
     */
    public function getSingleNumberReachVoicemail()
    {
        return $this->singleNumberReachVoicemail;
    }
    /**
     * Set singleNumberReachVoicemail value
     * @uses \EnumType\XVMAvoidancePolicy::valueIsValid()
     * @uses \EnumType\XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleNumberReachVoicemail
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setSingleNumberReachVoicemail($singleNumberReachVoicemail = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVMAvoidancePolicy::valueIsValid($singleNumberReachVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleNumberReachVoicemail, implode(', ', \EnumType\XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->singleNumberReachVoicemail = $singleNumberReachVoicemail;
        return $this;
    }
    /**
     * Get dialViaOfficeReverseVoicemail value
     * @return string|null
     */
    public function getDialViaOfficeReverseVoicemail()
    {
        return $this->dialViaOfficeReverseVoicemail;
    }
    /**
     * Set dialViaOfficeReverseVoicemail value
     * @uses \EnumType\XVMAvoidancePolicy::valueIsValid()
     * @uses \EnumType\XVMAvoidancePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialViaOfficeReverseVoicemail
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setDialViaOfficeReverseVoicemail($dialViaOfficeReverseVoicemail = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XVMAvoidancePolicy::valueIsValid($dialViaOfficeReverseVoicemail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialViaOfficeReverseVoicemail, implode(', ', \EnumType\XVMAvoidancePolicy::getValidValues())), __LINE__);
        }
        $this->dialViaOfficeReverseVoicemail = $dialViaOfficeReverseVoicemail;
        return $this;
    }
    /**
     * Get removeRingSchedule value
     * @return \StructType\RemoveRingSchedule|null
     */
    public function getRemoveRingSchedule()
    {
        return $this->removeRingSchedule;
    }
    /**
     * Set removeRingSchedule value
     * @param \StructType\RemoveRingSchedule $removeRingSchedule
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setRemoveRingSchedule(\StructType\RemoveRingSchedule $removeRingSchedule = null)
    {
        $this->removeRingSchedule = $removeRingSchedule;
        return $this;
    }
    /**
     * Get addRingSchedule value
     * @return \StructType\AddRingSchedule|null
     */
    public function getAddRingSchedule()
    {
        return $this->addRingSchedule;
    }
    /**
     * Set addRingSchedule value
     * @param \StructType\AddRingSchedule $addRingSchedule
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setAddRingSchedule(\StructType\AddRingSchedule $addRingSchedule = null)
    {
        $this->addRingSchedule = $addRingSchedule;
        return $this;
    }
    /**
     * Get ringSchedule value
     * @return \StructType\RingSchedule|null
     */
    public function getRingSchedule()
    {
        return $this->ringSchedule;
    }
    /**
     * Set ringSchedule value
     * @param \StructType\RingSchedule $ringSchedule
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setRingSchedule(\StructType\RingSchedule $ringSchedule = null)
    {
        $this->ringSchedule = $ringSchedule;
        return $this;
    }
    /**
     * Get accessListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getAccessListName()
    {
        return isset($this->accessListName) ? $this->accessListName : null;
    }
    /**
     * Set accessListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $accessListName
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public function setAccessListName(\StructType\XFkType $accessListName = null)
    {
        if (is_null($accessListName) || (is_array($accessListName) && empty($accessListName))) {
            unset($this->accessListName);
        } else {
            $this->accessListName = $accessListName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateRemoteDestinationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
