<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRemoteClusterReq StructType
 * @subpackage Structs
 */
class UpdateRemoteClusterReq extends APIRequest
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $clusterId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The emcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The tftp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $tftp;
    /**
     * The lbm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $lbm;
    /**
     * The uds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XRemoteClusterMember
     */
    public $uds;
    /**
     * Constructor method for UpdateRemoteClusterReq
     * @uses UpdateRemoteClusterReq::setClusterId()
     * @uses UpdateRemoteClusterReq::setUuid()
     * @uses UpdateRemoteClusterReq::setEmcc()
     * @uses UpdateRemoteClusterReq::setPstnAccess()
     * @uses UpdateRemoteClusterReq::setRsvpAgent()
     * @uses UpdateRemoteClusterReq::setTftp()
     * @uses UpdateRemoteClusterReq::setLbm()
     * @uses UpdateRemoteClusterReq::setUds()
     * @param string $clusterId
     * @param string $uuid
     * @param \StructType\XRemoteClusterMember $emcc
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @param \StructType\XRemoteClusterMember $tftp
     * @param \StructType\XRemoteClusterMember $lbm
     * @param \StructType\XRemoteClusterMember $uds
     */
    public function __construct($clusterId = null, $uuid = null, \StructType\XRemoteClusterMember $emcc = null, \StructType\XRemoteClusterMember $pstnAccess = null, \StructType\XRemoteClusterMember $rsvpAgent = null, \StructType\XRemoteClusterMember $tftp = null, \StructType\XRemoteClusterMember $lbm = null, \StructType\XRemoteClusterMember $uds = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setUuid($uuid)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setTftp($tftp)
            ->setLbm($lbm)
            ->setUds($uds);
    }
    /**
     * Get clusterId value
     * @return string
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 255) || (is_array($clusterId) && count($clusterId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get emcc value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param \StructType\XRemoteClusterMember $emcc
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setEmcc(\StructType\XRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param \StructType\XRemoteClusterMember $pstnAccess
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setPstnAccess(\StructType\XRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param \StructType\XRemoteClusterMember $rsvpAgent
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setRsvpAgent(\StructType\XRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get tftp value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getTftp()
    {
        return $this->tftp;
    }
    /**
     * Set tftp value
     * @param \StructType\XRemoteClusterMember $tftp
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setTftp(\StructType\XRemoteClusterMember $tftp = null)
    {
        $this->tftp = $tftp;
        return $this;
    }
    /**
     * Get lbm value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getLbm()
    {
        return $this->lbm;
    }
    /**
     * Set lbm value
     * @param \StructType\XRemoteClusterMember $lbm
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setLbm(\StructType\XRemoteClusterMember $lbm = null)
    {
        $this->lbm = $lbm;
        return $this;
    }
    /**
     * Get uds value
     * @return \StructType\XRemoteClusterMember|null
     */
    public function getUds()
    {
        return $this->uds;
    }
    /**
     * Set uds value
     * @param \StructType\XRemoteClusterMember $uds
     * @return \StructType\UpdateRemoteClusterReq
     */
    public function setUds(\StructType\XRemoteClusterMember $uds = null)
    {
        $this->uds = $uds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateRemoteClusterReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
