<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMobilityProfileReq StructType
 * @subpackage Structs
 */
class UpdateMobilityProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mobileClientCallingOption
     * Meta informations extracted from the WSDL
     * - default: Dial via Office Reverse
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mobileClientCallingOption;
    /**
     * The dvofServiceAccessNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dvofServiceAccessNumber;
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XDirn
     */
    public $dirn;
    /**
     * The dvorCallerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dvorCallerId;
    /**
     * Constructor method for UpdateMobilityProfileReq
     * @uses UpdateMobilityProfileReq::setNewName()
     * @uses UpdateMobilityProfileReq::setDescription()
     * @uses UpdateMobilityProfileReq::setMobileClientCallingOption()
     * @uses UpdateMobilityProfileReq::setDvofServiceAccessNumber()
     * @uses UpdateMobilityProfileReq::setDirn()
     * @uses UpdateMobilityProfileReq::setDvorCallerId()
     * @param string $newName
     * @param string $description
     * @param string $mobileClientCallingOption
     * @param string $dvofServiceAccessNumber
     * @param \StructType\XDirn $dirn
     * @param string $dvorCallerId
     */
    public function __construct($newName = null, $description = null, $mobileClientCallingOption = 'Dial via Office Reverse', $dvofServiceAccessNumber = null, \StructType\XDirn $dirn = null, $dvorCallerId = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setMobileClientCallingOption($mobileClientCallingOption)
            ->setDvofServiceAccessNumber($dvofServiceAccessNumber)
            ->setDirn($dirn)
            ->setDvorCallerId($dvorCallerId);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateMobilityProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateMobilityProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mobileClientCallingOption value
     * @return string|null
     */
    public function getMobileClientCallingOption()
    {
        return $this->mobileClientCallingOption;
    }
    /**
     * Set mobileClientCallingOption value
     * @uses \EnumType\XDialViaOffice::valueIsValid()
     * @uses \EnumType\XDialViaOffice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobileClientCallingOption
     * @return \StructType\UpdateMobilityProfileReq
     */
    public function setMobileClientCallingOption($mobileClientCallingOption = 'Dial via Office Reverse')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDialViaOffice::valueIsValid($mobileClientCallingOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mobileClientCallingOption, implode(', ', \EnumType\XDialViaOffice::getValidValues())), __LINE__);
        }
        $this->mobileClientCallingOption = $mobileClientCallingOption;
        return $this;
    }
    /**
     * Get dvofServiceAccessNumber value
     * @return string|null
     */
    public function getDvofServiceAccessNumber()
    {
        return $this->dvofServiceAccessNumber;
    }
    /**
     * Set dvofServiceAccessNumber value
     * @param string $dvofServiceAccessNumber
     * @return \StructType\UpdateMobilityProfileReq
     */
    public function setDvofServiceAccessNumber($dvofServiceAccessNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dvofServiceAccessNumber) && !is_string($dvofServiceAccessNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dvofServiceAccessNumber)), __LINE__);
        }
        $this->dvofServiceAccessNumber = $dvofServiceAccessNumber;
        return $this;
    }
    /**
     * Get dirn value
     * @return \StructType\XDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \StructType\XDirn $dirn
     * @return \StructType\UpdateMobilityProfileReq
     */
    public function setDirn(\StructType\XDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get dvorCallerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDvorCallerId()
    {
        return isset($this->dvorCallerId) ? $this->dvorCallerId : null;
    }
    /**
     * Set dvorCallerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dvorCallerId
     * @return \StructType\UpdateMobilityProfileReq
     */
    public function setDvorCallerId($dvorCallerId = null)
    {
        // validation for constraint: string
        if (!is_null($dvorCallerId) && !is_string($dvorCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dvorCallerId)), __LINE__);
        }
        if (is_null($dvorCallerId) || (is_array($dvorCallerId) && empty($dvorCallerId))) {
            unset($this->dvorCallerId);
        } else {
            $this->dvorCallerId = $dvorCallerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateMobilityProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
