<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapSystemReq StructType
 * @subpackage Structs
 */
class UpdateLdapSystemReq extends AbstractStructBase
{
    /**
     * The syncEnabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $syncEnabled;
    /**
     * The ldapServer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ldapServer;
    /**
     * The userIdAttribute
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 64
     * @var string
     */
    public $userIdAttribute;
    /**
     * Constructor method for UpdateLdapSystemReq
     * @uses UpdateLdapSystemReq::setSyncEnabled()
     * @uses UpdateLdapSystemReq::setLdapServer()
     * @uses UpdateLdapSystemReq::setUserIdAttribute()
     * @param string $syncEnabled
     * @param string $ldapServer
     * @param string $userIdAttribute
     */
    public function __construct($syncEnabled = null, $ldapServer = null, $userIdAttribute = null)
    {
        $this
            ->setSyncEnabled($syncEnabled)
            ->setLdapServer($ldapServer)
            ->setUserIdAttribute($userIdAttribute);
    }
    /**
     * Get syncEnabled value
     * @return string|null
     */
    public function getSyncEnabled()
    {
        return $this->syncEnabled;
    }
    /**
     * Set syncEnabled value
     * @param string $syncEnabled
     * @return \StructType\UpdateLdapSystemReq
     */
    public function setSyncEnabled($syncEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($syncEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $syncEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($syncEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($syncEnabled) && !is_string($syncEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($syncEnabled)), __LINE__);
        }
        $this->syncEnabled = $syncEnabled;
        return $this;
    }
    /**
     * Get ldapServer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLdapServer()
    {
        return isset($this->ldapServer) ? $this->ldapServer : null;
    }
    /**
     * Set ldapServer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\XLdapServer::valueIsValid()
     * @uses \EnumType\XLdapServer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapServer
     * @return \StructType\UpdateLdapSystemReq
     */
    public function setLdapServer($ldapServer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XLdapServer::valueIsValid($ldapServer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ldapServer, implode(', ', \EnumType\XLdapServer::getValidValues())), __LINE__);
        }
        if (is_null($ldapServer) || (is_array($ldapServer) && empty($ldapServer))) {
            unset($this->ldapServer);
        } else {
            $this->ldapServer = $ldapServer;
        }
        return $this;
    }
    /**
     * Get userIdAttribute value
     * @return string|null
     */
    public function getUserIdAttribute()
    {
        return $this->userIdAttribute;
    }
    /**
     * Set userIdAttribute value
     * @param string $userIdAttribute
     * @return \StructType\UpdateLdapSystemReq
     */
    public function setUserIdAttribute($userIdAttribute = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($userIdAttribute) && strlen($userIdAttribute) > 64) || (is_array($userIdAttribute) && count($userIdAttribute) > 64)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 64 element(s) or a scalar of 64 character(s) at most, "%d" length given', is_scalar($userIdAttribute) ? strlen($userIdAttribute) : count($userIdAttribute)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($userIdAttribute) && !is_string($userIdAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userIdAttribute)), __LINE__);
        }
        $this->userIdAttribute = $userIdAttribute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateLdapSystemReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
