<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeServerReq StructType
 * @subpackage Structs
 */
class UpdateImeServerReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 5620
     * - documentation: Value shpuld be between 1024 and 65535
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The deviceSecurityMode
     * Meta informations extracted from the WSDL
     * - default: Authenticated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceSecurityMode;
    /**
     * The applicationUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \StructType\XFkType
     */
    public $applicationUser;
    /**
     * The reconnectInterval
     * Meta informations extracted from the WSDL
     * - default: 120
     * - documentation: Value should be between 60 and 600
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $reconnectInterval;
    /**
     * Constructor method for UpdateImeServerReq
     * @uses UpdateImeServerReq::setNewName()
     * @uses UpdateImeServerReq::setDescription()
     * @uses UpdateImeServerReq::setIpAddress()
     * @uses UpdateImeServerReq::setPort()
     * @uses UpdateImeServerReq::setDeviceSecurityMode()
     * @uses UpdateImeServerReq::setApplicationUser()
     * @uses UpdateImeServerReq::setReconnectInterval()
     * @param string $newName
     * @param string $description
     * @param string $ipAddress
     * @param string $port
     * @param string $deviceSecurityMode
     * @param \StructType\XFkType $applicationUser
     * @param string $reconnectInterval
     */
    public function __construct($newName = null, $description = null, $ipAddress = null, $port = '5620', $deviceSecurityMode = 'Authenticated', \StructType\XFkType $applicationUser = null, $reconnectInterval = '120')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setIpAddress($ipAddress)
            ->setPort($port)
            ->setDeviceSecurityMode($deviceSecurityMode)
            ->setApplicationUser($applicationUser)
            ->setReconnectInterval($reconnectInterval);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImeServerReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateImeServerReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\UpdateImeServerReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \StructType\UpdateImeServerReq
     */
    public function setPort($port = '5620')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get deviceSecurityMode value
     * @return string|null
     */
    public function getDeviceSecurityMode()
    {
        return $this->deviceSecurityMode;
    }
    /**
     * Set deviceSecurityMode value
     * @uses \EnumType\XServerSecurityMode::valueIsValid()
     * @uses \EnumType\XServerSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceSecurityMode
     * @return \StructType\UpdateImeServerReq
     */
    public function setDeviceSecurityMode($deviceSecurityMode = 'Authenticated')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XServerSecurityMode::valueIsValid($deviceSecurityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceSecurityMode, implode(', ', \EnumType\XServerSecurityMode::getValidValues())), __LINE__);
        }
        $this->deviceSecurityMode = $deviceSecurityMode;
        return $this;
    }
    /**
     * Get applicationUser value
     * @return \StructType\XFkType|null
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param \StructType\XFkType $applicationUser
     * @return \StructType\UpdateImeServerReq
     */
    public function setApplicationUser(\StructType\XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get reconnectInterval value
     * @return string|null
     */
    public function getReconnectInterval()
    {
        return $this->reconnectInterval;
    }
    /**
     * Set reconnectInterval value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reconnectInterval
     * @return \StructType\UpdateImeServerReq
     */
    public function setReconnectInterval($reconnectInterval = '120')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($reconnectInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reconnectInterval, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->reconnectInterval = $reconnectInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateImeServerReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
