<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeRouteFilterGroupReq StructType
 * @subpackage Structs
 */
class UpdateImeRouteFilterGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The groupTrustSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $groupTrustSetting;
    /**
     * Constructor method for UpdateImeRouteFilterGroupReq
     * @uses UpdateImeRouteFilterGroupReq::setNewName()
     * @uses UpdateImeRouteFilterGroupReq::setDescription()
     * @uses UpdateImeRouteFilterGroupReq::setGroupTrustSetting()
     * @param string $newName
     * @param string $description
     * @param string $groupTrustSetting
     */
    public function __construct($newName = null, $description = null, $groupTrustSetting = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setGroupTrustSetting($groupTrustSetting);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateImeRouteFilterGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateImeRouteFilterGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get groupTrustSetting value
     * @return string|null
     */
    public function getGroupTrustSetting()
    {
        return $this->groupTrustSetting;
    }
    /**
     * Set groupTrustSetting value
     * @param string $groupTrustSetting
     * @return \StructType\UpdateImeRouteFilterGroupReq
     */
    public function setGroupTrustSetting($groupTrustSetting = null)
    {
        // validation for constraint: pattern
        if (is_scalar($groupTrustSetting) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $groupTrustSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($groupTrustSetting, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groupTrustSetting) && !is_string($groupTrustSetting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupTrustSetting)), __LINE__);
        }
        $this->groupTrustSetting = $groupTrustSetting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateImeRouteFilterGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
