<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateHuntListReq StructType
 * @subpackage Structs
 */
class UpdateHuntListReq extends NameAndGUIDRequest
{
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The routeListEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeListEnabled;
    /**
     * The voiceMailUsage
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $voiceMailUsage;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Members
     */
    public $members;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * Constructor method for UpdateHuntListReq
     * @uses UpdateHuntListReq::setDescription()
     * @uses UpdateHuntListReq::setCallManagerGroupName()
     * @uses UpdateHuntListReq::setRouteListEnabled()
     * @uses UpdateHuntListReq::setVoiceMailUsage()
     * @uses UpdateHuntListReq::setRemoveMembers()
     * @uses UpdateHuntListReq::setAddMembers()
     * @uses UpdateHuntListReq::setMembers()
     * @uses UpdateHuntListReq::setNewName()
     * @param string $description
     * @param \StructType\XFkType $callManagerGroupName
     * @param string $routeListEnabled
     * @param string $voiceMailUsage
     * @param \StructType\RemoveMembers $removeMembers
     * @param \StructType\AddMembers $addMembers
     * @param \StructType\Members $members
     * @param string $newName
     */
    public function __construct($description = null, \StructType\XFkType $callManagerGroupName = null, $routeListEnabled = false, $voiceMailUsage = false, \StructType\RemoveMembers $removeMembers = null, \StructType\AddMembers $addMembers = null, \StructType\Members $members = null, $newName = null)
    {
        $this
            ->setDescription($description)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setRouteListEnabled($routeListEnabled)
            ->setVoiceMailUsage($voiceMailUsage)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setNewName($newName);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateHuntListReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return isset($this->callManagerGroupName) ? $this->callManagerGroupName : null;
    }
    /**
     * Set callManagerGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $callManagerGroupName
     * @return \StructType\UpdateHuntListReq
     */
    public function setCallManagerGroupName(\StructType\XFkType $callManagerGroupName = null)
    {
        if (is_null($callManagerGroupName) || (is_array($callManagerGroupName) && empty($callManagerGroupName))) {
            unset($this->callManagerGroupName);
        } else {
            $this->callManagerGroupName = $callManagerGroupName;
        }
        return $this;
    }
    /**
     * Get routeListEnabled value
     * @return string|null
     */
    public function getRouteListEnabled()
    {
        return $this->routeListEnabled;
    }
    /**
     * Set routeListEnabled value
     * @param string $routeListEnabled
     * @return \StructType\UpdateHuntListReq
     */
    public function setRouteListEnabled($routeListEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($routeListEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($routeListEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeListEnabled) && !is_string($routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeListEnabled)), __LINE__);
        }
        $this->routeListEnabled = $routeListEnabled;
        return $this;
    }
    /**
     * Get voiceMailUsage value
     * @return string|null
     */
    public function getVoiceMailUsage()
    {
        return $this->voiceMailUsage;
    }
    /**
     * Set voiceMailUsage value
     * @param string $voiceMailUsage
     * @return \StructType\UpdateHuntListReq
     */
    public function setVoiceMailUsage($voiceMailUsage = false)
    {
        // validation for constraint: pattern
        if (is_scalar($voiceMailUsage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($voiceMailUsage, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voiceMailUsage) && !is_string($voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceMailUsage)), __LINE__);
        }
        $this->voiceMailUsage = $voiceMailUsage;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \StructType\RemoveMembers $removeMembers
     * @return \StructType\UpdateHuntListReq
     */
    public function setRemoveMembers(\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \StructType\AddMembers $addMembers
     * @return \StructType\UpdateHuntListReq
     */
    public function setAddMembers(\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\Members $members
     * @return \StructType\UpdateHuntListReq
     */
    public function setMembers(\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateHuntListReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateHuntListReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
