<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFallbackProfileReq StructType
 * @subpackage Structs
 */
class UpdateFallbackProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The advertisedFallbackDirectoryE164Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $advertisedFallbackDirectoryE164Number;
    /**
     * The qosSensistivityLevel
     * Meta informations extracted from the WSDL
     * - default: 3
     * - documentation: The Fallback QOS Sensitivity should be in range 0 to 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The callCss
     * Meta informations extracted from the WSDL
     * - default: Calling device AAR Calling Search Space
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callCss;
    /**
     * The callAnswerTimer
     * Meta informations extracted from the WSDL
     * - default: 6
     * - documentation: The Fallback Call Answer Timer should be in range 1 to 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The directoryNumberPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $directoryNumberPartition;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $directoryNumber;
    /**
     * The numberOfDigitsForCallerIDPartialMatch
     * Meta informations extracted from the WSDL
     * - default: 5
     * - documentation: The number of digits for Caller ID partial match should be in range 4 to 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numberOfDigitsForCallerIDPartialMatch;
    /**
     * Constructor method for UpdateFallbackProfileReq
     * @uses UpdateFallbackProfileReq::setNewName()
     * @uses UpdateFallbackProfileReq::setDescription()
     * @uses UpdateFallbackProfileReq::setAdvertisedFallbackDirectoryE164Number()
     * @uses UpdateFallbackProfileReq::setQosSensistivityLevel()
     * @uses UpdateFallbackProfileReq::setCallCss()
     * @uses UpdateFallbackProfileReq::setCallAnswerTimer()
     * @uses UpdateFallbackProfileReq::setDirectoryNumberPartition()
     * @uses UpdateFallbackProfileReq::setDirectoryNumber()
     * @uses UpdateFallbackProfileReq::setNumberOfDigitsForCallerIDPartialMatch()
     * @param string $newName
     * @param string $description
     * @param string $advertisedFallbackDirectoryE164Number
     * @param string $qosSensistivityLevel
     * @param string $callCss
     * @param string $callAnswerTimer
     * @param \StructType\XFkType $directoryNumberPartition
     * @param string $directoryNumber
     * @param string $numberOfDigitsForCallerIDPartialMatch
     */
    public function __construct($newName = null, $description = null, $advertisedFallbackDirectoryE164Number = null, $qosSensistivityLevel = '3', $callCss = 'Calling device AAR Calling Search Space', $callAnswerTimer = '6', \StructType\XFkType $directoryNumberPartition = null, $directoryNumber = null, $numberOfDigitsForCallerIDPartialMatch = '5')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setCallCss($callCss)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setDirectoryNumberPartition($directoryNumberPartition)
            ->setDirectoryNumber($directoryNumber)
            ->setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get advertisedFallbackDirectoryE164Number value
     * @return string|null
     */
    public function getAdvertisedFallbackDirectoryE164Number()
    {
        return $this->advertisedFallbackDirectoryE164Number;
    }
    /**
     * Set advertisedFallbackDirectoryE164Number value
     * @param string $advertisedFallbackDirectoryE164Number
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number = null)
    {
        // validation for constraint: string
        if (!is_null($advertisedFallbackDirectoryE164Number) && !is_string($advertisedFallbackDirectoryE164Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertisedFallbackDirectoryE164Number)), __LINE__);
        }
        $this->advertisedFallbackDirectoryE164Number = $advertisedFallbackDirectoryE164Number;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = '3')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qosSensistivityLevel, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get callCss value
     * @return string|null
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @uses \EnumType\XFallBackCSSSelection::valueIsValid()
     * @uses \EnumType\XFallBackCSSSelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setCallCss($callCss = 'Calling device AAR Calling Search Space')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XFallBackCSSSelection::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callCss, implode(', ', \EnumType\XFallBackCSSSelection::getValidValues())), __LINE__);
        }
        $this->callCss = $callCss;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setCallAnswerTimer($callAnswerTimer = '6')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callAnswerTimer, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get directoryNumberPartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDirectoryNumberPartition()
    {
        return isset($this->directoryNumberPartition) ? $this->directoryNumberPartition : null;
    }
    /**
     * Set directoryNumberPartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $directoryNumberPartition
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setDirectoryNumberPartition(\StructType\XFkType $directoryNumberPartition = null)
    {
        if (is_null($directoryNumberPartition) || (is_array($directoryNumberPartition) && empty($directoryNumberPartition))) {
            unset($this->directoryNumberPartition);
        } else {
            $this->directoryNumberPartition = $directoryNumberPartition;
        }
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return string|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($directoryNumber) && strlen($directoryNumber) > 16) || (is_array($directoryNumber) && count($directoryNumber) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($directoryNumber) ? strlen($directoryNumber) : count($directoryNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directoryNumber) && !is_string($directoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryNumber)), __LINE__);
        }
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get numberOfDigitsForCallerIDPartialMatch value
     * @return string|null
     */
    public function getNumberOfDigitsForCallerIDPartialMatch()
    {
        return $this->numberOfDigitsForCallerIDPartialMatch;
    }
    /**
     * Set numberOfDigitsForCallerIDPartialMatch value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @return \StructType\UpdateFallbackProfileReq
     */
    public function setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch = '5')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($numberOfDigitsForCallerIDPartialMatch)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfDigitsForCallerIDPartialMatch, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigitsForCallerIDPartialMatch = $numberOfDigitsForCallerIDPartialMatch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateFallbackProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
