<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomUserFieldReq StructType
 * @subpackage Structs
 */
class UpdateCustomUserFieldReq extends APIRequest
{
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $field;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newField
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newField;
    /**
     * Constructor method for UpdateCustomUserFieldReq
     * @uses UpdateCustomUserFieldReq::setField()
     * @uses UpdateCustomUserFieldReq::setUuid()
     * @uses UpdateCustomUserFieldReq::setNewField()
     * @param string $field
     * @param string $uuid
     * @param string $newField
     */
    public function __construct($field = null, $uuid = null, $newField = null)
    {
        $this
            ->setField($field)
            ->setUuid($uuid)
            ->setNewField($newField);
    }
    /**
     * Get field value
     * @return string
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @param string $field
     * @return \StructType\UpdateCustomUserFieldReq
     */
    public function setField($field = null)
    {
        // validation for constraint: string
        if (!is_null($field) && !is_string($field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($field)), __LINE__);
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateCustomUserFieldReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newField value
     * @return string|null
     */
    public function getNewField()
    {
        return $this->newField;
    }
    /**
     * Set newField value
     * @param string $newField
     * @return \StructType\UpdateCustomUserFieldReq
     */
    public function setNewField($newField = null)
    {
        // validation for constraint: string
        if (!is_null($newField) && !is_string($newField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newField)), __LINE__);
        }
        $this->newField = $newField;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomUserFieldReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
