<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCallManagerReq StructType
 * @subpackage Structs
 */
class UpdateCallManagerReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The autoRegistration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AutoRegistration
     */
    public $autoRegistration;
    /**
     * The ports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Ports
     */
    public $ports;
    /**
     * The lbmGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $lbmGroup;
    /**
     * Constructor method for UpdateCallManagerReq
     * @uses UpdateCallManagerReq::setNewName()
     * @uses UpdateCallManagerReq::setDescription()
     * @uses UpdateCallManagerReq::setAutoRegistration()
     * @uses UpdateCallManagerReq::setPorts()
     * @uses UpdateCallManagerReq::setLbmGroup()
     * @param string $newName
     * @param string $description
     * @param \StructType\AutoRegistration $autoRegistration
     * @param \StructType\Ports $ports
     * @param \StructType\XFkType $lbmGroup
     */
    public function __construct($newName = null, $description = null, \StructType\AutoRegistration $autoRegistration = null, \StructType\Ports $ports = null, \StructType\XFkType $lbmGroup = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setAutoRegistration($autoRegistration)
            ->setPorts($ports)
            ->setLbmGroup($lbmGroup);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \StructType\UpdateCallManagerReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateCallManagerReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get autoRegistration value
     * @return \StructType\AutoRegistration|null
     */
    public function getAutoRegistration()
    {
        return $this->autoRegistration;
    }
    /**
     * Set autoRegistration value
     * @param \StructType\AutoRegistration $autoRegistration
     * @return \StructType\UpdateCallManagerReq
     */
    public function setAutoRegistration(\StructType\AutoRegistration $autoRegistration = null)
    {
        $this->autoRegistration = $autoRegistration;
        return $this;
    }
    /**
     * Get ports value
     * @return \StructType\Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param \StructType\Ports $ports
     * @return \StructType\UpdateCallManagerReq
     */
    public function setPorts(\StructType\Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get lbmGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getLbmGroup()
    {
        return isset($this->lbmGroup) ? $this->lbmGroup : null;
    }
    /**
     * Set lbmGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $lbmGroup
     * @return \StructType\UpdateCallManagerReq
     */
    public function setLbmGroup(\StructType\XFkType $lbmGroup = null)
    {
        if (is_null($lbmGroup) || (is_array($lbmGroup) && empty($lbmGroup))) {
            unset($this->lbmGroup);
        } else {
            $this->lbmGroup = $lbmGroup;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCallManagerReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
