<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateApplicationUserCapfProfileReq StructType
 * @subpackage Structs
 */
class UpdateApplicationUserCapfProfileReq extends APIRequest
{
    /**
     * The instanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $instanceId;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - default: No Pending Operation
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - default: By Null String
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - default: 1024
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The keyOrder
     * Meta informations extracted from the WSDL
     * - default: RSA Only
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keyOrder;
    /**
     * The ecKeySize
     * Meta informations extracted from the WSDL
     * - default: 384
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ecKeySize;
    /**
     * The operationCompletion
     * Meta informations extracted from the WSDL
     * - documentation: Required format is YYYY:MM:DD:HH:SS. Read Only when certificateOperation is 'No Pending Operation'. Please provide the above format while adding a new device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $operationCompletion;
    /**
     * Constructor method for UpdateApplicationUserCapfProfileReq
     * @uses UpdateApplicationUserCapfProfileReq::setInstanceId()
     * @uses UpdateApplicationUserCapfProfileReq::setUuid()
     * @uses UpdateApplicationUserCapfProfileReq::setCertificateOperation()
     * @uses UpdateApplicationUserCapfProfileReq::setAuthenticationMode()
     * @uses UpdateApplicationUserCapfProfileReq::setAuthenticationString()
     * @uses UpdateApplicationUserCapfProfileReq::setKeySize()
     * @uses UpdateApplicationUserCapfProfileReq::setKeyOrder()
     * @uses UpdateApplicationUserCapfProfileReq::setEcKeySize()
     * @uses UpdateApplicationUserCapfProfileReq::setOperationCompletion()
     * @param string $instanceId
     * @param string $uuid
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $authenticationString
     * @param string $keySize
     * @param string $keyOrder
     * @param string $ecKeySize
     * @param string $operationCompletion
     */
    public function __construct($instanceId = null, $uuid = null, $certificateOperation = 'No Pending Operation', $authenticationMode = 'By Null String', $authenticationString = null, $keySize = '1024', $keyOrder = 'RSA Only', $ecKeySize = '384', $operationCompletion = null)
    {
        $this
            ->setInstanceId($instanceId)
            ->setUuid($uuid)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setAuthenticationString($authenticationString)
            ->setKeySize($keySize)
            ->setKeyOrder($keyOrder)
            ->setEcKeySize($ecKeySize)
            ->setOperationCompletion($operationCompletion);
    }
    /**
     * Get instanceId value
     * @return string
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string|null
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses \EnumType\XCertificateOperation::valueIsValid()
     * @uses \EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setCertificateOperation($certificateOperation = 'No Pending Operation')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateOperation, implode(', ', \EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \EnumType\XAuthenticationMode::valueIsValid()
     * @uses \EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', \EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \EnumType\XKeySize::valueIsValid()
     * @uses \EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', \EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get keyOrder value
     * @return string|null
     */
    public function getKeyOrder()
    {
        return $this->keyOrder;
    }
    /**
     * Set keyOrder value
     * @uses \EnumType\XKeyOrder::valueIsValid()
     * @uses \EnumType\XKeyOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keyOrder
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setKeyOrder($keyOrder = 'RSA Only')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XKeyOrder::valueIsValid($keyOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keyOrder, implode(', ', \EnumType\XKeyOrder::getValidValues())), __LINE__);
        }
        $this->keyOrder = $keyOrder;
        return $this;
    }
    /**
     * Get ecKeySize value
     * @return string|null
     */
    public function getEcKeySize()
    {
        return $this->ecKeySize;
    }
    /**
     * Set ecKeySize value
     * @uses \EnumType\XECKeySize::valueIsValid()
     * @uses \EnumType\XECKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ecKeySize
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setEcKeySize($ecKeySize = '384')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XECKeySize::valueIsValid($ecKeySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ecKeySize, implode(', ', \EnumType\XECKeySize::getValidValues())), __LINE__);
        }
        $this->ecKeySize = $ecKeySize;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateApplicationUserCapfProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
