<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAdvertisedPatternsReq StructType
 * @subpackage Structs
 */
class UpdateAdvertisedPatternsReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The patternType
     * Meta informations extracted from the WSDL
     * - default: Enterprise Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternType;
    /**
     * The hostedRoutePSTNRule
     * Meta informations extracted from the WSDL
     * - default: Specify
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hostedRoutePSTNRule;
    /**
     * The pstnFailStrip
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailStrip;
    /**
     * The pstnFailPrepend
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $pstnFailPrepend;
    /**
     * Constructor method for UpdateAdvertisedPatternsReq
     * @uses UpdateAdvertisedPatternsReq::setPattern()
     * @uses UpdateAdvertisedPatternsReq::setUuid()
     * @uses UpdateAdvertisedPatternsReq::setDescription()
     * @uses UpdateAdvertisedPatternsReq::setNewPattern()
     * @uses UpdateAdvertisedPatternsReq::setPatternType()
     * @uses UpdateAdvertisedPatternsReq::setHostedRoutePSTNRule()
     * @uses UpdateAdvertisedPatternsReq::setPstnFailStrip()
     * @uses UpdateAdvertisedPatternsReq::setPstnFailPrepend()
     * @param string $pattern
     * @param string $uuid
     * @param string $description
     * @param string $newPattern
     * @param string $patternType
     * @param string $hostedRoutePSTNRule
     * @param string $pstnFailStrip
     * @param string $pstnFailPrepend
     */
    public function __construct($pattern = null, $uuid = null, $description = null, $newPattern = null, $patternType = 'Enterprise Number', $hostedRoutePSTNRule = 'Specify', $pstnFailStrip = '0', $pstnFailPrepend = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setDescription($description)
            ->setNewPattern($newPattern)
            ->setPatternType($patternType)
            ->setHostedRoutePSTNRule($hostedRoutePSTNRule)
            ->setPstnFailStrip($pstnFailStrip)
            ->setPstnFailPrepend($pstnFailPrepend);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get patternType value
     * @return string|null
     */
    public function getPatternType()
    {
        return $this->patternType;
    }
    /**
     * Set patternType value
     * @uses \EnumType\XGlobalNumber::valueIsValid()
     * @uses \EnumType\XGlobalNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternType
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPatternType($patternType = 'Enterprise Number')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XGlobalNumber::valueIsValid($patternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternType, implode(', ', \EnumType\XGlobalNumber::getValidValues())), __LINE__);
        }
        $this->patternType = $patternType;
        return $this;
    }
    /**
     * Get hostedRoutePSTNRule value
     * @return string|null
     */
    public function getHostedRoutePSTNRule()
    {
        return $this->hostedRoutePSTNRule;
    }
    /**
     * Set hostedRoutePSTNRule value
     * @uses \EnumType\XHostedRoutePatternPSTNRule::valueIsValid()
     * @uses \EnumType\XHostedRoutePatternPSTNRule::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hostedRoutePSTNRule
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setHostedRoutePSTNRule($hostedRoutePSTNRule = 'Specify')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XHostedRoutePatternPSTNRule::valueIsValid($hostedRoutePSTNRule)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hostedRoutePSTNRule, implode(', ', \EnumType\XHostedRoutePatternPSTNRule::getValidValues())), __LINE__);
        }
        $this->hostedRoutePSTNRule = $hostedRoutePSTNRule;
        return $this;
    }
    /**
     * Get pstnFailStrip value
     * @return string|null
     */
    public function getPstnFailStrip()
    {
        return $this->pstnFailStrip;
    }
    /**
     * Set pstnFailStrip value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pstnFailStrip
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPstnFailStrip($pstnFailStrip = '0')
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($pstnFailStrip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pstnFailStrip, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pstnFailStrip = $pstnFailStrip;
        return $this;
    }
    /**
     * Get pstnFailPrepend value
     * @return string|null
     */
    public function getPstnFailPrepend()
    {
        return $this->pstnFailPrepend;
    }
    /**
     * Set pstnFailPrepend value
     * @param string $pstnFailPrepend
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public function setPstnFailPrepend($pstnFailPrepend = null)
    {
        // validation for constraint: string
        if (!is_null($pstnFailPrepend) && !is_string($pstnFailPrepend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnFailPrepend)), __LINE__);
        }
        $this->pstnFailPrepend = $pstnFailPrepend;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAdvertisedPatternsReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
