<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for server StructType
 * @subpackage Structs
 */
class Server extends AbstractStructBase
{
    /**
     * The hostName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $hostName;
    /**
     * The ldapPortNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPortNumber;
    /**
     * The sslEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sslEnabled;
    /**
     * The ldapPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ldapPort;
    /**
     * Constructor method for server
     * @uses Server::setHostName()
     * @uses Server::setLdapPortNumber()
     * @uses Server::setSslEnabled()
     * @uses Server::setLdapPort()
     * @param string $hostName
     * @param string $ldapPortNumber
     * @param string $sslEnabled
     * @param string $ldapPort
     */
    public function __construct($hostName = null, $ldapPortNumber = null, $sslEnabled = null, $ldapPort = null)
    {
        $this
            ->setHostName($hostName)
            ->setLdapPortNumber($ldapPortNumber)
            ->setSslEnabled($sslEnabled)
            ->setLdapPort($ldapPort);
    }
    /**
     * Get hostName value
     * @return string|null
     */
    public function getHostName()
    {
        return $this->hostName;
    }
    /**
     * Set hostName value
     * @param string $hostName
     * @return \StructType\Server
     */
    public function setHostName($hostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hostName) && strlen($hostName) > 128) || (is_array($hostName) && count($hostName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($hostName) ? strlen($hostName) : count($hostName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hostName) && !is_string($hostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostName)), __LINE__);
        }
        $this->hostName = $hostName;
        return $this;
    }
    /**
     * Get ldapPortNumber value
     * @return string|null
     */
    public function getLdapPortNumber()
    {
        return $this->ldapPortNumber;
    }
    /**
     * Set ldapPortNumber value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapPortNumber
     * @return \StructType\Server
     */
    public function setLdapPortNumber($ldapPortNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ldapPortNumber)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ldapPortNumber, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ldapPortNumber = $ldapPortNumber;
        return $this;
    }
    /**
     * Get sslEnabled value
     * @return string|null
     */
    public function getSslEnabled()
    {
        return $this->sslEnabled;
    }
    /**
     * Set sslEnabled value
     * @param string $sslEnabled
     * @return \StructType\Server
     */
    public function setSslEnabled($sslEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sslEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sslEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sslEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sslEnabled) && !is_string($sslEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sslEnabled)), __LINE__);
        }
        $this->sslEnabled = $sslEnabled;
        return $this;
    }
    /**
     * Get ldapPort value
     * @return string|null
     */
    public function getLdapPort()
    {
        return $this->ldapPort;
    }
    /**
     * Set ldapPort value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ldapPort
     * @return \StructType\Server
     */
    public function setLdapPort($ldapPort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($ldapPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ldapPort, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->ldapPort = $ldapPort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Server
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
