<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveTransPatternReq StructType
 * @subpackage Structs
 */
class RemoveTransPatternReq extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\XFkType
     */
    public $routeFilterName;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveTransPatternReq
     * @uses RemoveTransPatternReq::setPattern()
     * @uses RemoveTransPatternReq::setRoutePartitionName()
     * @uses RemoveTransPatternReq::setUuid()
     * @uses RemoveTransPatternReq::setDialPlanName()
     * @uses RemoveTransPatternReq::setRouteFilterName()
     * @uses RemoveTransPatternReq::setSequence()
     * @param string $pattern
     * @param \StructType\XFkType $routePartitionName
     * @param string $uuid
     * @param \StructType\XFkType $dialPlanName
     * @param \StructType\XFkType $routeFilterName
     * @param int $sequence
     */
    public function __construct($pattern = null, \StructType\XFkType $routePartitionName = null, $uuid = null, \StructType\XFkType $dialPlanName = null, \StructType\XFkType $routeFilterName = null, $sequence = null)
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setUuid($uuid)
            ->setDialPlanName($dialPlanName)
            ->setRouteFilterName($routeFilterName)
            ->setSequence($sequence);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \StructType\RemoveTransPatternReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \StructType\XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \StructType\XFkType $routePartitionName
     * @return \StructType\RemoveTransPatternReq
     */
    public function setRoutePartitionName(\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RemoveTransPatternReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get dialPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getDialPlanName()
    {
        return isset($this->dialPlanName) ? $this->dialPlanName : null;
    }
    /**
     * Set dialPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $dialPlanName
     * @return \StructType\RemoveTransPatternReq
     */
    public function setDialPlanName(\StructType\XFkType $dialPlanName = null)
    {
        if (is_null($dialPlanName) || (is_array($dialPlanName) && empty($dialPlanName))) {
            unset($this->dialPlanName);
        } else {
            $this->dialPlanName = $dialPlanName;
        }
        return $this;
    }
    /**
     * Get routeFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\XFkType|null
     */
    public function getRouteFilterName()
    {
        return isset($this->routeFilterName) ? $this->routeFilterName : null;
    }
    /**
     * Set routeFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\XFkType $routeFilterName
     * @return \StructType\RemoveTransPatternReq
     */
    public function setRouteFilterName(\StructType\XFkType $routeFilterName = null)
    {
        if (is_null($routeFilterName) || (is_array($routeFilterName) && empty($routeFilterName))) {
            unset($this->routeFilterName);
        } else {
            $this->routeFilterName = $routeFilterName;
        }
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return \StructType\RemoveTransPatternReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveTransPatternReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
