<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveSNMPCommunityStringReq StructType
 * @subpackage Structs
 */
class RemoveSNMPCommunityStringReq extends APIRequest
{
    /**
     * The CommunityString
     * @var string
     */
    public $CommunityString;
    /**
     * Constructor method for RemoveSNMPCommunityStringReq
     * @uses RemoveSNMPCommunityStringReq::setCommunityString()
     * @param string $communityString
     */
    public function __construct($communityString = null)
    {
        $this
            ->setCommunityString($communityString);
    }
    /**
     * Get CommunityString value
     * @return string|null
     */
    public function getCommunityString()
    {
        return $this->CommunityString;
    }
    /**
     * Set CommunityString value
     * @param string $communityString
     * @return \StructType\RemoveSNMPCommunityStringReq
     */
    public function setCommunityString($communityString = null)
    {
        // validation for constraint: string
        if (!is_null($communityString) && !is_string($communityString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communityString)), __LINE__);
        }
        $this->CommunityString = $communityString;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveSNMPCommunityStringReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
