<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeLanguages StructType
 * @subpackage Structs
 */
class RemoveLanguages extends XCommonMembersExtension
{
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\XSelfProvisionRemove[]
     */
    public $language;
    /**
     * Constructor method for removeLanguages
     * @uses RemoveLanguages::setLanguage()
     * @param \StructType\XSelfProvisionRemove[] $language
     */
    public function __construct(array $language = array())
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get language value
     * @return \StructType\XSelfProvisionRemove[]|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @throws \InvalidArgumentException
     * @param \StructType\XSelfProvisionRemove[] $language
     * @return \StructType\RemoveLanguages
     */
    public function setLanguage(array $language = array())
    {
        foreach ($language as $removeLanguagesLanguageItem) {
            // validation for constraint: itemType
            if (!$removeLanguagesLanguageItem instanceof \StructType\XSelfProvisionRemove) {
                throw new \InvalidArgumentException(sprintf('The language property can only contain items of \StructType\XSelfProvisionRemove, "%s" given', is_object($removeLanguagesLanguageItem) ? get_class($removeLanguagesLanguageItem) : gettype($removeLanguagesLanguageItem)), __LINE__);
            }
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Add item to language value
     * @throws \InvalidArgumentException
     * @param \StructType\XSelfProvisionRemove $item
     * @return \StructType\RemoveLanguages
     */
    public function addToLanguage(\StructType\XSelfProvisionRemove $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\XSelfProvisionRemove) {
            throw new \InvalidArgumentException(sprintf('The language property can only contain items of \StructType\XSelfProvisionRemove, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->language[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveLanguages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
