<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveImeLearnedRoutesReq StructType
 * @subpackage Structs
 */
class RemoveImeLearnedRoutesReq extends AbstractStructBase
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The e164Did
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $e164Did;
    /**
     * Constructor method for RemoveImeLearnedRoutesReq
     * @uses RemoveImeLearnedRoutesReq::setUuid()
     * @uses RemoveImeLearnedRoutesReq::setE164Did()
     * @param string $uuid
     * @param string $e164Did
     */
    public function __construct($uuid = null, $e164Did = null)
    {
        $this
            ->setUuid($uuid)
            ->setE164Did($e164Did);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RemoveImeLearnedRoutesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get e164Did value
     * @return string|null
     */
    public function getE164Did()
    {
        return $this->e164Did;
    }
    /**
     * Set e164Did value
     * @param string $e164Did
     * @return \StructType\RemoveImeLearnedRoutesReq
     */
    public function setE164Did($e164Did = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164Did) && strlen($e164Did) > 32) || (is_array($e164Did) && count($e164Did) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($e164Did) ? strlen($e164Did) : count($e164Did)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164Did) && !is_string($e164Did)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Did)), __LINE__);
        }
        $this->e164Did = $e164Did;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveImeLearnedRoutesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
