<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedGroups StructType
 * Meta informations extracted from the WSDL
 * - documentation: Read-only. AXL API automatically adds the required entries in the AARDialPrefixMatrix table.
 * @subpackage Structs
 */
class RelatedGroups extends AbstractStructBase
{
    /**
     * The relatedGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RAarGroupRelationship[]
     */
    public $relatedGroup;
    /**
     * Constructor method for relatedGroups
     * @uses RelatedGroups::setRelatedGroup()
     * @param \StructType\RAarGroupRelationship[] $relatedGroup
     */
    public function __construct(array $relatedGroup = array())
    {
        $this
            ->setRelatedGroup($relatedGroup);
    }
    /**
     * Get relatedGroup value
     * @return \StructType\RAarGroupRelationship[]|null
     */
    public function getRelatedGroup()
    {
        return $this->relatedGroup;
    }
    /**
     * Set relatedGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\RAarGroupRelationship[] $relatedGroup
     * @return \StructType\RelatedGroups
     */
    public function setRelatedGroup(array $relatedGroup = array())
    {
        foreach ($relatedGroup as $relatedGroupsRelatedGroupItem) {
            // validation for constraint: itemType
            if (!$relatedGroupsRelatedGroupItem instanceof \StructType\RAarGroupRelationship) {
                throw new \InvalidArgumentException(sprintf('The relatedGroup property can only contain items of \StructType\RAarGroupRelationship, "%s" given', is_object($relatedGroupsRelatedGroupItem) ? get_class($relatedGroupsRelatedGroupItem) : gettype($relatedGroupsRelatedGroupItem)), __LINE__);
            }
        }
        $this->relatedGroup = $relatedGroup;
        return $this;
    }
    /**
     * Add item to relatedGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\RAarGroupRelationship $item
     * @return \StructType\RelatedGroups
     */
    public function addToRelatedGroup(\StructType\RAarGroupRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RAarGroupRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedGroup property can only contain items of \StructType\RAarGroupRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RelatedGroups
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
