<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSoftKeySet StructType
 * @subpackage Structs
 */
class RSoftKeySet extends AbstractStructBase
{
    /**
     * The softKeyTemplateName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $softKeyTemplateName;
    /**
     * The callStates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CallStates
     */
    public $callStates;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSoftKeySet
     * @uses RSoftKeySet::setSoftKeyTemplateName()
     * @uses RSoftKeySet::setCallStates()
     * @uses RSoftKeySet::setUuid()
     * @param \StructType\XFkType $softKeyTemplateName
     * @param \StructType\CallStates $callStates
     * @param string $uuid
     */
    public function __construct(\StructType\XFkType $softKeyTemplateName = null, \StructType\CallStates $callStates = null, $uuid = null)
    {
        $this
            ->setSoftKeyTemplateName($softKeyTemplateName)
            ->setCallStates($callStates)
            ->setUuid($uuid);
    }
    /**
     * Get softKeyTemplateName value
     * @return \StructType\XFkType|null
     */
    public function getSoftKeyTemplateName()
    {
        return $this->softKeyTemplateName;
    }
    /**
     * Set softKeyTemplateName value
     * @param \StructType\XFkType $softKeyTemplateName
     * @return \StructType\RSoftKeySet
     */
    public function setSoftKeyTemplateName(\StructType\XFkType $softKeyTemplateName = null)
    {
        $this->softKeyTemplateName = $softKeyTemplateName;
        return $this;
    }
    /**
     * Get callStates value
     * @return \StructType\CallStates|null
     */
    public function getCallStates()
    {
        return $this->callStates;
    }
    /**
     * Set callStates value
     * @param \StructType\CallStates $callStates
     * @return \StructType\RSoftKeySet
     */
    public function setCallStates(\StructType\CallStates $callStates = null)
    {
        $this->callStates = $callStates;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RSoftKeySet
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RSoftKeySet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
