<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RServiceProfileList StructType
 * @subpackage Structs
 */
class RServiceProfileList extends AbstractStructBase
{
    /**
     * The profileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $profileName;
    /**
     * The primary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $primary;
    /**
     * The secondary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $secondary;
    /**
     * The tertiary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tertiary;
    /**
     * The serverCertificateVerification
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for Conferencing Profile
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serverCertificateVerification;
    /**
     * The serviceProfileXml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $serviceProfileXml;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RServiceProfileList
     * @uses RServiceProfileList::setProfileName()
     * @uses RServiceProfileList::setPrimary()
     * @uses RServiceProfileList::setSecondary()
     * @uses RServiceProfileList::setTertiary()
     * @uses RServiceProfileList::setServerCertificateVerification()
     * @uses RServiceProfileList::setServiceProfileXml()
     * @uses RServiceProfileList::setUuid()
     * @param string $profileName
     * @param string $primary
     * @param string $secondary
     * @param string $tertiary
     * @param string $serverCertificateVerification
     * @param \StructType\XVendorConfig $serviceProfileXml
     * @param string $uuid
     */
    public function __construct($profileName = null, $primary = null, $secondary = null, $tertiary = null, $serverCertificateVerification = null, \StructType\XVendorConfig $serviceProfileXml = null, $uuid = null)
    {
        $this
            ->setProfileName($profileName)
            ->setPrimary($primary)
            ->setSecondary($secondary)
            ->setTertiary($tertiary)
            ->setServerCertificateVerification($serverCertificateVerification)
            ->setServiceProfileXml($serviceProfileXml)
            ->setUuid($uuid);
    }
    /**
     * Get profileName value
     * @return string|null
     */
    public function getProfileName()
    {
        return $this->profileName;
    }
    /**
     * Set profileName value
     * @param string $profileName
     * @return \StructType\RServiceProfileList
     */
    public function setProfileName($profileName = null)
    {
        // validation for constraint: string
        if (!is_null($profileName) && !is_string($profileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileName)), __LINE__);
        }
        $this->profileName = $profileName;
        return $this;
    }
    /**
     * Get primary value
     * @return string|null
     */
    public function getPrimary()
    {
        return $this->primary;
    }
    /**
     * Set primary value
     * @param string $primary
     * @return \StructType\RServiceProfileList
     */
    public function setPrimary($primary = null)
    {
        // validation for constraint: string
        if (!is_null($primary) && !is_string($primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primary)), __LINE__);
        }
        $this->primary = $primary;
        return $this;
    }
    /**
     * Get secondary value
     * @return string|null
     */
    public function getSecondary()
    {
        return $this->secondary;
    }
    /**
     * Set secondary value
     * @param string $secondary
     * @return \StructType\RServiceProfileList
     */
    public function setSecondary($secondary = null)
    {
        // validation for constraint: string
        if (!is_null($secondary) && !is_string($secondary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondary)), __LINE__);
        }
        $this->secondary = $secondary;
        return $this;
    }
    /**
     * Get tertiary value
     * @return string|null
     */
    public function getTertiary()
    {
        return $this->tertiary;
    }
    /**
     * Set tertiary value
     * @param string $tertiary
     * @return \StructType\RServiceProfileList
     */
    public function setTertiary($tertiary = null)
    {
        // validation for constraint: string
        if (!is_null($tertiary) && !is_string($tertiary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tertiary)), __LINE__);
        }
        $this->tertiary = $tertiary;
        return $this;
    }
    /**
     * Get serverCertificateVerification value
     * @return string|null
     */
    public function getServerCertificateVerification()
    {
        return $this->serverCertificateVerification;
    }
    /**
     * Set serverCertificateVerification value
     * @uses \EnumType\XCertificateVerificationLevel::valueIsValid()
     * @uses \EnumType\XCertificateVerificationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serverCertificateVerification
     * @return \StructType\RServiceProfileList
     */
    public function setServerCertificateVerification($serverCertificateVerification = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCertificateVerificationLevel::valueIsValid($serverCertificateVerification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serverCertificateVerification, implode(', ', \EnumType\XCertificateVerificationLevel::getValidValues())), __LINE__);
        }
        $this->serverCertificateVerification = $serverCertificateVerification;
        return $this;
    }
    /**
     * Get serviceProfileXml value
     * @return \StructType\XVendorConfig|null
     */
    public function getServiceProfileXml()
    {
        return $this->serviceProfileXml;
    }
    /**
     * Set serviceProfileXml value
     * @param \StructType\XVendorConfig $serviceProfileXml
     * @return \StructType\RServiceProfileList
     */
    public function setServiceProfileXml(\StructType\XVendorConfig $serviceProfileXml = null)
    {
        $this->serviceProfileXml = $serviceProfileXml;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RServiceProfileList
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RServiceProfileList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
