<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSIPNormalizationScript StructType
 * @subpackage Structs
 */
class RSIPNormalizationScript extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $content;
    /**
     * The scriptExecutionErrorRecoveryAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scriptExecutionErrorRecoveryAction;
    /**
     * The systemResourceErrorRecoveryAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $systemResourceErrorRecoveryAction;
    /**
     * The maxMemoryThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxMemoryThreshold;
    /**
     * The maxLuaInstructionsThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxLuaInstructionsThreshold;
    /**
     * The isStandard
     * Meta informations extracted from the WSDL
     * - documentation: If the value of isStandard is t (true), the fields are not editable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isStandard;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RSIPNormalizationScript
     * @uses RSIPNormalizationScript::setName()
     * @uses RSIPNormalizationScript::setDescription()
     * @uses RSIPNormalizationScript::setContent()
     * @uses RSIPNormalizationScript::setScriptExecutionErrorRecoveryAction()
     * @uses RSIPNormalizationScript::setSystemResourceErrorRecoveryAction()
     * @uses RSIPNormalizationScript::setMaxMemoryThreshold()
     * @uses RSIPNormalizationScript::setMaxLuaInstructionsThreshold()
     * @uses RSIPNormalizationScript::setIsStandard()
     * @uses RSIPNormalizationScript::setUuid()
     * @param string $name
     * @param string $description
     * @param string $content
     * @param string $scriptExecutionErrorRecoveryAction
     * @param string $systemResourceErrorRecoveryAction
     * @param string $maxMemoryThreshold
     * @param string $maxLuaInstructionsThreshold
     * @param string $isStandard
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $content = null, $scriptExecutionErrorRecoveryAction = null, $systemResourceErrorRecoveryAction = null, $maxMemoryThreshold = null, $maxLuaInstructionsThreshold = null, $isStandard = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setContent($content)
            ->setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction)
            ->setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction)
            ->setMaxMemoryThreshold($maxMemoryThreshold)
            ->setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold)
            ->setIsStandard($isStandard)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RSIPNormalizationScript
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RSIPNormalizationScript
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \StructType\RSIPNormalizationScript
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Get scriptExecutionErrorRecoveryAction value
     * @return string|null
     */
    public function getScriptExecutionErrorRecoveryAction()
    {
        return $this->scriptExecutionErrorRecoveryAction;
    }
    /**
     * Set scriptExecutionErrorRecoveryAction value
     * @uses \EnumType\XSIPScriptErrorHandling::valueIsValid()
     * @uses \EnumType\XSIPScriptErrorHandling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scriptExecutionErrorRecoveryAction
     * @return \StructType\RSIPNormalizationScript
     */
    public function setScriptExecutionErrorRecoveryAction($scriptExecutionErrorRecoveryAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPScriptErrorHandling::valueIsValid($scriptExecutionErrorRecoveryAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scriptExecutionErrorRecoveryAction, implode(', ', \EnumType\XSIPScriptErrorHandling::getValidValues())), __LINE__);
        }
        $this->scriptExecutionErrorRecoveryAction = $scriptExecutionErrorRecoveryAction;
        return $this;
    }
    /**
     * Get systemResourceErrorRecoveryAction value
     * @return string|null
     */
    public function getSystemResourceErrorRecoveryAction()
    {
        return $this->systemResourceErrorRecoveryAction;
    }
    /**
     * Set systemResourceErrorRecoveryAction value
     * @uses \EnumType\XSIPScriptErrorHandling::valueIsValid()
     * @uses \EnumType\XSIPScriptErrorHandling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $systemResourceErrorRecoveryAction
     * @return \StructType\RSIPNormalizationScript
     */
    public function setSystemResourceErrorRecoveryAction($systemResourceErrorRecoveryAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XSIPScriptErrorHandling::valueIsValid($systemResourceErrorRecoveryAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $systemResourceErrorRecoveryAction, implode(', ', \EnumType\XSIPScriptErrorHandling::getValidValues())), __LINE__);
        }
        $this->systemResourceErrorRecoveryAction = $systemResourceErrorRecoveryAction;
        return $this;
    }
    /**
     * Get maxMemoryThreshold value
     * @return string|null
     */
    public function getMaxMemoryThreshold()
    {
        return $this->maxMemoryThreshold;
    }
    /**
     * Set maxMemoryThreshold value
     * @param string $maxMemoryThreshold
     * @return \StructType\RSIPNormalizationScript
     */
    public function setMaxMemoryThreshold($maxMemoryThreshold = null)
    {
        // validation for constraint: string
        if (!is_null($maxMemoryThreshold) && !is_string($maxMemoryThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxMemoryThreshold)), __LINE__);
        }
        $this->maxMemoryThreshold = $maxMemoryThreshold;
        return $this;
    }
    /**
     * Get maxLuaInstructionsThreshold value
     * @return string|null
     */
    public function getMaxLuaInstructionsThreshold()
    {
        return $this->maxLuaInstructionsThreshold;
    }
    /**
     * Set maxLuaInstructionsThreshold value
     * @param string $maxLuaInstructionsThreshold
     * @return \StructType\RSIPNormalizationScript
     */
    public function setMaxLuaInstructionsThreshold($maxLuaInstructionsThreshold = null)
    {
        // validation for constraint: string
        if (!is_null($maxLuaInstructionsThreshold) && !is_string($maxLuaInstructionsThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxLuaInstructionsThreshold)), __LINE__);
        }
        $this->maxLuaInstructionsThreshold = $maxLuaInstructionsThreshold;
        return $this;
    }
    /**
     * Get isStandard value
     * @return string|null
     */
    public function getIsStandard()
    {
        return $this->isStandard;
    }
    /**
     * Set isStandard value
     * @param string $isStandard
     * @return \StructType\RSIPNormalizationScript
     */
    public function setIsStandard($isStandard = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isStandard) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isStandard, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isStandard) && !is_string($isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isStandard)), __LINE__);
        }
        $this->isStandard = $isStandard;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RSIPNormalizationScript
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RSIPNormalizationScript
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
