<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RLbmGroup StructType
 * @subpackage Structs
 */
class RLbmGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ProcessnodeActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ProcessnodeActive;
    /**
     * The ProcessnodeStandby
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $ProcessnodeStandby;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RLbmGroup
     * @uses RLbmGroup::setName()
     * @uses RLbmGroup::setDescription()
     * @uses RLbmGroup::setProcessnodeActive()
     * @uses RLbmGroup::setProcessnodeStandby()
     * @uses RLbmGroup::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $processnodeActive
     * @param \StructType\XFkType $processnodeStandby
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $processnodeActive = null, \StructType\XFkType $processnodeStandby = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProcessnodeActive($processnodeActive)
            ->setProcessnodeStandby($processnodeStandby)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RLbmGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\RLbmGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ProcessnodeActive value
     * @return \StructType\XFkType|null
     */
    public function getProcessnodeActive()
    {
        return $this->ProcessnodeActive;
    }
    /**
     * Set ProcessnodeActive value
     * @param \StructType\XFkType $processnodeActive
     * @return \StructType\RLbmGroup
     */
    public function setProcessnodeActive(\StructType\XFkType $processnodeActive = null)
    {
        $this->ProcessnodeActive = $processnodeActive;
        return $this;
    }
    /**
     * Get ProcessnodeStandby value
     * @return \StructType\XFkType|null
     */
    public function getProcessnodeStandby()
    {
        return $this->ProcessnodeStandby;
    }
    /**
     * Set ProcessnodeStandby value
     * @param \StructType\XFkType $processnodeStandby
     * @return \StructType\RLbmGroup
     */
    public function setProcessnodeStandby(\StructType\XFkType $processnodeStandby = null)
    {
        $this->ProcessnodeStandby = $processnodeStandby;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RLbmGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RLbmGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
