<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RInterClusterServiceProfile StructType
 * @subpackage Structs
 */
class RInterClusterServiceProfile extends AbstractStructBase
{
    /**
     * The interClusterService
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $interClusterService;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The sipTrunkName
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for PSTN Access and RSVP Agent
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $sipTrunkName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RInterClusterServiceProfile
     * @uses RInterClusterServiceProfile::setInterClusterService()
     * @uses RInterClusterServiceProfile::setIsActivated()
     * @uses RInterClusterServiceProfile::setSipTrunkName()
     * @uses RInterClusterServiceProfile::setUuid()
     * @param string $interClusterService
     * @param string $isActivated
     * @param \StructType\XFkType $sipTrunkName
     * @param string $uuid
     */
    public function __construct($interClusterService = null, $isActivated = null, \StructType\XFkType $sipTrunkName = null, $uuid = null)
    {
        $this
            ->setInterClusterService($interClusterService)
            ->setIsActivated($isActivated)
            ->setSipTrunkName($sipTrunkName)
            ->setUuid($uuid);
    }
    /**
     * Get interClusterService value
     * @return string|null
     */
    public function getInterClusterService()
    {
        return $this->interClusterService;
    }
    /**
     * Set interClusterService value
     * @uses \EnumType\XInterClusterService::valueIsValid()
     * @uses \EnumType\XInterClusterService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interClusterService
     * @return \StructType\RInterClusterServiceProfile
     */
    public function setInterClusterService($interClusterService = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInterClusterService::valueIsValid($interClusterService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $interClusterService, implode(', ', \EnumType\XInterClusterService::getValidValues())), __LINE__);
        }
        $this->interClusterService = $interClusterService;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return \StructType\RInterClusterServiceProfile
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get sipTrunkName value
     * @return \StructType\XFkType|null
     */
    public function getSipTrunkName()
    {
        return $this->sipTrunkName;
    }
    /**
     * Set sipTrunkName value
     * @param \StructType\XFkType $sipTrunkName
     * @return \StructType\RInterClusterServiceProfile
     */
    public function setSipTrunkName(\StructType\XFkType $sipTrunkName = null)
    {
        $this->sipTrunkName = $sipTrunkName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RInterClusterServiceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RInterClusterServiceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
