<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeEnrolledPatternGroup StructType
 * @subpackage Structs
 */
class RImeEnrolledPatternGroup extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fallbackProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $fallbackProfileName;
    /**
     * The isPatternAllAlias
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPatternAllAlias;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeEnrolledPatternGroup
     * @uses RImeEnrolledPatternGroup::setName()
     * @uses RImeEnrolledPatternGroup::setDescription()
     * @uses RImeEnrolledPatternGroup::setFallbackProfileName()
     * @uses RImeEnrolledPatternGroup::setIsPatternAllAlias()
     * @uses RImeEnrolledPatternGroup::setUuid()
     * @param string $name
     * @param string $description
     * @param \StructType\XFkType $fallbackProfileName
     * @param string $isPatternAllAlias
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, \StructType\XFkType $fallbackProfileName = null, $isPatternAllAlias = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFallbackProfileName($fallbackProfileName)
            ->setIsPatternAllAlias($isPatternAllAlias)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fallbackProfileName value
     * @return \StructType\XFkType|null
     */
    public function getFallbackProfileName()
    {
        return $this->fallbackProfileName;
    }
    /**
     * Set fallbackProfileName value
     * @param \StructType\XFkType $fallbackProfileName
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setFallbackProfileName(\StructType\XFkType $fallbackProfileName = null)
    {
        $this->fallbackProfileName = $fallbackProfileName;
        return $this;
    }
    /**
     * Get isPatternAllAlias value
     * @return string|null
     */
    public function getIsPatternAllAlias()
    {
        return $this->isPatternAllAlias;
    }
    /**
     * Set isPatternAllAlias value
     * @param string $isPatternAllAlias
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setIsPatternAllAlias($isPatternAllAlias = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isPatternAllAlias) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPatternAllAlias, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPatternAllAlias) && !is_string($isPatternAllAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPatternAllAlias)), __LINE__);
        }
        $this->isPatternAllAlias = $isPatternAllAlias;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RImeEnrolledPatternGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
