<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RGatewayEndpointAnalog StructType
 * @subpackage Structs
 */
class RGatewayEndpointAnalog extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - documentation: Model ID string. Read Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RAnalogPort
     */
    public $port;
    /**
     * The trunkSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trunkSelectionOrder;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The callingPartyNumberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $callingPartyNumberPrefix;
    /**
     * The callingPartyStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyStripDigits;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssUnknown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnknown;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable for MGCP FXS ports,which supports PLAR.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The imeE164DirectoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $imeE164DirectoryNumber;
    /**
     * The confidentialAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ConfidentialAccess
     */
    public $confidentialAccess;
    /**
     * The elinGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\XFkType
     */
    public $elinGroup;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RGatewayEndpointAnalog
     * @uses RGatewayEndpointAnalog::setIndex()
     * @uses RGatewayEndpointAnalog::setName()
     * @uses RGatewayEndpointAnalog::setDescription()
     * @uses RGatewayEndpointAnalog::setProduct()
     * @uses RGatewayEndpointAnalog::setModel()
     * @uses RGatewayEndpointAnalog::setClass()
     * @uses RGatewayEndpointAnalog::setProtocol()
     * @uses RGatewayEndpointAnalog::setProtocolSide()
     * @uses RGatewayEndpointAnalog::setCallingSearchSpaceName()
     * @uses RGatewayEndpointAnalog::setDevicePoolName()
     * @uses RGatewayEndpointAnalog::setCommonDeviceConfigName()
     * @uses RGatewayEndpointAnalog::setNetworkLocale()
     * @uses RGatewayEndpointAnalog::setLocationName()
     * @uses RGatewayEndpointAnalog::setMediaResourceListName()
     * @uses RGatewayEndpointAnalog::setAutomatedAlternateRoutingCssName()
     * @uses RGatewayEndpointAnalog::setAarNeighborhoodName()
     * @uses RGatewayEndpointAnalog::setVendorConfig()
     * @uses RGatewayEndpointAnalog::setMlppDomainId()
     * @uses RGatewayEndpointAnalog::setUseTrustedRelayPoint()
     * @uses RGatewayEndpointAnalog::setRetryVideoCallAsAudio()
     * @uses RGatewayEndpointAnalog::setCgpnTransformationCssName()
     * @uses RGatewayEndpointAnalog::setUseDevicePoolCgpnTransformCss()
     * @uses RGatewayEndpointAnalog::setGeoLocationName()
     * @uses RGatewayEndpointAnalog::setGeoLocationFilterName()
     * @uses RGatewayEndpointAnalog::setPort()
     * @uses RGatewayEndpointAnalog::setTrunkSelectionOrder()
     * @uses RGatewayEndpointAnalog::setTransmitUtf8()
     * @uses RGatewayEndpointAnalog::setCdpnTransformationCssName()
     * @uses RGatewayEndpointAnalog::setUseDevicePoolCdpnTransformCss()
     * @uses RGatewayEndpointAnalog::setCallingPartyNumberPrefix()
     * @uses RGatewayEndpointAnalog::setCallingPartyStripDigits()
     * @uses RGatewayEndpointAnalog::setCallingPartyUnknownTransformationCssName()
     * @uses RGatewayEndpointAnalog::setUseDevicePoolCgpnTransformCssUnknown()
     * @uses RGatewayEndpointAnalog::setHotlineDevice()
     * @uses RGatewayEndpointAnalog::setPacketCaptureMode()
     * @uses RGatewayEndpointAnalog::setPacketCaptureDuration()
     * @uses RGatewayEndpointAnalog::setPstnAccess()
     * @uses RGatewayEndpointAnalog::setImeE164TransformationName()
     * @uses RGatewayEndpointAnalog::setImeE164DirectoryNumber()
     * @uses RGatewayEndpointAnalog::setConfidentialAccess()
     * @uses RGatewayEndpointAnalog::setElinGroup()
     * @uses RGatewayEndpointAnalog::setCtiid()
     * @uses RGatewayEndpointAnalog::setUuid()
     * @param string $index
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \StructType\XFkType $callingSearchSpaceName
     * @param \StructType\XFkType $devicePoolName
     * @param \StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocale
     * @param \StructType\XFkType $locationName
     * @param \StructType\XFkType $mediaResourceListName
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @param \StructType\XFkType $aarNeighborhoodName
     * @param \StructType\XVendorConfig $vendorConfig
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \StructType\XFkType $geoLocationName
     * @param \StructType\XFkType $geoLocationFilterName
     * @param \StructType\RAnalogPort $port
     * @param string $trunkSelectionOrder
     * @param string $transmitUtf8
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $callingPartyNumberPrefix
     * @param string $callingPartyStripDigits
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssUnknown
     * @param string $hotlineDevice
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $pstnAccess
     * @param \StructType\XFkType $imeE164TransformationName
     * @param string $imeE164DirectoryNumber
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @param \StructType\XFkType $elinGroup
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($index = null, $name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \StructType\XFkType $callingSearchSpaceName = null, \StructType\XFkType $devicePoolName = null, \StructType\XFkType $commonDeviceConfigName = null, $networkLocale = null, \StructType\XFkType $locationName = null, \StructType\XFkType $mediaResourceListName = null, \StructType\XFkType $automatedAlternateRoutingCssName = null, \StructType\XFkType $aarNeighborhoodName = null, \StructType\XVendorConfig $vendorConfig = null, $mlppDomainId = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, \StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \StructType\XFkType $geoLocationName = null, \StructType\XFkType $geoLocationFilterName = null, \StructType\RAnalogPort $port = null, $trunkSelectionOrder = null, $transmitUtf8 = null, \StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $callingPartyNumberPrefix = null, $callingPartyStripDigits = null, \StructType\XFkType $callingPartyUnknownTransformationCssName = null, $useDevicePoolCgpnTransformCssUnknown = null, $hotlineDevice = null, $packetCaptureMode = null, $packetCaptureDuration = null, $pstnAccess = null, \StructType\XFkType $imeE164TransformationName = null, $imeE164DirectoryNumber = null, \StructType\ConfidentialAccess $confidentialAccess = null, \StructType\XFkType $elinGroup = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocale($networkLocale)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setVendorConfig($vendorConfig)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setPort($port)
            ->setTrunkSelectionOrder($trunkSelectionOrder)
            ->setTransmitUtf8($transmitUtf8)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setCallingPartyNumberPrefix($callingPartyNumberPrefix)
            ->setCallingPartyStripDigits($callingPartyStripDigits)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssUnknown($useDevicePoolCgpnTransformCssUnknown)
            ->setHotlineDevice($hotlineDevice)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setImeE164DirectoryNumber($imeE164DirectoryNumber)
            ->setConfidentialAccess($confidentialAccess)
            ->setElinGroup($elinGroup)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \EnumType\XProduct::valueIsValid()
     * @uses \EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \EnumType\XModel::valueIsValid()
     * @uses \EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', \EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \EnumType\XClass::valueIsValid()
     * @uses \EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \EnumType\XDeviceProtocol::valueIsValid()
     * @uses \EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \EnumType\XProtocolSide::valueIsValid()
     * @uses \EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \StructType\XFkType $callingSearchSpaceName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCallingSearchSpaceName(\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \StructType\XFkType $devicePoolName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setDevicePoolName(\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \StructType\XFkType $commonDeviceConfigName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCommonDeviceConfigName(\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses \EnumType\XCountry::valueIsValid()
     * @uses \EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', \EnumType\XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\XFkType $locationName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setLocationName(\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \StructType\XFkType $mediaResourceListName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setMediaResourceListName(\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \StructType\XFkType $automatedAlternateRoutingCssName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setAutomatedAlternateRoutingCssName(\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \StructType\XFkType $aarNeighborhoodName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setAarNeighborhoodName(\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \StructType\XVendorConfig $vendorConfig
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setVendorConfig(\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \EnumType\XStatus::valueIsValid()
     * @uses \EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \StructType\XFkType $cgpnTransformationCssName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCgpnTransformationCssName(\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \StructType\XFkType $geoLocationName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setGeoLocationName(\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \StructType\XFkType $geoLocationFilterName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setGeoLocationFilterName(\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get port value
     * @return \StructType\RAnalogPort|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param \StructType\RAnalogPort $port
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setPort(\StructType\RAnalogPort $port = null)
    {
        $this->port = $port;
        return $this;
    }
    /**
     * Get trunkSelectionOrder value
     * @return string|null
     */
    public function getTrunkSelectionOrder()
    {
        return $this->trunkSelectionOrder;
    }
    /**
     * Set trunkSelectionOrder value
     * @uses \EnumType\XTrunkSelectionOrder::valueIsValid()
     * @uses \EnumType\XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkSelectionOrder
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setTrunkSelectionOrder($trunkSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XTrunkSelectionOrder::valueIsValid($trunkSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkSelectionOrder, implode(', ', \EnumType\XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->trunkSelectionOrder = $trunkSelectionOrder;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \StructType\XFkType $cdpnTransformationCssName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCdpnTransformationCssName(\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get callingPartyNumberPrefix value
     * @return string|null
     */
    public function getCallingPartyNumberPrefix()
    {
        return $this->callingPartyNumberPrefix;
    }
    /**
     * Set callingPartyNumberPrefix value
     * @param string $callingPartyNumberPrefix
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCallingPartyNumberPrefix($callingPartyNumberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyNumberPrefix) && strlen($callingPartyNumberPrefix) > 16) || (is_array($callingPartyNumberPrefix) && count($callingPartyNumberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyNumberPrefix) ? strlen($callingPartyNumberPrefix) : count($callingPartyNumberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyNumberPrefix) && !is_string($callingPartyNumberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyNumberPrefix)), __LINE__);
        }
        $this->callingPartyNumberPrefix = $callingPartyNumberPrefix;
        return $this;
    }
    /**
     * Get callingPartyStripDigits value
     * @return string|null
     */
    public function getCallingPartyStripDigits()
    {
        return $this->callingPartyStripDigits;
    }
    /**
     * Set callingPartyStripDigits value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyStripDigits
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCallingPartyStripDigits($callingPartyStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($callingPartyStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyStripDigits, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyStripDigits = $callingPartyStripDigits;
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * @return \StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return $this->callingPartyUnknownTransformationCssName;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * @param \StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCallingPartyUnknownTransformationCssName(\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnknown value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnknown()
    {
        return $this->useDevicePoolCgpnTransformCssUnknown;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnknown value
     * @param string $useDevicePoolCgpnTransformCssUnknown
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setUseDevicePoolCgpnTransformCssUnknown($useDevicePoolCgpnTransformCssUnknown = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnknown) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnknown, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnknown) && !is_string($useDevicePoolCgpnTransformCssUnknown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnknown)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnknown = $useDevicePoolCgpnTransformCssUnknown;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setHotlineDevice($hotlineDevice = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses \EnumType\XInteger::valueIsValid()
     * @uses \EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return \StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param \StructType\XFkType $imeE164TransformationName
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setImeE164TransformationName(\StructType\XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get imeE164DirectoryNumber value
     * @return string|null
     */
    public function getImeE164DirectoryNumber()
    {
        return $this->imeE164DirectoryNumber;
    }
    /**
     * Set imeE164DirectoryNumber value
     * @param string $imeE164DirectoryNumber
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setImeE164DirectoryNumber($imeE164DirectoryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($imeE164DirectoryNumber) && strlen($imeE164DirectoryNumber) > 16) || (is_array($imeE164DirectoryNumber) && count($imeE164DirectoryNumber) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($imeE164DirectoryNumber) ? strlen($imeE164DirectoryNumber) : count($imeE164DirectoryNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($imeE164DirectoryNumber) && !is_string($imeE164DirectoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imeE164DirectoryNumber)), __LINE__);
        }
        $this->imeE164DirectoryNumber = $imeE164DirectoryNumber;
        return $this;
    }
    /**
     * Get confidentialAccess value
     * @return \StructType\ConfidentialAccess|null
     */
    public function getConfidentialAccess()
    {
        return $this->confidentialAccess;
    }
    /**
     * Set confidentialAccess value
     * @param \StructType\ConfidentialAccess $confidentialAccess
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setConfidentialAccess(\StructType\ConfidentialAccess $confidentialAccess = null)
    {
        $this->confidentialAccess = $confidentialAccess;
        return $this;
    }
    /**
     * Get elinGroup value
     * @return \StructType\XFkType|null
     */
    public function getElinGroup()
    {
        return $this->elinGroup;
    }
    /**
     * Set elinGroup value
     * @param \StructType\XFkType $elinGroup
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setElinGroup(\StructType\XFkType $elinGroup = null)
    {
        $this->elinGroup = $elinGroup;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\RGatewayEndpointAnalog
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RGatewayEndpointAnalog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
